/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class NodeIdentifierConfigurationHelper {
    private static final NodeIdentifierNameComparator NODE_IDENTIFIER_COMPARATOR = new NodeIdentifierNameComparator();
    private Collection<DistributedComponentEntry> installations;
    private ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
    private DistributedComponentKnowledge compKnowledge = ((DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class)).getCurrentSnapshot();

    public NodeIdentifierConfigurationHelper() {
        this.installations = this.compKnowledge.getAllInstallations();
    }

    public List<LogicalNodeId> getWorkflowControllerNodesSortedByName() {
        ArrayList<LogicalNodeId> result = new ArrayList<LogicalNodeId>(((WorkflowHostService)this.serviceRegistryAccess.getService(WorkflowHostService.class)).getLogicalWorkflowHostNodes());
        Collections.sort(result, NODE_IDENTIFIER_COMPARATOR);
        return result;
    }

    public Map<LogicalNodeId, Integer> getTargetPlatformsForComponent(ComponentDescription compDesc) {
        return ComponentUtils.getNodesForComponent(this.installations, (ComponentDescription)compDesc);
    }

    public List<LogicalNodeId> sortNodes(List<LogicalNodeId> nodes) {
        Collections.sort(nodes, NODE_IDENTIFIER_COMPARATOR);
        return nodes;
    }

    public synchronized void refreshInstallations() {
        this.compKnowledge = ((DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class)).getCurrentSnapshot();
        this.installations = this.compKnowledge.getAllInstallations();
    }

    private static final class NodeIdentifierNameComparator
    implements Comparator<LogicalNodeId> {
        private static final int LT = -1;
        private static final int GT = 1;

        private NodeIdentifierNameComparator() {
        }

        @Override
        public int compare(LogicalNodeId o1, LogicalNodeId o2) {
            int result = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : o1.getLogicalNodeIdString().compareTo(o2.getLogicalNodeIdString())));
            return result;
        }
    }
}

