/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette;

import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.gui.palette.DistributedComponentKnowledgeSanitizer;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.util.Collection;

public class ComponentKnowledgeUpdateListener
implements DistributedComponentKnowledgeListener {
    private static final int DELAY = 1000;
    private final AsyncTaskService taskService;
    private final PaletteViewContentProvider contentProvider;
    private Collection<DistributedComponentEntry> scheduledNewState = null;
    private DistributedComponentKnowledgeSanitizer sanitizer = new DistributedComponentKnowledgeSanitizer();
    private boolean isPaletteUpdateScheduled = false;

    public ComponentKnowledgeUpdateListener(PaletteViewContentProvider contentProvider) {
        this.taskService = (AsyncTaskService)ServiceRegistry.createPublisherAccessFor((Object)this).getService(AsyncTaskService.class);
        this.contentProvider = contentProvider;
    }

    public synchronized void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
        this.scheduledNewState = this.sanitizer.sanitizeComponentKnowledge(newState);
        if (!this.isPaletteUpdateScheduled) {
            this.taskService.scheduleAfterDelay("update Palette", this::performUpdate, 1000L);
            this.isPaletteUpdateScheduled = true;
        }
    }

    private synchronized void performUpdate() {
        if (!this.contentProvider.getPaletteView().getPaletteTreeViewer().getTree().isDisposed()) {
            this.contentProvider.refreshPaletteView(this.scheduledNewState);
        }
        this.isPaletteUpdateScheduled = false;
    }
}

