/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.ComponentNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.EndpointMappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingType;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;

public class MappingTreeContentProvider
implements ITreeContentProvider {
    private TreeNode root = new TreeNode((Object)"root");
    private String originMappings;

    public Object[] getChildren(Object parent) {
        if (parent.equals(this.root) && this.root.hasChildren()) {
            return Arrays.stream(this.root.getChildren()).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).filter(ComponentNode::hasChildren).toArray();
        }
        if (parent instanceof TreeNode && ((TreeNode)parent).hasChildren()) {
            return ((TreeNode)parent).getChildren();
        }
        return new TreeNode[0];
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public Object getParent(Object object) {
        if (object instanceof MappingNode) {
            return ((MappingNode)object).getParent();
        }
        if (object instanceof ComponentNode) {
            return this.getRoot();
        }
        return false;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof TreeNode) {
            TreeNode node = (TreeNode)object;
            return node.hasChildren();
        }
        return false;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    private List<ComponentNode> getComponentNodes() {
        return Arrays.stream(this.getChildren(this.getRoot())).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).collect(Collectors.toList());
    }

    private List<MappingNode> getAllMappingNodes() {
        return this.getComponentNodes().stream().flatMap(componentNode -> Arrays.stream(componentNode.getChildren())).map(MappingNode.class::cast).collect(Collectors.toList());
    }

    private List<MappingNode> getMappingNodesOfComponent(ComponentNode componentNode) {
        return Arrays.stream(this.getChildren(componentNode)).filter(MappingNode.class::isInstance).map(MappingNode.class::cast).collect(Collectors.toList());
    }

    protected List<String> getMappedNamesOfOtherCheckedNodes(MappingNode node) {
        return this.getAllMappingNodes().stream().filter(node.getClass()::isInstance).filter(n -> !n.equals(node)).filter(MappingNode::isChecked).map(MappingNode::getExternalName).map(String::toLowerCase).collect(Collectors.toList());
    }

    protected boolean hasInvalidMappedNames() {
        return !this.getAllMappingNodes().stream().allMatch(MappingNode::isNameValid);
    }

    protected void updateValidationOfOtherNodes(MappingNode node) {
        List sameTypeNodes = this.getAllMappingNodes().stream().filter(node.getClass()::isInstance).collect(Collectors.toList());
        sameTypeNodes.stream().forEach(n -> n.setNameValid(!n.isChecked() || !this.getMappedNamesOfOtherCheckedNodes((MappingNode)n).contains(n.getExternalName().toLowerCase())));
    }

    public void addInput(ComponentNode componentNode, EndpointDescription input) {
        if (!componentNode.hasChildNode(input.getName(), MappingType.INPUT)) {
            EndpointDefinition.InputDatumHandling handling = null;
            EndpointDefinition.InputExecutionContraint constraint = null;
            if (input.getMetaData().containsKey("usage")) {
                handling = EndpointDefinition.InputDatumHandling.Single;
                constraint = EndpointDefinition.InputExecutionContraint.Required;
            } else {
                handling = input.getMetaDataValue("inputHandling_73b1056e") != null ? EndpointDefinition.InputDatumHandling.valueOf((String)input.getMetaDataValue("inputHandling_73b1056e")) : input.getEndpointDefinition().getDefaultInputDatumHandling();
                constraint = input.getMetaDataValue("inputExecutionConstraint_4aae3eea") != null ? EndpointDefinition.InputExecutionContraint.valueOf((String)input.getMetaDataValue("inputExecutionConstraint_4aae3eea")) : input.getEndpointDefinition().getDefaultInputExecutionConstraint();
            }
            componentNode.addChildNode(MappingNode.createInputMappingNode(componentNode, input.getName(), input.getDataType(), handling, constraint));
        }
    }

    private ComponentNode getComponentNodeOrGenerate(String componentName, WorkflowNodeIdentifier workflowNodeIdentifier) {
        Optional<ComponentNode> node = this.getComponentNode(workflowNodeIdentifier);
        if (node.isPresent()) {
            return node.get();
        }
        ComponentNode newNode = new ComponentNode(this.root, workflowNodeIdentifier, componentName);
        this.addComponentNode(newNode);
        return newNode;
    }

    private Optional<ComponentNode> getComponentNode(WorkflowNodeIdentifier workflowNodeIdentifier) {
        return this.getComponentNodes().stream().filter(n -> n.getWorkflowNodeIdentifier().equals((Object)workflowNodeIdentifier)).findFirst();
    }

    private void addComponentNode(ComponentNode newNode) {
        List children = Arrays.stream(this.getChildren(this.getRoot())).filter(TreeNode.class::isInstance).map(TreeNode.class::cast).collect(Collectors.toList());
        children.add(newNode);
        this.root.setChildren((TreeNode[])children.stream().toArray(TreeNode[]::new));
    }

    public void removeChildNode(ComponentNode componentNode, String nodeName, MappingType mappingType) {
        if (componentNode.hasChildNode(nodeName, mappingType)) {
            componentNode.removeChildNode(nodeName, mappingType);
        }
    }

    public void addOutput(ComponentNode componentNode, EndpointDescription output) {
        if (!componentNode.hasChildNode(output.getName(), MappingType.OUTPUT)) {
            componentNode.addChildNode(MappingNode.createOutputMappingNode(componentNode, output.getName(), output.getDataType()));
        }
    }

    public void removeComponenteNode(WorkflowNodeIdentifier workflowNodeIdentifier) {
        Optional<ComponentNode> node = this.getComponentNode(workflowNodeIdentifier);
        if (node.isPresent()) {
            this.removeComponenteNode(node.get());
        }
    }

    private void removeComponenteNode(ComponentNode componentNode) {
        List children = Arrays.stream(this.root.getChildren()).filter(TreeNode.class::isInstance).map(TreeNode.class::cast).collect(Collectors.toList());
        children.remove(componentNode);
        this.root.setChildren((TreeNode[])children.stream().toArray(TreeNode[]::new));
    }

    private List<MappingNode> getCheckedMappingNodes() {
        return this.getAllMappingNodes().stream().filter(MappingNode::isChecked).collect(Collectors.toList());
    }

    public List<EndpointAdapter> getEndpointAdapters() {
        return this.getCheckedMappingNodes().stream().filter(EndpointMappingNode.class::isInstance).map(EndpointMappingNode.class::cast).map(EndpointMappingNode::getEndpointAdapter).collect(Collectors.toList());
    }

    public void restoreCheckedMappingNodes(List<EndpointAdapter> endpointAdapters) {
        endpointAdapters.stream().forEach(adapter -> {
            Optional<ComponentNode> componentNode = this.getComponentNode(new WorkflowNodeIdentifier(adapter.getWorkflowNodeIdentifier()));
            if (!componentNode.isPresent()) {
                return;
            }
            Optional<EndpointMappingNode> mappingNode = this.getMappingNodesOfComponent(componentNode.get()).stream().filter(EndpointMappingNode.class::isInstance).map(EndpointMappingNode.class::cast).filter(node -> node.getEndpointAdapter().equals(adapter)).findFirst();
            if (mappingNode.isPresent()) {
                mappingNode.get().setChecked(true);
                mappingNode.get().setExternalName(adapter.getExternalName());
            }
        });
        this.originMappings = this.getMappingsAsString();
    }

    protected void updateContent(WorkflowDescription workflow) {
        workflow.getWorkflowNodes().stream().filter(n -> !n.isEnabled()).forEach(n -> {
            workflow.removeWorkflowNodeAndRelatedConnections(n);
            this.removeComponenteNode(n.getIdentifierAsObject());
        });
        for (WorkflowNode node : workflow.getWorkflowNodes()) {
            ComponentNode componentNode = this.getComponentNodeOrGenerate(node.getName(), node.getIdentifierAsObject());
            for (EndpointDescription input : node.getInputDescriptionsManager().getEndpointDescriptions()) {
                if (!input.isConnected()) {
                    this.addInput(componentNode, input);
                    continue;
                }
                this.removeChildNode(componentNode, input.getName(), MappingType.INPUT);
            }
            for (EndpointDescription output : node.getOutputDescriptionsManager().getEndpointDescriptions()) {
                if (!output.isConnected()) {
                    this.addOutput(componentNode, output);
                    continue;
                }
                this.removeChildNode(componentNode, output.getName(), MappingType.OUTPUT);
            }
        }
    }

    public boolean hasChanges() {
        String currentMappings = this.getMappingsAsString();
        return !currentMappings.equals(this.originMappings);
    }

    private String getMappingsAsString() {
        return this.getCheckedMappingNodes().stream().sorted().map(MappingNode::toString).collect(Collectors.joining());
    }
}

