/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OsgiServiceRegistryAccess
implements ServiceRegistryPublisherAccess {
    private static final CounterCategory SERVICE_REGISTRATION_COUNTER = ((StatisticsTrackerService)StaticToolkitHolder.getService(StatisticsTrackerService.class)).getCounterCategory("Additional Service registrations via OsgiServiceRegistryAccess API", StatisticsFilterLevel.DEVELOPMENT);
    private final BundleContext bundleContext;
    private final List<ServiceRegistration<?>> serviceRegistrations = new ArrayList();
    private final List<ServiceReference<?>> serviceReferences = new ArrayList();

    public OsgiServiceRegistryAccess(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> clazz) {
        List<ServiceReference<?>> list = this.serviceReferences;
        synchronized (list) {
            ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz.getName());
            if (serviceReference == null) {
                throw new IllegalStateException("Found no registered service for class " + clazz.getName());
            }
            this.serviceReferences.add(serviceReference);
            return (T)this.bundleContext.getService(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerService(Class<T> clazz, Object implementation) {
        List<ServiceRegistration<?>> list = this.serviceRegistrations;
        synchronized (list) {
            this.serviceRegistrations.add(this.bundleContext.registerService(clazz.getName(), implementation, null));
        }
        SERVICE_REGISTRATION_COUNTER.count(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<ServiceReference<?>> list = this.serviceReferences;
        synchronized (list) {
            for (ServiceReference<?> serviceReference : this.serviceReferences) {
                this.bundleContext.ungetService(serviceReference);
            }
            this.serviceReferences.clear();
        }
        list = this.serviceRegistrations;
        synchronized (list) {
            for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
                serviceRegistration.unregister();
            }
            this.serviceRegistrations.clear();
        }
    }
}

