/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.command;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;

final class EndpointExposureParameter {
    private final String componentId;
    private final String internalEndpointName;
    private final String externalEndpointName;
    private final Optional<Boolean> isInputExposure;

    private EndpointExposureParameter(String componentId, String internalEndpointName, String externalEndpointName, Optional<Boolean> isInputExposure) {
        this.componentId = componentId;
        this.internalEndpointName = internalEndpointName;
        this.externalEndpointName = externalEndpointName;
        this.isInputExposure = isInputExposure;
    }

    public static EndpointExposureParameter buildSimpleInputExposure(String componentId, String endpointName) {
        return new EndpointExposureParameter(componentId, endpointName, endpointName, Optional.of(true));
    }

    public static EndpointExposureParameter buildSimpleOutputExposure(String componentId, String endpointName) {
        return new EndpointExposureParameter(componentId, endpointName, endpointName, Optional.of(false));
    }

    public static EndpointExposureParameter buildSimpleEndpointExposure(String componentId, String endpointName) {
        return new EndpointExposureParameter(componentId, endpointName, endpointName, Optional.empty());
    }

    public static EndpointExposureParameter buildRenamingInputExposure(String componentId, String internalEndpointName, String externalEndpointName) {
        return new EndpointExposureParameter(componentId, internalEndpointName, externalEndpointName, Optional.of(true));
    }

    public static EndpointExposureParameter buildRenamingOutputExposure(String componentId, String internalEndpointName, String externalEndpointName) {
        return new EndpointExposureParameter(componentId, internalEndpointName, externalEndpointName, Optional.of(false));
    }

    public static EndpointExposureParameter buildRenamingEndpointExposure(String componentId, String internalEndpointName, String externalEndpointName) {
        return new EndpointExposureParameter(componentId, internalEndpointName, externalEndpointName, Optional.empty());
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getInternalEndpointName() {
        return this.internalEndpointName;
    }

    public String getExternalEndpointName() {
        return this.externalEndpointName;
    }

    public boolean isInputExposure() {
        return this.isInputExposure.isPresent() && this.isInputExposure.get() != false;
    }

    public boolean isOutputExposure() {
        return this.isInputExposure.isPresent() && this.isInputExposure.get() == false;
    }

    public String toString() {
        String endpointType = !this.isInputExposure.isPresent() ? "endpointExposure" : (this.isInputExposure.get() != false ? "inputExposure" : "outputExposure");
        return StringUtils.format((String)"{%s,componentId=%s,internalEndpointName=%s,externalEndpointName=%s}", (Object[])new Object[]{endpointType, this.componentId, this.internalEndpointName, this.externalEndpointName});
    }
}

