/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator.configuration;

import de.rcenvironment.core.utils.incubator.configuration.ConfigurationInfo;
import de.rcenvironment.core.utils.incubator.configuration.ConfigurationInfoImpl;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configurable;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

public final class ConfigurationIntrospector {
    private static final ConfigurationIntrospector INSTANCE = new ConfigurationIntrospector();

    private ConfigurationIntrospector() {
    }

    public static ConfigurationInfo getConfigurationInfo(Class<?> clazz) {
        return INSTANCE.parse(clazz);
    }

    private BeanInfo getBeanInfo(Class<?> clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private ConfigurationInfo parse(Class<?> clazz) {
        FeatureDescriptor descriptor;
        ConfigurationInfoImpl result = new ConfigurationInfoImpl();
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        EventSetDescriptor propertyChangeEventSetDescriptor = null;
        FeatureDescriptor[] featureDescriptorArray = beanInfo.getEventSetDescriptors();
        int n = featureDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            descriptor = featureDescriptorArray[n2];
            if (PropertyChangeListener.class.isAssignableFrom(descriptor.getListenerType())) {
                propertyChangeEventSetDescriptor = descriptor;
            }
            ++n2;
        }
        featureDescriptorArray = beanInfo.getPropertyDescriptors();
        n = featureDescriptorArray.length;
        n2 = 0;
        while (n2 < n) {
            descriptor = featureDescriptorArray[n2];
            if (this.isConfigurable((PropertyDescriptor)descriptor)) {
                result.addProperty((PropertyDescriptor)descriptor, propertyChangeEventSetDescriptor);
            }
            ++n2;
        }
        return result;
    }

    private boolean isProperty(PropertyDescriptor descriptor) {
        return !"class".equals(descriptor.getName()) && descriptor.getPropertyType() != null;
    }

    private boolean isConfigurable(PropertyDescriptor descriptor) {
        if (!this.isProperty(descriptor)) {
            return false;
        }
        if (descriptor.getReadMethod().isAnnotationPresent(Configurable.class)) {
            Configurable configurable = descriptor.getReadMethod().getAnnotation(Configurable.class);
            return configurable.value();
        }
        return false;
    }
}

