/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;

public class OvalBorderMoveHandle
extends MoveHandle {
    private static final int BORDERWIDTH = 2;

    public OvalBorderMoveHandle(GraphicalEditPart owner) {
        super(owner);
    }

    public Border getBorder() {
        RoundedLineBorder border = new RoundedLineBorder();
        border.setWidth(2);
        return border;
    }

    protected void paintFigure(Graphics graphics) {
        graphics.drawOval(new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height - 1));
    }

    class RoundedLineBorder
    extends LineBorder {
        RoundedLineBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(this.getWidth());
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle rect = RoundedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            rect.setSize(rect.width - 1, rect.height - 1);
            tempRect.setBounds(rect);
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            graphics.setLineStyle(this.getStyle());
            if (this.getColor() != null) {
                graphics.setForegroundColor(this.getColor());
            } else {
                graphics.setForegroundColor(figure.getForegroundColor());
            }
            graphics.drawOval(tempRect);
        }
    }
}

