/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.commands.Messages;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class WorkflowNodeRenameCommand
extends Command {
    private WorkflowNode node;
    private WorkflowDescription wDesc;
    private String name;
    private String oldName;

    public WorkflowNodeRenameCommand(WorkflowNode node, WorkflowDescription wDesc) {
        this.node = node;
        this.wDesc = wDesc;
    }

    public void execute() {
        this.oldName = this.node.getName();
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.name, Messages.enterName, this.oldName, new IInputValidator(){

            public String isValid(String newText) {
                if (!WorkflowNodeRenameCommand.this.oldName.equalsIgnoreCase(newText)) {
                    for (WorkflowNode n : WorkflowNodeRenameCommand.this.wDesc.getWorkflowNodes()) {
                        if (n.getName().equalsIgnoreCase(newText)) {
                            return Messages.renameAlreadyExistsError;
                        }
                        if (!newText.isEmpty()) continue;
                        return Messages.renameEmptyNameError;
                    }
                }
                return null;
            }
        });
        if (dlg.open() == 1) {
            return;
        }
        this.name = dlg.getValue();
        this.redo();
    }

    public void redo() {
        this.node.setName(this.name);
    }

    public void undo() {
        this.node.setName(this.oldName);
    }
}

