/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionClientSideSetup;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionEventHandler;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolExecutionHandle;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.communication.uplink.client.session.internal.ClientSideUplinkSessionParameters;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationRequest;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationResponse;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationRequest;
import de.rcenvironment.core.communication.uplink.network.channel.api.ChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.DocumentationChannelInitiatorEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.DocumentationChannelProviderEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelInitiatorEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelProviderEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.ClientSideUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.communication.uplink.session.internal.AbstractUplinkSessionImpl;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.BlockingResponseMapper;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientSideUplinkSessionImpl
extends AbstractUplinkSessionImpl
implements ClientSideUplinkSession {
    private static final int CHANNEL_REQUEST_RESULT_TIMEOUT = 2000;
    private static final int DOCUMENTATION_REQUEST_RESULT_TIMEOUT = 5000;
    private static final AtomicInteger sharedSessionIdGenerator = new AtomicInteger(0);
    private final String localSessionId;
    private final AsyncTaskService asyncTaskService;
    private final ClientSideUplinkSessionParameters sessionParameters;
    private final ClientSideUplinkSessionEventHandler sessionEventHandler;
    private final ClientSideUplinkLowLevelProtocolWrapper lowLevelProtocolWrapper;
    private final UplinkProtocolMessageConverter messageConverter = new UplinkProtocolMessageConverter("client side");
    private final BlockingResponseMapper<String, Object> responseMapper;
    private final Map<Long, ChannelEndpoint> channelEndpointMap = Collections.synchronizedMap(new HashMap());
    private final DefaultChannelClientEndpoint defaultChannelEndpoint;
    private final AtomicInteger requestIdCounter = new AtomicInteger(0);

    public ClientSideUplinkSessionImpl(UplinkConnection connection, ClientSideUplinkSessionParameters sessionParameters, ClientSideUplinkSessionEventHandler eventHandler, ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        super(concurrencyUtilsFactory);
        this.localSessionId = Integer.toString(sharedSessionIdGenerator.incrementAndGet());
        this.updateLogDescriptor();
        this.lowLevelProtocolWrapper = new ClientSideUplinkLowLevelProtocolWrapper(connection, new LowLevelConnectionEventHandlerImpl());
        this.sessionParameters = sessionParameters;
        this.sessionEventHandler = eventHandler;
        this.asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
        this.responseMapper = concurrencyUtilsFactory.createBlockingResponseMapper();
        this.defaultChannelEndpoint = new DefaultChannelClientEndpoint(this);
    }

    @Override
    public void runSession() throws IOException {
        this.lowLevelProtocolWrapper.runSession();
    }

    @Override
    public void publishToolDescriptorListUpdate(ToolDescriptorListUpdate update) throws IOException {
        MessageBlock messageBlock = this.messageConverter.encodeToolDescriptorListUpdate(update);
        this.enqueueMessageBlockForSending(0L, messageBlock);
    }

    @Override
    public Optional<ToolExecutionHandle> initiateToolExecution(ToolExecutionClientSideSetup executionSetup, ToolExecutionEventHandler executionEventHandler) {
        Optional<ChannelCreationResponse> result;
        try {
            result = this.performChannelCreationRequest(executionSetup.getDestinationId(), "exec", "tool execution");
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.log.error((Object)"Error opening a tool execution channel", (Throwable)e);
            return Optional.empty();
        }
        if (!result.isPresent()) {
            return Optional.empty();
        }
        long relayAssignedChannelId = result.get().getChannelId();
        ToolExecutionChannelInitiatorEndpoint initiatorEndpoint = new ToolExecutionChannelInitiatorEndpoint(this, relayAssignedChannelId, this.sessionEventHandler);
        this.channelEndpointMap.put(relayAssignedChannelId, initiatorEndpoint);
        try {
            initiatorEndpoint.initiateToolExecution(new ToolExecutionRequest(executionSetup.getExecutionRequest()), executionEventHandler);
        }
        catch (IOException e) {
            executionEventHandler.onError("Exception while initiating the tool execution: " + e);
            return Optional.empty();
        }
        return Optional.of(initiatorEndpoint.getExecutionHandle());
    }

    @Override
    public Optional<SizeValidatedDataSource> fetchDocumentationData(String destinationId, String docReferenceId) {
        try {
            Optional<ChannelCreationResponse> result = this.performChannelCreationRequest(destinationId, "docs", "documentation fetching");
            if (!result.isPresent()) {
                return Optional.empty();
            }
            long relayAssignedChannelId = result.get().getChannelId();
            this.channelEndpointMap.put(relayAssignedChannelId, new DocumentationChannelInitiatorEndpoint(this, relayAssignedChannelId, optionalDocumentationStream -> this.responseMapper.registerResponse((Object)("channel_" + relayAssignedChannelId), optionalDocumentationStream)));
            this.enqueueMessageBlockForSending(relayAssignedChannelId, this.messageConverter.encodeDocumentationRequest(new ToolDocumentationRequest(docReferenceId)));
            Optional optionalDocResponse = (Optional)this.responseMapper.registerRequest((Object)("channel_" + relayAssignedChannelId), 5000).get();
            if (!optionalDocResponse.isPresent()) {
                return Optional.empty();
            }
            return (Optional)optionalDocResponse.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.log.error((Object)("Error retrieving documentation data for id " + docReferenceId + " from " + destinationId), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public CommonUplinkLowLevelProtocolWrapper getProtocolWrapper() {
        return this.lowLevelProtocolWrapper;
    }

    @Override
    public String getLocalSessionId() {
        return this.localSessionId;
    }

    @Override
    public void close() {
        this.markAsCloseRequestedLocally();
    }

    private String generateRequestId() {
        return Integer.toString(this.requestIdCounter.incrementAndGet());
    }

    private Optional<ChannelCreationResponse> performChannelCreationRequest(String destinationId, String channelType, String intention) throws IOException, InterruptedException, ExecutionException {
        String requestId = this.generateRequestId();
        ChannelCreationRequest request = new ChannelCreationRequest(channelType, destinationId, -1L, requestId);
        this.lowLevelProtocolWrapper.sendMessageBlock(0L, this.messageConverter.encodeChannelCreationRequest(request));
        Optional optionalResponse = (Optional)this.responseMapper.registerRequest((Object)requestId, 2000).get();
        if (!optionalResponse.isPresent()) {
            this.log.warn((Object)("Attempted to open a message channel for " + intention + ", but received no response within the given timeout"));
            return Optional.empty();
        }
        ChannelCreationResponse response = (ChannelCreationResponse)optionalResponse.get();
        if (!response.isSuccess()) {
            this.log.warn((Object)("Failed to open a message channel for " + intention + "; if you have access to the relay's log files, " + "you may inspect them for details"));
            return Optional.empty();
        }
        this.log.debug((Object)("Successfully opened channel " + response.getChannelId() + " for " + intention));
        return Optional.of(response);
    }

    @Override
    public synchronized void markAsCloseRequestedByRemoteEvent() {
        if (this.getState() == UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY) {
            this.setSessionState(UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR);
        }
        super.markAsCloseRequestedByRemoteEvent();
    }

    @Override
    protected void onSessionStateChanged(UplinkSessionState oldState, UplinkSessionState newState) {
        if (newState == UplinkSessionState.ACTIVE) {
            this.sessionEventHandler.onSessionReady(this.getAssignedNamespaceId(), this.getDestinationIdPrefix());
        }
        if (oldState == UplinkSessionState.ACTIVE) {
            this.sessionEventHandler.onSessionTerminating();
        }
        if (newState == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR || newState == UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL || newState == UplinkSessionState.FULLY_CLOSED && oldState != UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL) {
            this.lowLevelProtocolWrapper.closeOutgoingMessageStream();
        }
        if (newState == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR || newState == UplinkSessionState.FULLY_CLOSED) {
            this.sessionEventHandler.onSessionInFinalState();
        }
    }

    public class DefaultChannelClientEndpoint
    extends AbstractChannelEndpoint {
        public DefaultChannelClientEndpoint(ClientSideUplinkSession session) {
            super(session, session.getLocalSessionId(), 0L);
        }

        @Override
        protected boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
            MessageType messageType = messageBlock.getType();
            switch (messageType) {
                case TOOL_DESCRIPTOR_LIST_UPDATE: {
                    ToolDescriptorListUpdate update = this.messageConverter.decodeToolDescriptorListUpdate(messageBlock);
                    ClientSideUplinkSessionImpl.this.sessionEventHandler.processToolDescriptorListUpdate(update);
                    return true;
                }
                case CHANNEL_INIT: {
                    String channelType;
                    ChannelCreationRequest request = this.messageConverter.decodeChannelCreationRequest(messageBlock);
                    long relayProvidedChannelId = request.getChannelId();
                    switch (channelType = request.getType()) {
                        case "docs": {
                            ClientSideUplinkSessionImpl.this.channelEndpointMap.put(relayProvidedChannelId, new DocumentationChannelProviderEndpoint(ClientSideUplinkSessionImpl.this, relayProvidedChannelId, ClientSideUplinkSessionImpl.this.sessionEventHandler, request.getDestinationId()));
                            break;
                        }
                        case "exec": {
                            ClientSideUplinkSessionImpl.this.channelEndpointMap.put(relayProvidedChannelId, new ToolExecutionChannelProviderEndpoint(ClientSideUplinkSessionImpl.this, relayProvidedChannelId, ClientSideUplinkSessionImpl.this.sessionEventHandler, request.getDestinationId()));
                            break;
                        }
                        default: {
                            this.log.error((Object)("Ignoring channel request for invalid type " + channelType));
                            return true;
                        }
                    }
                    this.log.debug((Object)("Accepting offered message channel " + relayProvidedChannelId + " of type '" + channelType + "'"));
                    ChannelCreationResponse responseToSend = new ChannelCreationResponse(relayProvidedChannelId, request.getRequestId(), true);
                    this.enqueueMessageBlockForSending(this.messageConverter.encodeChannelCreationResponse(responseToSend));
                    return true;
                }
                case CHANNEL_INIT_RESPONSE: {
                    ChannelCreationResponse receivedResponse = this.messageConverter.decodeChannelCreationResponse(messageBlock);
                    ClientSideUplinkSessionImpl.this.responseMapper.registerResponse((Object)receivedResponse.getRequestId(), (Object)receivedResponse);
                    return true;
                }
            }
            this.log.warn((Object)("Ignoring message of unhandled type " + (Object)((Object)messageType)));
            return true;
        }

        @Override
        public void dispose() {
        }
    }

    private final class LowLevelConnectionEventHandlerImpl
    implements UplinkConnectionLowLevelEventHandler {
        private LowLevelConnectionEventHandlerImpl() {
        }

        @Override
        public void provideOrProcessHandshakeData(Map<String, String> incomingData, Map<String, String> outgoingData) {
            if (incomingData == null || outgoingData != null) {
                outgoingData.put("protocolVersion", "alpha6");
                String sessionQualifier = StringUtils.nullSafe((String)ClientSideUplinkSessionImpl.this.sessionParameters.getSessionQualifier(), (String)"default");
                outgoingData.put("sessionQualifier", sessionQualifier);
                if (ClientSideUplinkSessionImpl.this.sessionParameters.getCustomHandshakeData() != null) {
                    outgoingData.putAll(ClientSideUplinkSessionImpl.this.sessionParameters.getCustomHandshakeData());
                }
                ClientSideUplinkSessionImpl.this.markClientHandshakeSentOrReceived();
            } else if (incomingData != null || outgoingData == null) {
                ClientSideUplinkSessionImpl.this.markServerHandshakeSentOrReceived();
                String serverAssignedNamespaceId = incomingData.get("namespace");
                if (StringUtils.isNullorEmpty((String)serverAssignedNamespaceId)) {
                    serverAssignedNamespaceId = "<error: handshake data did not include a namespace id>/";
                    ClientSideUplinkSessionImpl.this.setSessionState(UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR);
                } else {
                    ClientSideUplinkSessionImpl.this.setAssignedNamespaceId(serverAssignedNamespaceId);
                    ClientSideUplinkSessionImpl.this.updateLogDescriptor();
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void onHandshakeComplete() {
            ClientSideUplinkSessionImpl.this.setSessionState(UplinkSessionState.ACTIVE);
        }

        @Override
        public void onMessageBlock(long channelId, MessageBlock messageBlock) {
            ClientSideUplinkSessionImpl.this.incomingMessageQueue.enqueue(() -> {
                try {
                    if (channelId == 0L) {
                        ClientSideUplinkSessionImpl.this.defaultChannelEndpoint.processMessage(messageBlock);
                    } else {
                        ChannelEndpoint channelEndpoint = (ChannelEndpoint)ClientSideUplinkSessionImpl.this.channelEndpointMap.get(channelId);
                        if (channelEndpoint == null) {
                            ClientSideUplinkSessionImpl.this.log.error((Object)StringUtils.format((String)"Received a message of type %s for channel %d but found no registered endpoint to handle it", (Object[])new Object[]{messageBlock.getType(), channelId}));
                            return;
                        }
                        channelEndpoint.processMessage(messageBlock);
                    }
                }
                catch (IOException e) {
                    ClientSideUplinkSessionImpl.this.log.error((Object)("Error while processing incoming message of type " + (Object)((Object)messageBlock.getType()) + ", closing session"), (Throwable)e);
                }
            });
        }

        @Override
        public void onRegularGoodbyeMessage() {
            ClientSideUplinkSessionImpl.this.markAsCloseRequestedByRemoteEvent();
        }

        @Override
        public void onErrorGoodbyeMessage(UplinkProtocolErrorType errorType, String errorMessage) {
            ClientSideUplinkSessionImpl.this.sessionEventHandler.registerConnectionOrSessionError(errorType, "Connection closed by the remote side: " + errorMessage);
            ClientSideUplinkSessionImpl.this.markAsCloseRequestedByRemoteEvent();
        }

        @Override
        public void onNonProtocolError(IOException exception) {
            ClientSideUplinkSessionImpl.this.sessionEventHandler.registerConnectionOrSessionError(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Closing the Uplink connection after an error: " + exception.toString());
            ClientSideUplinkSessionImpl.this.markAsCloseRequestedByRemoteEvent();
        }
    }
}

