/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.profile;

import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;

public class CommonProfile {
    public static final Integer PROFILE_VERSION_NUMBER = 2;
    public static final String PROFILE_DIR_LOCK_FILE_NAME = "instance.lock";
    public static final String PROFILE_VERSION_FILE_NAME = "profile.version";
    public static final String PROFILE_INTERNAL_DATA_SUBDIR = "internal";
    private File profileDirectory;
    private FileLock lock;
    private RandomAccessFile randomAccessLockFile;

    protected CommonProfile(File profileDirectory) {
        this.profileDirectory = profileDirectory;
    }

    protected File getVersionFile() {
        return this.getInternalDirectory().toPath().resolve(PROFILE_VERSION_FILE_NAME).toFile();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CommonProfile)) {
            return false;
        }
        try {
            return ((CommonProfile)other).getProfileDirectory().getCanonicalFile().equals(this.getProfileDirectory().getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        throw new IllegalStateException("Not implemented.");
    }

    public String getName() {
        return this.profileDirectory.getName();
    }

    public int getVersion() throws ProfileException {
        int versionFileContentNumber;
        File versionFile = this.getVersionFile();
        if (!versionFile.exists()) {
            return 0;
        }
        try {
            String versionFileContent = new String(Files.readAllBytes(versionFile.toPath()));
            versionFileContentNumber = Integer.parseInt(versionFileContent.trim());
        }
        catch (IOException | NumberFormatException e) {
            throw new ProfileException(String.format("Could not read profile version of profile \"%s\".", this.getName()), e);
        }
        if (1 <= versionFileContentNumber && versionFileContentNumber <= 2) {
            return versionFileContentNumber;
        }
        throw new ProfileException(String.format("Version file of profile \"%s\" contained invalid profile version: %d.", this.getName(), versionFileContentNumber));
    }

    public File getProfileDirectory() {
        return this.profileDirectory;
    }

    public File getInternalDirectory() {
        return this.getProfileDirectory().toPath().resolve(PROFILE_INTERNAL_DATA_SUBDIR).toFile();
    }

    public boolean attemptToLockProfileDirectory() throws ProfileException {
        File lockfile = new File(this.profileDirectory, PROFILE_DIR_LOCK_FILE_NAME);
        this.lock = null;
        try {
            lockfile.createNewFile();
            this.randomAccessLockFile = new RandomAccessFile(lockfile, "rw");
            this.lock = this.randomAccessLockFile.getChannel().tryLock();
        }
        catch (IOException | OverlappingFileLockException exception) {
            throw new ProfileException("Unexpected error when trying to acquire a file lock on " + lockfile);
        }
        return this.lock != null;
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    public void releaseLock() throws IOException {
        if (this.isLocked()) {
            this.lock.release();
        }
        if (this.randomAccessLockFile != null) {
            this.randomAccessLockFile.close();
        }
    }

    public boolean hasCurrentVersion() throws ProfileException {
        return this.getVersion() == PROFILE_VERSION_NUMBER.intValue();
    }

    public boolean hasUpgradeableVersion() throws ProfileException {
        return this.getVersion() < PROFILE_VERSION_NUMBER;
    }

    public void upgradeToCurrentVersion() throws IOException {
        File versionFile = this.getVersionFile();
        if (!versionFile.exists() && !versionFile.createNewFile()) {
            throw new IOException(String.format("Could not create version file for profile \"%s\"", this.getProfileDirectory().getName()));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(versionFile);){
            fw.write(String.valueOf(PROFILE_VERSION_NUMBER));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class Builder {
        private static final String COMMON_PROFILE_DIR_NAME = "common";
        private final File profileDirectory;
        private boolean create = false;
        private boolean migrate = false;

        public Builder(File profileDirectoryParam) {
            this.profileDirectory = profileDirectoryParam;
        }

        public Builder create(boolean createParam) {
            this.create = createParam;
            return this;
        }

        public Builder migrate(boolean migrateParam) {
            this.migrate = migrateParam;
            return this;
        }

        public CommonProfile build() throws ProfileException {
            this.processBuildOptions();
            if (this.profileDirectory.getName().equals(COMMON_PROFILE_DIR_NAME)) {
                return this.constructCommonProfile();
            }
            return this.constructUserProfile();
        }

        public CommonProfile buildCommonProfile() throws ProfileException {
            this.processBuildOptions();
            if (!this.profileDirectory.getName().equals(COMMON_PROFILE_DIR_NAME)) {
                throw new ProfileException(String.format("Cannot construct a \"common\" profile using the backing directory \"%s\": Profile directory containing the \"common\" profile must be called \"common\".", this.profileDirectory.getAbsolutePath()));
            }
            return this.constructCommonProfile();
        }

        public Profile buildUserProfile() throws ProfileException {
            this.processBuildOptions();
            if (this.profileDirectory.getName().equals(COMMON_PROFILE_DIR_NAME)) {
                throw new ProfileException(String.format("Cannot construct a user profile using the backing directory \"%s\": Profile directory containing user profiles must not be called \"common\".The profile \"common\" is reserved for cross-profile settings.", this.profileDirectory.getAbsolutePath()));
            }
            return this.constructUserProfile();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processBuildOptions() throws ProfileException {
            this.ensureProfileDirectoryExists();
            this.ensureProfileDirectoryIsInitialized();
            if (!this.isValidProfileDirectory()) {
                throw new ProfileException(StringUtils.format((String)"The profile at \"%s\" is corrupted or of a future profile version. \n Note: It is not possible to use current profiles for older versions of RCE.", (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
            }
            if (!this.migrate || !this.isLegacyProfile() && !this.isProfileVersion1()) return;
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    FileWriter fw = new FileWriter(this.getVersionFile(), false);
                    try {
                        try (BufferedWriter bw = new BufferedWriter(fw);){
                            bw.write(String.valueOf(2));
                        }
                        if (fw == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fw == null) throw throwable;
                        fw.close();
                        throw throwable;
                    }
                    fw.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                String errorMessage = String.format("Could not upgrade the profile \"%s\" at \"%s\" to the most current profile version.", this.profileDirectory.getName(), this.profileDirectory.getAbsolutePath());
                throw new ProfileException(errorMessage, e);
            }
        }

        private CommonProfile constructCommonProfile() throws ProfileException {
            if (this.isValidProfileDirectory()) {
                return new CommonProfile(this.profileDirectory);
            }
            throw new ProfileException(String.format("Profile at \"%s\" has unknown version number.", this.profileDirectory.getAbsolutePath()));
        }

        private Profile constructUserProfile() throws ProfileException {
            if (this.isValidProfileDirectory()) {
                return new Profile(this.profileDirectory);
            }
            throw new ProfileException(String.format("Profile at \"%s\" has unknown version number.", this.profileDirectory.getAbsolutePath()));
        }

        private void ensureProfileDirectoryIsInitialized() throws ProfileException {
            if (this.profileDirectoryIsFunctionallyEmpty()) {
                if (this.create) {
                    try {
                        this.initializeProfileDirectory();
                    }
                    catch (IOException e) {
                        throw new ProfileException(String.format("Could not initialize profile directory for profile \"%s\"", this.profileDirectory.getName()), e);
                    }
                } else {
                    throw new ProfileException(String.format("Profile directory \"%s\" is functionally empty, but user did not request creation of the profile", this.profileDirectory.getName()));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void ensureProfileDirectoryExists() throws ProfileException {
            if (!this.profileDirectory.exists()) {
                if (!this.create) throw new ProfileException(String.format("Profile directory \"%s\" does not exist, but user did not request creation of the profile", this.profileDirectory.getName()));
                try {
                    this.createProfileDirectory();
                    return;
                }
                catch (IOException e) {
                    throw new ProfileException(String.format("Could not create profile directory for profile \"%s\"", this.profileDirectory.getName()), e);
                }
            } else {
                if (!this.profileDirectory.isFile()) return;
                throw new ProfileException(String.format("Cannot use the path \"%s\" as a profile location, since it points to a file. Profile path must point to a directory.", this.profileDirectory.getAbsolutePath()));
            }
        }

        private boolean profileDirectoryIsFunctionallyEmpty() throws ProfileException {
            if (!this.profileDirectory.exists()) {
                return false;
            }
            if (!this.profileDirectory.isDirectory()) {
                return false;
            }
            String[] profileDirectoryContents = this.profileDirectory.list();
            if (profileDirectoryContents == null) {
                throw new ProfileException(String.format("Could not determine contents of profile directory %s", this.profileDirectory.getName()));
            }
            if (profileDirectoryContents.length == 0) {
                return true;
            }
            if (profileDirectoryContents.length == 1) {
                File singleElement = this.profileDirectory.toPath().resolve(profileDirectoryContents[0]).toFile();
                boolean singleElementIsStartupLogsDirectory = singleElement.isDirectory() && singleElement.getName().equals("startup_logs");
                return singleElementIsStartupLogsDirectory;
            }
            if (profileDirectoryContents.length == 3) {
                File oldLockFile = new File(this.profileDirectory, CommonProfile.PROFILE_DIR_LOCK_FILE_NAME);
                if (!oldLockFile.isFile()) {
                    return false;
                }
                File debugLog = new File(this.profileDirectory, "shutdown-debug.log");
                if (!debugLog.isFile()) {
                    return false;
                }
                File warningsLog = new File(this.profileDirectory, "shutdown-warnings.log");
                return warningsLog.isFile();
            }
            return false;
        }

        private boolean isValidProfileDirectory() {
            int versionFileContentNumber;
            if (!this.profileDirectory.exists() || !this.profileDirectory.isDirectory()) {
                return false;
            }
            File internalDirectory = this.getInternalDirectory();
            if (!internalDirectory.exists()) {
                return true;
            }
            if (!internalDirectory.isDirectory()) {
                return false;
            }
            File versionFile = this.getVersionFile();
            if (!versionFile.exists()) {
                return true;
            }
            try {
                versionFileContentNumber = this.tryReadAndParseVersionNumber(versionFile);
            }
            catch (IOException | NumberFormatException exception) {
                return false;
            }
            return 1 <= versionFileContentNumber && versionFileContentNumber <= 2;
        }

        private int tryReadAndParseVersionNumber(File versionFile) throws IOException {
            String versionFileContent = new String(Files.readAllBytes(versionFile.toPath()));
            return Integer.parseInt(versionFileContent.trim());
        }

        private boolean isLegacyProfile() {
            if (!this.profileDirectory.isDirectory()) {
                return false;
            }
            File internalDirectory = this.getInternalDirectory();
            if (!internalDirectory.exists()) {
                return true;
            }
            if (!internalDirectory.isDirectory()) {
                return false;
            }
            File profileVersionFile = this.getVersionFile();
            return !profileVersionFile.exists();
        }

        private boolean isProfileVersion1() {
            int versionFileContentNumber;
            if (!this.profileDirectory.isDirectory()) {
                return false;
            }
            File internalDirectory = this.profileDirectory.toPath().resolve(CommonProfile.PROFILE_INTERNAL_DATA_SUBDIR).toFile();
            if (!internalDirectory.isDirectory()) {
                return false;
            }
            File versionFile = internalDirectory.toPath().resolve(CommonProfile.PROFILE_VERSION_FILE_NAME).toFile();
            if (!versionFile.isFile()) {
                return false;
            }
            try {
                versionFileContentNumber = this.tryReadAndParseVersionNumber(versionFile);
            }
            catch (IOException | NumberFormatException exception) {
                return false;
            }
            return versionFileContentNumber == 1;
        }

        private boolean isProfileVersion2() {
            int versionFileContentNumber;
            if (!this.profileDirectory.isDirectory()) {
                return false;
            }
            File internalDirectory = this.getInternalDirectory();
            if (!internalDirectory.isDirectory()) {
                return false;
            }
            File versionFile = this.getVersionFile();
            if (!versionFile.isFile()) {
                return false;
            }
            try {
                versionFileContentNumber = this.tryReadAndParseVersionNumber(versionFile);
            }
            catch (IOException | NumberFormatException exception) {
                return false;
            }
            return versionFileContentNumber == 2;
        }

        private void createProfileDirectory() throws IOException {
            if (!this.profileDirectory.mkdir()) {
                throw new IOException(String.format("Could not create profile directory for profile \"%s\": File.mkdir() returned false for path %s.", this.profileDirectory.getName(), this.profileDirectory.getAbsolutePath()));
            }
        }

        private void initializeProfileDirectory() throws IOException {
            File internalDirectory = this.getInternalDirectory();
            if (!internalDirectory.mkdir()) {
                throw new IOException(String.format("Could not create profile directory for profile \"%s\": File.mkdir() returned false for path %s.", this.profileDirectory.getName(), internalDirectory.getAbsolutePath()));
            }
            File versionFile = this.getVersionFile();
            if (!versionFile.createNewFile()) {
                throw new IOException(String.format("Could not create version file for profile \"%s\": File.createNewFile() returned false for path %s.", this.profileDirectory.getName(), versionFile.getAbsolutePath()));
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileWriter writer = new FileWriter(versionFile);){
                    writer.write(String.valueOf(Profile.PROFILE_VERSION_NUMBER));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not write version number to file \"profile.version\" for profile \"%s\".", this.profileDirectory.getName()), e);
            }
        }

        private File getInternalDirectory() {
            return this.profileDirectory.toPath().resolve(CommonProfile.PROFILE_INTERNAL_DATA_SUBDIR).toFile();
        }

        private File getVersionFile() {
            return this.getInternalDirectory().toPath().resolve(CommonProfile.PROFILE_VERSION_FILE_NAME).toFile();
        }
    }
}

