/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public class Button
extends AbstractInteractableComponent {
    private Label buttonLabel;
    private Action onPressEvent;

    public Button(String text) {
        this(text, new Action(){

            @Override
            public void doAction() {
            }
        });
    }

    public Button(String text, Action onPressEvent) {
        this.onPressEvent = onPressEvent;
        this.buttonLabel = new Label(text);
        this.buttonLabel.setStyle(Theme.Category.BUTTON_LABEL_INACTIVE);
        if (this.onPressEvent == null) {
            this.onPressEvent = new Action(){

                @Override
                public void doAction() {
                }
            };
        }
    }

    @Override
    public void repaint(TextGraphics graphics) {
        if (this.hasFocus()) {
            graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.BUTTON_ACTIVE));
        } else {
            graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.BUTTON_INACTIVE));
        }
        TerminalSize preferredSize = this.calculatePreferredSize();
        graphics = this.transformAccordingToAlignment(graphics, preferredSize);
        if (graphics.getWidth() < preferredSize.getColumns()) {
            graphics.drawString(0, 0, "< ", new ScreenCharacterStyle[0]);
            graphics.drawString(graphics.getWidth() - 2, 0, " >", new ScreenCharacterStyle[0]);
            int allowedSize = graphics.getWidth() - 4;
            if (allowedSize > 0) {
                TextGraphics subGraphics = graphics.subAreaGraphics(new TerminalPosition(2, 0), new TerminalSize(allowedSize, this.buttonLabel.getPreferredSize().getRows()));
                this.buttonLabel.repaint(subGraphics);
            }
        } else {
            int leftPosition = (graphics.getWidth() - preferredSize.getColumns()) / 2;
            graphics.drawString(leftPosition, 0, "< ", new ScreenCharacterStyle[0]);
            TerminalSize labelPrefSize = this.buttonLabel.getPreferredSize();
            TextGraphics subGraphics = graphics.subAreaGraphics(new TerminalPosition(leftPosition + 2, 0), new TerminalSize(labelPrefSize.getColumns(), labelPrefSize.getRows()));
            this.buttonLabel.repaint(subGraphics);
            graphics.drawString(leftPosition + 2 + labelPrefSize.getColumns(), 0, " >", new ScreenCharacterStyle[0]);
        }
        this.setHotspot(null);
    }

    public void setText(String text) {
        this.buttonLabel.setText(text);
    }

    public String getText() {
        return this.buttonLabel.getText();
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        TerminalSize labelSize = this.buttonLabel.getPreferredSize();
        return new TerminalSize(labelSize.getColumns() + 2 + 2, labelSize.getRows());
    }

    @Override
    public void afterEnteredFocus(Interactable.FocusChangeDirection direction) {
        this.buttonLabel.setStyle(Theme.Category.BUTTON_LABEL_ACTIVE);
    }

    @Override
    public void afterLeftFocus(Interactable.FocusChangeDirection direction) {
        this.buttonLabel.setStyle(Theme.Category.BUTTON_LABEL_INACTIVE);
    }

    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        switch (key.getKind()) {
            case Enter: {
                this.onPressEvent.doAction();
                return Interactable.Result.EVENT_HANDLED;
            }
            case ArrowDown: {
                return Interactable.Result.NEXT_INTERACTABLE_DOWN;
            }
            case ArrowRight: 
            case Tab: {
                return Interactable.Result.NEXT_INTERACTABLE_RIGHT;
            }
            case ArrowUp: {
                return Interactable.Result.PREVIOUS_INTERACTABLE_UP;
            }
            case ArrowLeft: 
            case ReverseTab: {
                return Interactable.Result.PREVIOUS_INTERACTABLE_LEFT;
            }
        }
        return Interactable.Result.EVENT_NOT_HANDLED;
    }
}

