/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.mail.Mail;
import de.rcenvironment.core.mail.MailDispatchResult;
import de.rcenvironment.core.mail.MailDispatchResultListener;
import de.rcenvironment.core.mail.MailService;
import de.rcenvironment.core.mail.SMTPServerConfiguration;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.concurrent.Future;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import jodd.mail.Email;
import jodd.mail.MailException;
import jodd.mail.SendMailSession;
import jodd.mail.SmtpSslServer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MailServiceImpl
implements MailService {
    private Log log = LogFactory.getLog(MailServiceImpl.class);
    private ConfigurationService configurationService;
    private SMTPServerConfiguration mailConfiguration;
    private boolean configured = false;
    private boolean trustAllCertificates = false;

    public void activate() {
        ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("smtpServer");
        if (configurationSegment == null || !configurationSegment.isPresentInCurrentConfiguration()) {
            this.configured = false;
            this.log.debug((Object)"MailService not started as there is no mail configuration at all.");
        } else {
            this.mailConfiguration = new SMTPServerConfiguration(configurationSegment, SMTPServerConfiguration.getMailFilterInformation(this.configurationService));
            try {
                this.mailConfiguration.isValid();
                this.configured = true;
                this.log.debug((Object)"MailService is configured.");
            }
            catch (ConfigurationException e) {
                this.configured = false;
                this.log.error((Object)StringUtils.format((String)"MailService is not successfully configured since the configuration is invalid: %s ", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    @Override
    public Future<?> sendMail(Mail mail, MailDispatchResultListener listener) {
        if (!this.configured) {
            listener.receiveResult(MailDispatchResult.FAILURE_MAIL_SERVICE_NOT_CONFIGURED, null);
            return ConcurrentUtils.constantFuture(null);
        }
        MailSendingHandler mailSendingTask = new MailSendingHandler(mail, listener);
        return ConcurrencyUtils.getAsyncTaskService().submit((Runnable)mailSendingTask);
    }

    public boolean canConnectToServer() {
        if (!this.configured) {
            this.log.error((Object)"SMTP server is not configured.");
            return false;
        }
        try {
            this.smtpServerAction(null);
        }
        catch (MailException e) {
            this.log.error((Object)"Unable to contact the configured SMTP server.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void smtpServerAction(Email mail) throws MailException {
        try (SendMailSession session = null;){
            SmtpSslServer server = (SmtpSslServer)new SmtpSslServer(this.mailConfiguration.getHost(), this.mailConfiguration.getPort()).authenticateWith(this.mailConfiguration.getUsername(), this.mailConfiguration.getPassword());
            if ("explicit".equals(this.mailConfiguration.getEncryption())) {
                server.startTlsRequired(true);
                server.plaintextOverTLS(true);
            }
            if (this.trustAllCertificates) {
                server.property("mail.smtp.ssl.trust", "*");
            }
            session = server.createSession();
            session.open();
            if (mail != null) {
                mail.from(this.mailConfiguration.getSender());
                session.sendMail(mail);
            }
        }
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    void trustAllCertificates() {
        this.trustAllCertificates = true;
    }

    private class MailSendingHandler
    implements Runnable {
        private static final String CAN_T_SEND_COMMAND_TO_SMTP_HOST = "Can't send command to SMTP host";
        private static final String INTERRUPTED_WHILE_WAITING = "Mail delivery was interrupted while waiting for the next attempt.";
        private static final int SEC_TO_MILLIS = 1000;
        private static final String SEND_FAILED = "Sending mail failed.";
        private static final int AUTO_RETRY_INITIAL_DELAY_MILLIS = 5000;
        private static final double AUTO_RETRY_DELAY_MULTIPLIER = 1.5;
        private static final int AUTO_RETRY_MAX_DELAY_MILLIS = 300000;
        private Email mail;
        private MailDispatchResultListener listener;
        private int consecutiveConnectionFailures;

        MailSendingHandler(Mail mail, MailDispatchResultListener listener) {
            this.mail = mail.getMail();
            this.listener = listener;
            this.consecutiveConnectionFailures = 0;
        }

        @Override
        @TaskDescription(value="Sending mail")
        public void run() {
            boolean success = false;
            boolean permFailed = false;
            String permFailedMessage = null;
            while (!success && !permFailed) {
                block10: {
                    try {
                        MailServiceImpl.this.smtpServerAction(this.mail);
                        success = true;
                    }
                    catch (MailException e) {
                        MailServiceImpl.this.log.error((Object)SEND_FAILED, (Throwable)e);
                        success = false;
                        ++this.consecutiveConnectionFailures;
                        permFailed = this.isMailExceptionCausedByPermError(e);
                        if (!permFailed) break block10;
                        permFailedMessage = e.getCause().getMessage();
                    }
                }
                if (this.listener != null) {
                    if (success) {
                        this.listener.receiveResult(MailDispatchResult.SUCCESS, null);
                    } else if (permFailed) {
                        MailServiceImpl.this.log.debug((Object)StringUtils.format((String)"Sending %s to MailDispatchResultListener.", (Object[])new Object[]{MailDispatchResult.FAILURE.toString()}));
                        this.listener.receiveResult(MailDispatchResult.FAILURE, permFailedMessage);
                    } else {
                        this.listener.receiveResult(MailDispatchResult.FAILURE_RETRY, null);
                    }
                }
                if (success || permFailed) continue;
                try {
                    long autoRetryDelay = this.calculateNextAutoRetryDelay();
                    MailServiceImpl.this.log.debug((Object)StringUtils.format((String)"Retrying mail delivery in %d seconds.", (Object[])new Object[]{autoRetryDelay / 1000L}));
                    Thread.sleep(autoRetryDelay);
                    MailServiceImpl.this.log.debug((Object)("Thread.currentThread().isInterrupted(): " + Thread.currentThread().isInterrupted()));
                }
                catch (InterruptedException interruptedException) {
                    MailServiceImpl.this.log.debug((Object)INTERRUPTED_WHILE_WAITING);
                    this.listener.receiveResult(MailDispatchResult.FAILURE, INTERRUPTED_WHILE_WAITING);
                    return;
                }
            }
        }

        private long calculateNextAutoRetryDelay() {
            long targetDelay = Math.round(5000.0 * Math.pow(1.5, this.consecutiveConnectionFailures - 1));
            targetDelay = Math.min(targetDelay, 300000L);
            return targetDelay;
        }

        private boolean isMailExceptionCausedByPermError(MailException e) {
            Throwable cause = e.getCause();
            return cause != null && (cause.getClass().equals(MessagingException.class) && !cause.getMessage().equals(CAN_T_SEND_COMMAND_TO_SMTP_HOST) || cause instanceof AuthenticationFailedException);
        }
    }
}

