/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.notification.internal;

import de.rcenvironment.core.notification.NotificationSubscriber;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class NotificationTopic {
    private String notificationId;
    private Pattern compiledRegExp;
    private Set<NotificationSubscriber> subscribers = Collections.synchronizedSet(new HashSet());

    protected NotificationTopic(String notificationIdentifier) {
        this.notificationId = notificationIdentifier;
    }

    protected synchronized void add(NotificationSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    protected synchronized void remove(NotificationSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    protected String getName() {
        return this.notificationId;
    }

    public Pattern getNotificationIdFilter() {
        if (this.compiledRegExp == null) {
            this.compiledRegExp = Pattern.compile("^" + this.notificationId + "$");
        }
        return this.compiledRegExp;
    }

    protected synchronized Set<NotificationSubscriber> getSubscribers() {
        return new HashSet<NotificationSubscriber>(this.subscribers);
    }

    public boolean equals(Object object) {
        if (object instanceof NotificationTopic) {
            return this.notificationId.equals(((NotificationTopic)object).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.notificationId.hashCode();
    }
}

