/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.remoteaccess.server.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.embedded.ssh.api.ScpContext;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.remoteaccess.server.internal.RemoteAccessService;
import de.rcenvironment.core.remoteaccess.server.internal.RemoteComponentExecutionParameter;
import de.rcenvironment.core.utils.common.CommonIdRules;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.security.StringSubstitutionSecurityUtils;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class RemoteAccessCommandPlugin
implements CommandPlugin {
    private static final int SEC_TO_MSEC = 1000;
    private static final String WORKFLOW_STATE_CHANGE_CONSOLEROW_PREFIX = String.valueOf(ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name()) + ":";
    private static final String RA_COMMAND = "ra";
    private static final String RA_ADMIN_COMMAND = "ra-admin";
    private static final String SUBCOMMAND_PROTOCOL_VERSION = "protocol-version";
    private static final String SUBCOMMAND_LIST_TOOLS = "list-tools";
    private static final String SUBCOMMAND_LIST_WORKFLOWS = "list-wfs";
    private static final String SUBCOMMAND_INIT = "init";
    private static final String OPTION_COMPACT_SHORT_FORM = "-c";
    private static final String OPTION_COMPACT_LONG_FORM = "--compact";
    private static final String SUBCOMMAND_RUN_TOOL = "run-tool";
    private static final String SUBCOMMAND_RUN_WF = "run-wf";
    private static final String SUBCOMMAND_CANCEL = "cancel";
    private static final String OPTION_STREAMING_OUTPUT_SHORT_FORM = "-o";
    private static final String OPTION_STREAMING_OUTPUT_LONG_FORM = "--show-output";
    private static final String SUBCOMMAND_DISPOSE = "dispose";
    private static final String SUBCOMMAND_TOOL_DETAILS = "describe-tool";
    private static final String SUBCOMMAND_WF_DETAILS = "describe-wf";
    private static final String SUBCOMMAND_TOOL_DOCUMENTATION_LIST = "get-doc-list";
    private static final String SUBCOMMAND_DOWNLOAD_DOCUMENTATION = "get-tool-doc";
    private static final Object SUBCOMMAND_ADMIN_PUBLISH_WF = "publish-wf";
    private static final String OPTION_PLACEHOLDERS_FILE = "-p";
    private static final String OPTION_GROUP_NAME = "-g";
    private static final Object SUBCOMMAND_ADMIN_UNPUBLISH_WF = "unpublish-wf";
    private static final Object SUBCOMMAND_ADMIN_LIST_WFS = "list-wfs";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private RemoteAccessService remoteAccessService;
    private ScpContextManager scpContextManager;
    private final Log log = LogFactory.getLog(this.getClass());

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription("ra protocol-version", "", true, "prints the protocol version of this interface", new String[0]));
        contributions.add(new CommandDescription("ra list-tools", "[-f/--format {csv|token-list}] [--load-data <time span> <time limit>]", true, "lists all available tool ids and versions for the \"run-tool\" command", new String[]{"-f/--format: specifies the output format; allowed values are \"csv\" (default) and \"token-stream\"", "--with-load-data: fetch CPU/RAM load data for all tool nodes and include them in the output", "time span - the maximum time span, in seconds, to aggregate/average load data over", "time limit - the maximum time, in millisedoncs, to wait for each node's load data response"}));
        contributions.add(new CommandDescription("ra list-wfs", "", true, "lists all available workflow ids and versions for the \"list-wfs\" command", new String[0]));
        contributions.add(new CommandDescription("ra init", "[-c/--compact]", true, "initializes a remote access session, and returns a session token", new String[]{"-c/--compact: only print the session token, omitting all extra information; useful for scripting"}));
        contributions.add(new CommandDescription("ra run-tool", "<session token> [-o/--show-output] [-n <tool node id>] <tool id> <tool version> [<parameters>]", true, "invokes a tool by its id and version; ", new String[]{"-o/--show-output: print tool output and execution state while the command is running", "-n: specify the node id (*) of the RCE instance to run the rool on; can be omitted if only one instance provides this tool", "    (*) the third value of the \"list-tools\" output", "All parameters after <tool version> are passed to the tool as a single parameter string."}));
        contributions.add(new CommandDescription("ra run-wf", "<session token> [-o/--show-output] <workflow id> <workflow version> [<parameters>]", true, "invokes a published workflow by its id; ", new String[]{"-o/--show-output: print tool output and execution state while the command is running", "All parameters after <tool version> are passed to the workflow as a single parameter string."}));
        contributions.add(new CommandDescription("ra dispose", "<session token>", true, "releases resources used by a remote access session", new String[0]));
        contributions.add(new CommandDescription("ra describe-tool", "<tool id> [--template]", true, "prints names and data types of the tool's or workflow's intputs and outputs", new String[0]));
        contributions.add(new CommandDescription("ra describe-wf", "<workflow id> [--template]", true, "prints names and data types of the tool's or workflow's intputs and outputs", new String[0]));
        contributions.add(new CommandDescription("ra-admin publish-wf", "[-g <group name>] [-k] [-t] [-p <JSON placeholder file>] <workflow file> <id>", false, "publishes a workflow file for remote execution via \"ra run-wf\" using <id>.", new String[]{"-g name of the group in which the workflow will be shown in the Palette on the client instance", "-k (keep execution data): if set, the workflow execution data will not be deleted after the workflow is run", "-t (temporary/transient): if set, the workflow is automatically unpublished when the RCE instance is shut down", "-p: adds a placeholder file for the given workflow; see the \"wf run\" command's documentation for details.", "This operation verifies that the workflow contains the required standard elements before publishing.", "Note that a snapshot of the workflow file (and optionally, the given placeholder file) is taken before publishing; ", "subsequent changes of the workflow file do NOT affect the published workflow."}));
        contributions.add(new CommandDescription("ra-admin unpublish-wf", "<id>", false, "unpublishes (removes) the workflow file with id <id> from remote execution.", new String[0]));
        contributions.add(new CommandDescription("ra-admin list-wfs", "", false, "lists the ids of all published workflows.", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        block4: {
            try {
                String rootCommand = context.consumeNextToken();
                if (RA_COMMAND.equals(rootCommand)) {
                    this.handleStandardCommand(context);
                    break block4;
                }
                if (RA_ADMIN_COMMAND.equals(rootCommand)) {
                    this.handleAdminCommand(context);
                    break block4;
                }
                throw CommandException.unknownCommand((CommandContext)context);
            }
            catch (IOException e) {
                this.log.warn((Object)"I/O error during Remote Access command execution", (Throwable)e);
                throw CommandException.executionError((String)"An I/O error occurred during command execution. Please check the log file for details.", (CommandContext)context);
            }
        }
    }

    private void handleStandardCommand(CommandContext context) throws IOException, CommandException {
        String subCommand = context.consumeNextToken();
        if (SUBCOMMAND_PROTOCOL_VERSION.equals(subCommand)) {
            this.performProtocolVersion(context);
        } else if (SUBCOMMAND_LIST_TOOLS.equals(subCommand)) {
            this.performListTools(context);
        } else if (SUBCOMMAND_LIST_WORKFLOWS.equals(subCommand)) {
            this.performListWfs(context);
        } else if (SUBCOMMAND_INIT.equals(subCommand)) {
            this.performInit(context);
        } else if (SUBCOMMAND_RUN_TOOL.equals(subCommand)) {
            this.performRunTool(context);
        } else if (SUBCOMMAND_RUN_WF.equals(subCommand)) {
            this.performRunWf(context);
        } else if (SUBCOMMAND_CANCEL.equals(subCommand)) {
            this.performCancel(context);
        } else if (SUBCOMMAND_DISPOSE.equals(subCommand)) {
            this.performDispose(context);
        } else if (SUBCOMMAND_TOOL_DETAILS.equals(subCommand)) {
            this.performGetToolDetails(context);
        } else if (SUBCOMMAND_WF_DETAILS.equals(subCommand)) {
            this.performGetWfDetails(context);
        } else if (SUBCOMMAND_TOOL_DOCUMENTATION_LIST.equals(subCommand)) {
            this.performGetToolDocList(context);
        } else if (SUBCOMMAND_DOWNLOAD_DOCUMENTATION.equals(subCommand)) {
            this.performDownloadDocumentation(context);
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    private void handleAdminCommand(CommandContext context) throws IOException, CommandException {
        String subCommand = context.consumeNextToken();
        if (SUBCOMMAND_ADMIN_PUBLISH_WF.equals(subCommand)) {
            this.performAdminPublishWf(context);
        } else if (SUBCOMMAND_ADMIN_UNPUBLISH_WF.equals(subCommand)) {
            this.performAdminUnpublishWf(context);
        } else if (SUBCOMMAND_ADMIN_LIST_WFS.equals(subCommand)) {
            this.performAdminListWfs(context);
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    @Reference
    public void bindScpContextManager(ScpContextManager newInstance) {
        this.scpContextManager = newInstance;
    }

    @Reference
    public void bindRemoteAccessService(RemoteAccessService newInstance) {
        this.remoteAccessService = newInstance;
    }

    private void performProtocolVersion(CommandContext context) {
        context.println((Object)"9.5.0-UplinkSnapshot2");
    }

    private void performListTools(CommandContext context) throws CommandException {
        try {
            String format = "csv";
            if (context.consumeNextTokenIfEquals("-f") || context.consumeNextTokenIfEquals("--format")) {
                format = context.consumeNextToken();
            }
            if (context.consumeNextTokenIfEquals("--with-load-data")) {
                int timeSpanSec = this.parseRequiredPositiveIntParameter(context, "time span");
                int timeLimitMsec = this.parseRequiredPositiveIntParameter(context, "time limit");
                this.remoteAccessService.printListOfAvailableTools(context.getOutputReceiver(), format, true, timeSpanSec * 1000, timeLimitMsec);
            } else {
                this.remoteAccessService.printListOfAvailableTools(context.getOutputReceiver(), format, false, 0, 0);
            }
        }
        catch (IllegalArgumentException | InterruptedException | ExecutionException | TimeoutException e) {
            throw CommandException.syntaxError((String)e.toString(), (CommandContext)context);
        }
    }

    private void performListWfs(CommandContext context) throws CommandException {
        String format = "token-stream";
        if (context.consumeNextTokenIfEquals("-f") || context.consumeNextTokenIfEquals("--format")) {
            format = context.consumeNextToken();
        }
        try {
            this.remoteAccessService.printListOfAvailableWorkflows(context.getOutputReceiver(), format);
        }
        catch (IllegalArgumentException e) {
            throw CommandException.syntaxError((String)e.getMessage(), (CommandContext)context);
        }
    }

    private void performInit(CommandContext context) throws IOException, CommandException {
        SshAccount account = this.getAndValidateSshAccount(context);
        String token = context.consumeNextToken();
        boolean useCompactOutput = OPTION_COMPACT_LONG_FORM.equals(token) || OPTION_COMPACT_SHORT_FORM.equals(token);
        String sessionToken = IdGenerator.fastRandomHexString((int)8);
        String usedCommandVariant = (String)context.getOriginalTokens().get(0);
        String virtualScpRootPath = this.getVirtualScpRootPath(usedCommandVariant, sessionToken);
        ScpContext scpContext = this.scpContextManager.createScpContext(account.getLoginName(), virtualScpRootPath);
        this.createScpContextSubdir(INPUT, scpContext, context);
        this.createScpContextSubdir(OUTPUT, scpContext, context);
        if (useCompactOutput) {
            context.println((Object)sessionToken);
        } else {
            context.println((Object)StringUtils.format((String)"Session token: %s", (Object[])new Object[]{sessionToken}));
            context.println((Object)StringUtils.format((String)"Input (upload) SCP path: %sinput/", (Object[])new Object[]{virtualScpRootPath}));
            context.println((Object)StringUtils.format((String)"Execution command: \"%s %s %s <tool id> <tool version> [<parameters>]\"", (Object[])new Object[]{usedCommandVariant, SUBCOMMAND_RUN_TOOL, sessionToken}));
            context.println((Object)StringUtils.format((String)"Output (download) SCP path: %soutput/", (Object[])new Object[]{virtualScpRootPath}));
        }
    }

    private void performRunTool(final CommandContext context) throws CommandException {
        new WorkflowRun(this, context){
            private String toolId;
            private String toolVersion;
            private String nodeId;
            private String dynInputs;
            private String dynOutputs;
            private String nonReqInputs;
            private boolean uncompressedUpload;
            private boolean simpleDescriptionFormat;
            {
                super($anonymous0);
                this.uncompressedUpload = false;
                this.simpleDescriptionFormat = false;
            }

            @Override
            protected void readCustomParameters() throws CommandException {
                if (context.consumeNextTokenIfEquals("-n")) {
                    this.nodeId = context.consumeNextToken();
                    if (this.nodeId == null) {
                        throw CommandException.syntaxError((String)"Error: missing node id after -n", (CommandContext)context);
                    }
                }
                if (context.consumeNextTokenIfEquals("-u")) {
                    this.uncompressedUpload = true;
                }
                if (context.consumeNextTokenIfEquals("-simple")) {
                    this.simpleDescriptionFormat = true;
                }
                this.toolId = context.consumeNextToken();
                this.validateIdString(this.toolId, "tool id", context);
                this.toolVersion = context.consumeNextToken();
                this.validateVersionString(this.toolVersion, "tool version", context);
                if (context.consumeNextTokenIfEquals("--dynInputs")) {
                    this.dynInputs = context.consumeNextToken();
                }
                if (context.consumeNextTokenIfEquals("--dynOutputs")) {
                    this.dynOutputs = context.consumeNextToken();
                }
                if (context.consumeNextTokenIfEquals("--nonReqInputs")) {
                    this.nonReqInputs = context.consumeNextToken();
                }
                log.debug((Object)StringUtils.format((String)"Command run-tool: Parsed tool id '%s', version '%s'", (Object[])new Object[]{this.toolId, this.toolVersion}));
                try {
                    this.nodeId = remoteAccessService.validateToolParametersAndGetFinalNodeId(this.toolId, this.toolVersion, this.nodeId);
                }
                catch (WorkflowExecutionException e) {
                    throw CommandException.executionError((String)("Invalid tool parameters: " + e.getMessage()), (CommandContext)context);
                }
            }

            @Override
            protected FinalWorkflowState invokeWorkflow(String sessionToken, File inputFilesPath, File outputFilesPath, SingleConsoleRowsProcessor optionalStreamingOutputProcessor) throws IOException, WorkflowExecutionException {
                return remoteAccessService.runSingleToolWorkflow(new RemoteComponentExecutionParameter(this.toolId, this.toolVersion, this.nodeId, sessionToken, inputFilesPath, outputFilesPath, this.dynInputs, this.dynOutputs, this.nonReqInputs, this.uncompressedUpload, this.simpleDescriptionFormat), optionalStreamingOutputProcessor);
            }
        }.execute();
    }

    private void performRunWf(final CommandContext context) throws CommandException {
        new WorkflowRun(this, context){
            private String workflowId;
            private String workflowVersion;
            private boolean uncompressedUpload;
            private boolean simpleDescriptionFormat;
            {
                super($anonymous0);
                this.uncompressedUpload = false;
                this.simpleDescriptionFormat = false;
            }

            @Override
            protected void readCustomParameters() throws CommandException {
                if (context.consumeNextTokenIfEquals("-u")) {
                    this.uncompressedUpload = true;
                }
                if (context.consumeNextTokenIfEquals("-simple")) {
                    this.simpleDescriptionFormat = true;
                }
                this.workflowId = context.consumeNextToken();
                this.validateIdString(this.workflowId, "workflow id", context);
                this.workflowVersion = context.consumeNextToken();
                this.validateVersionString(this.workflowVersion, "workflow version", context);
                log.debug((Object)StringUtils.format((String)"Command run-wf: Parsed workflow id '%s', version '%s'", (Object[])new Object[]{this.workflowId, this.workflowVersion}));
            }

            @Override
            protected FinalWorkflowState invokeWorkflow(String sessionToken, File inputFilesPath, File outputFilesPath, SingleConsoleRowsProcessor optionalStreamingOutputProcessor) throws IOException, WorkflowExecutionException {
                return remoteAccessService.runPublishedWorkflowTemplate(this.workflowId, sessionToken, inputFilesPath, outputFilesPath, optionalStreamingOutputProcessor, this.uncompressedUpload, this.simpleDescriptionFormat);
            }
        }.execute();
    }

    private void performDispose(CommandContext context) throws CommandException {
        SshAccount account = this.getAndValidateSshAccount(context);
        String usedCommandVariant = (String)context.getOriginalTokens().get(0);
        String sessionToken = context.consumeNextToken();
        String virtualScpRootPath = this.getVirtualScpRootPath(usedCommandVariant, sessionToken);
        ScpContext scpContext = this.scpContextManager.getMatchingScpContext(account.getLoginName(), virtualScpRootPath);
        try {
            this.scpContextManager.disposeScpContext(scpContext);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }

    private void performGetToolDetails(CommandContext context) throws CommandException {
        String nodeId = null;
        if (context.consumeNextTokenIfEquals("-n") && (nodeId = context.consumeNextToken()) == null) {
            throw CommandException.syntaxError((String)"Error: missing node id after -n", (CommandContext)context);
        }
        String toolId = context.consumeNextToken();
        String toolVersion = context.consumeNextToken();
        this.validateIdString(toolId, "tool id", context);
        this.validateVersionString(toolVersion, "tool version", context);
        boolean template = context.consumeNextTokenIfEquals("--template");
        try {
            nodeId = this.remoteAccessService.validateToolParametersAndGetFinalNodeId(toolId, toolVersion, nodeId);
        }
        catch (WorkflowExecutionException e) {
            throw CommandException.executionError((String)("Invalid tool parameters: " + e.getMessage()), (CommandContext)context);
        }
        this.remoteAccessService.printToolDetails(context.getOutputReceiver(), toolId, toolVersion, nodeId, template);
    }

    private void performGetWfDetails(CommandContext context) throws CommandException {
        String wfId = context.consumeNextToken();
        String wfVersion = context.consumeNextToken();
        boolean template = context.consumeNextTokenIfEquals("--template");
        this.validateIdString(wfId, "wf id", context);
        this.validateVersionString(wfVersion, "wf version", context);
        this.remoteAccessService.printWfDetails(context.getOutputReceiver(), wfId, template);
    }

    private void performCancel(CommandContext context) {
        String sessionToken = context.consumeNextToken();
        this.remoteAccessService.cancelToolOrWorkflow(sessionToken);
    }

    private void performGetToolDocList(CommandContext context) {
        String toolId = context.consumeNextToken();
        this.remoteAccessService.getToolDocumentationList(context.getOutputReceiver(), toolId);
    }

    private void performDownloadDocumentation(CommandContext context) throws CommandException {
        SshAccount account = this.getAndValidateSshAccount(context);
        String toolId = context.consumeNextToken();
        String nodeId = context.consumeNextToken();
        String hashValue = context.consumeNextToken();
        String sessionToken = context.consumeNextToken();
        String usedCommandVariant = (String)context.getOriginalTokens().get(0);
        String virtualScpRootPath = this.getVirtualScpRootPath(usedCommandVariant, sessionToken);
        ScpContext scpContext = this.scpContextManager.getMatchingScpContext(account.getLoginName(), virtualScpRootPath);
        if (scpContext == null) {
            throw CommandException.executionError((String)StringUtils.format((String)"No permission to access session %s (or not a valid session token)", (Object[])new Object[]{sessionToken}), (CommandContext)context);
        }
        File outputFilesPath = new File(scpContext.getLocalRootPath(), OUTPUT);
        this.remoteAccessService.getToolDocumentation(context.getOutputReceiver(), toolId, nodeId, hashValue, outputFilesPath);
    }

    private void performAdminPublishWf(CommandContext context) throws CommandException {
        File wfFile;
        String groupName = null;
        if (context.consumeNextTokenIfEquals(OPTION_GROUP_NAME)) {
            groupName = context.consumeNextToken();
        }
        boolean neverDeleteExecutionData = context.consumeNextTokenIfEquals("-k");
        boolean makePersistent = !context.consumeNextTokenIfEquals("-t");
        File placeholdersFile = null;
        if (context.consumeNextTokenIfEquals(OPTION_PLACEHOLDERS_FILE)) {
            String placeholdersFilename = context.consumeNextToken();
            if (placeholdersFilename == null) {
                throw CommandException.syntaxError((String)"Missing placeholder filename", (CommandContext)context);
            }
            try {
                placeholdersFile = WorkflowExecutionUtils.resolveWorkflowOrPlaceholderFileLocation((String)placeholdersFilename, (String)"Placeholder file %s does not exist or it can not be read");
            }
            catch (FileNotFoundException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }
        String filename = context.consumeNextToken();
        this.validateParameterNotNull(filename, "filename", context);
        String publishId = context.consumeNextToken();
        this.validateIdString(publishId, "workflow publish id", context);
        if (context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            wfFile = WorkflowExecutionUtils.resolveWorkflowOrPlaceholderFileLocation((String)filename, (String)"Workflow file %s does not exist or it can not be read");
        }
        catch (FileNotFoundException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
        try {
            this.remoteAccessService.checkAndPublishWorkflowFile(wfFile, placeholdersFile, publishId, groupName, context.getOutputReceiver(), makePersistent, neverDeleteExecutionData);
        }
        catch (WorkflowExecutionException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error checking/publishing workflow file", (Throwable)e);
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
    }

    private void performAdminUnpublishWf(CommandContext context) throws CommandException {
        String publishId = context.consumeNextToken();
        this.validateIdString(publishId, "workflow publish id", context);
        if (context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            this.remoteAccessService.unpublishWorkflowForId(publishId, context.getOutputReceiver());
        }
        catch (WorkflowExecutionException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }

    private void performAdminListWfs(CommandContext context) throws CommandException {
        this.remoteAccessService.printSummaryOfPublishedWorkflows(context.getOutputReceiver());
    }

    private void createScpContextSubdir(String name, ScpContext scpContext, CommandContext commandContext) throws CommandException {
        File dir = new File(scpContext.getLocalRootPath(), name);
        if (!dir.mkdir()) {
            throw CommandException.executionError((String)("Internal problem: failed to create " + name + " directory"), (CommandContext)commandContext);
        }
    }

    private String getVirtualScpRootPath(String commandVariant, String sessionToken) {
        return StringUtils.format((String)"/%s/%s/", (Object[])new Object[]{commandVariant, sessionToken});
    }

    private SshAccount getAndValidateSshAccount(CommandContext context) throws CommandException {
        Object invoker = context.getInvokerInformation();
        if (!(invoker instanceof SshAccount)) {
            throw CommandException.executionError((String)"This command is only usable from an SSH account as it requires an SCP context", (CommandContext)context);
        }
        return (SshAccount)invoker;
    }

    protected void validateParameterNotNull(String input, String description, CommandContext context) throws CommandException {
        if (input == null) {
            throw CommandException.syntaxError((String)("Error: missing " + description), (CommandContext)context);
        }
    }

    private void validateIdString(String input, String description, CommandContext context) throws CommandException {
        this.validateParameterNotNull(input, description, context);
        Optional errorMsg = CommonIdRules.validateCommonIdRules((String)input);
        if (errorMsg.isPresent()) {
            throw CommandException.syntaxError((String)StringUtils.format((String)"Invalid %s: %s", (Object[])new Object[]{description, errorMsg}), (CommandContext)context);
        }
    }

    private void validateVersionString(String input, String description, CommandContext context) throws CommandException {
        this.validateParameterNotNull(input, description, context);
        Optional errorMsg = CommonIdRules.validateCommonVersionStringRules((String)input);
        if (errorMsg.isPresent()) {
            throw CommandException.syntaxError((String)StringUtils.format((String)"Invalid %s: %s", (Object[])new Object[]{description, errorMsg}), (CommandContext)context);
        }
    }

    private int parseRequiredPositiveIntParameter(CommandContext context, String name) throws CommandException {
        int timespan;
        String parameter = context.consumeNextToken();
        if (parameter == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            timespan = Integer.parseInt(parameter);
            if (timespan <= 0) {
                throw CommandException.syntaxError((String)("The " + name + " parameter must be positive: " + parameter), (CommandContext)context);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.syntaxError((String)("The " + name + " parameter must be an integer number: " + parameter), (CommandContext)context);
        }
        return timespan;
    }

    private static final class StreamingOutputConsoleRowAdapter
    implements SingleConsoleRowsProcessor {
        private final String sessionToken;
        private final CommandContext context;

        private StreamingOutputConsoleRowAdapter(CommandContext context, String sessionToken) {
            this.sessionToken = sessionToken;
            this.context = context;
        }

        public void onConsoleRow(ConsoleRow consoleRow) {
            ConsoleRow.Type type = consoleRow.getType();
            String payload = consoleRow.getPayload();
            switch (type) {
                case TOOL_OUT: {
                    this.context.println((Object)StringUtils.format((String)"[%s] StdOut: %s", (Object[])new Object[]{this.sessionToken, payload}));
                    break;
                }
                case TOOL_ERROR: 
                case COMPONENT_WARN: 
                case COMPONENT_ERROR: {
                    this.context.println((Object)StringUtils.format((String)"[%s] StdErr: %s", (Object[])new Object[]{this.sessionToken, payload}));
                    break;
                }
                case LIFE_CYCLE_EVENT: {
                    String stateString;
                    if (!payload.startsWith(WORKFLOW_STATE_CHANGE_CONSOLEROW_PREFIX) || (stateString = payload.substring(WORKFLOW_STATE_CHANGE_CONSOLEROW_PREFIX.length())).startsWith("DISPOS")) break;
                    this.context.println((Object)StringUtils.format((String)"[%s] State: %s", (Object[])new Object[]{this.sessionToken, stateString}));
                    break;
                }
            }
        }
    }

    private abstract class WorkflowRun {
        private final CommandContext context;

        private WorkflowRun(CommandContext context) {
            this.context = context;
        }

        public void execute() throws CommandException {
            SshAccount account = RemoteAccessCommandPlugin.this.getAndValidateSshAccount(this.context);
            String usedCommandVariant = (String)this.context.getOriginalTokens().get(0);
            String sessionToken = this.context.consumeNextToken();
            String virtualScpRootPath = RemoteAccessCommandPlugin.this.getVirtualScpRootPath(usedCommandVariant, sessionToken);
            ScpContext scpContext = RemoteAccessCommandPlugin.this.scpContextManager.getMatchingScpContext(account.getLoginName(), virtualScpRootPath);
            if (scpContext == null) {
                throw CommandException.executionError((String)StringUtils.format((String)"No permission to access session %s (or not a valid session token)", (Object[])new Object[]{sessionToken}), (CommandContext)this.context);
            }
            boolean optionStreamingOutput = this.context.consumeNextTokenIfEquals(RemoteAccessCommandPlugin.OPTION_STREAMING_OUTPUT_SHORT_FORM) || this.context.consumeNextTokenIfEquals(RemoteAccessCommandPlugin.OPTION_STREAMING_OUTPUT_LONG_FORM);
            this.readCustomParameters();
            RemoteAccessCommandPlugin.this.log.debug((Object)("Executing 'run' command in the context of temporary account " + account.getLoginName() + ", with a local SCP directory of " + scpContext.getLocalRootPath()));
            File inputFilesPath = new File(scpContext.getLocalRootPath(), RemoteAccessCommandPlugin.INPUT);
            File outputFilesPath = new File(scpContext.getLocalRootPath(), RemoteAccessCommandPlugin.OUTPUT);
            try {
                if (!inputFilesPath.isDirectory()) {
                    throw CommandException.executionError((String)"No \"input\" directory found; aborting tool run", (CommandContext)this.context);
                }
                StreamingOutputConsoleRowAdapter optionalStreamingOutputProcessor = null;
                if (optionStreamingOutput) {
                    optionalStreamingOutputProcessor = new StreamingOutputConsoleRowAdapter(this.context, sessionToken);
                }
                FinalWorkflowState finalState = this.invokeWorkflow(sessionToken, inputFilesPath, outputFilesPath, optionalStreamingOutputProcessor);
                if (!outputFilesPath.isDirectory()) {
                    this.context.println((Object)"WARNING: no \"output\" directory found after tool execution; creating an empty one");
                    outputFilesPath.mkdirs();
                    if (!outputFilesPath.isDirectory()) {
                        this.context.println((Object)"WARNING: \"output\" directory still does not exist after attempting to create it");
                    }
                }
                if (finalState != FinalWorkflowState.FINISHED) {
                    throw CommandException.executionError((String)("The workflow finished in state " + finalState + " (instead of " + FinalWorkflowState.FINISHED + "); check the log file for more details"), (CommandContext)this.context);
                }
            }
            catch (WorkflowExecutionException | IOException e) {
                RemoteAccessCommandPlugin.this.log.error((Object)"Error running remote access workflow", e);
                throw CommandException.executionError((String)("An error occurred during remote workflow execution: " + e.toString()), (CommandContext)this.context);
            }
        }

        protected abstract void readCustomParameters() throws CommandException;

        protected abstract FinalWorkflowState invokeWorkflow(String var1, File var2, File var3, SingleConsoleRowsProcessor var4) throws IOException, WorkflowExecutionException;

        private boolean validateToolOrWorkflowParameterString(String parameterString) {
            StringSubstitutionSecurityUtils.SubstitutionContext[] substitutionContextArray = StringSubstitutionSecurityUtils.SubstitutionContext.values();
            int n = substitutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                StringSubstitutionSecurityUtils.SubstitutionContext substitutionContext = substitutionContextArray[n2];
                if (!StringSubstitutionSecurityUtils.isSafeForSubstitutionInsideDoubleQuotes((String)parameterString, (StringSubstitutionSecurityUtils.SubstitutionContext)substitutionContext)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

