/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.components.outputwriter.gui.Messages;
import de.rcenvironment.components.outputwriter.gui.OutputWriterEditDynamicInputCommand;
import de.rcenvironment.components.outputwriter.gui.OutputWriterEndpointEditDialog;
import de.rcenvironment.components.outputwriter.gui.OutputWriterRemoveDynamicInputCommand;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointHandlingHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OutputWriterEndpointSelectionPane
extends EndpointSelectionPane {
    protected ObjectMapper jsonMapper = JsonUtils.getDefaultObjectMapper();

    public OutputWriterEndpointSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, WorkflowNodeCommand.Executor executor) {
        super(title, direction, dynEndpointIdToManage, new String[0], new String[0], executor);
        this.jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    protected void onAddClicked() {
        TreeSet<String> paths = new TreeSet<String>();
        for (String endpointName : this.getDynamicEndpointNames()) {
            paths.add((String)this.getMetaData(endpointName).get("folderForSaving"));
        }
        OutputWriterEndpointEditDialog dialog = new OutputWriterEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>(), paths);
        this.onAddClicked(dialog);
    }

    protected void onEditClicked() {
        TreeSet<String> paths = new TreeSet<String>();
        for (String endpointName : this.getDynamicEndpointNames()) {
            paths.add((String)this.getMetaData(endpointName).get("folderForSaving"));
        }
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        OutputWriterEndpointEditDialog dialog = new OutputWriterEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, isStaticEndpoint, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData, paths);
        this.onEditClicked(name, dialog, newMetaData);
    }

    protected void onEditClicked(String name, EndpointEditDialog dialog, Map<String, String> newMetaData) {
        DataType newType;
        String newName;
        EndpointDescription oldDesc;
        dialog.initializeValues(name);
        if (dialog.open() == 0 && this.isEndpointChanged(oldDesc = this.endpointManager.getEndpointDescription(name), newName = dialog.getChosenName(), newType = dialog.getChosenDataType(), newMetaData = dialog.getMetadataValues()) && EndpointHandlingHelper.editEndpointDataType((EndpointType)this.endpointType, (EndpointDescription)oldDesc, (DataType)newType)) {
            this.editEndpoint(oldDesc, newName, newType, newMetaData);
        }
    }

    protected void editEndpoint(EndpointDescription oldDesc, String newName, DataType newType, Map<String, String> newMetaData) {
        String outputName = this.outputNameForInputName(oldDesc.getName());
        EndpointDescription newDesc = this.endpointManager.getEndpointDescription(oldDesc.getName());
        if (!newName.equals(oldDesc.getName())) {
            newDesc.setName(newName);
        }
        newDesc.setDataType(newType);
        newDesc.setMetaData(newMetaData);
        switch (OutputWriterEndpointSelectionPane.editConfirmed(oldDesc, newName, newType, outputName)) {
            case InputInvolvedInTarget: {
                this.executeEditCommand(oldDesc, newDesc, true);
                break;
            }
            case DoNotRemoveCompatibleTypes: {
                this.executeEditCommand(oldDesc, newDesc, false);
                break;
            }
            case InputNotInvolvedInTarget: {
                return;
            }
            default: {
                return;
            }
        }
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription, boolean removeInput) {
        String outputName = this.outputIdForInputName(oldDescription.getName());
        OutputWriterEditDynamicInputCommand command = new OutputWriterEditDynamicInputCommand(this.endpointType, oldDescription, newDescription, outputName, removeInput, new Refreshable[]{this});
        this.execute((WorkflowNodeCommand)command);
    }

    protected static DataTypeInputHandling editConfirmed(EndpointDescription oldDesc, String newName, DataType newDataType, String outputName) {
        DataType[] compatibleTypes = new DataType[]{DataType.Integer, DataType.Float};
        List<DataType> compatibleTypesList = Arrays.asList(compatibleTypes);
        if (outputName == null) {
            return DataTypeInputHandling.InputInvolvedInTarget;
        }
        if (compatibleTypesList.contains(newDataType) && compatibleTypesList.contains(oldDesc.getDataType())) {
            return DataTypeInputHandling.DoNotRemoveCompatibleTypes;
        }
        if ((newDataType.equals((Object)DataType.DirectoryReference) || newDataType.equals((Object)DataType.FileReference) || newName != oldDesc.getName()) && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.editingInputWithOutputLocationDialogTitle, (String)StringUtils.format((String)Messages.editingInputWithOutputLocationDialogText, (Object[])new Object[]{oldDesc.getName(), outputName}))) {
            return DataTypeInputHandling.InputNotInvolvedInTarget;
        }
        return DataTypeInputHandling.InputInvolvedInTarget;
    }

    protected void executeRemoveCommand(List<String> names) {
        HashSet<String> outputLocationIds = new HashSet<String>();
        HashSet<String> outputLocationNames = new HashSet<String>();
        for (String inputName : names) {
            if (this.outputIdForInputName(inputName) == null) continue;
            outputLocationIds.add(this.outputIdForInputName(inputName));
            outputLocationNames.add(this.outputNameForInputName(inputName));
        }
        if (OutputWriterEndpointSelectionPane.deleteConfirmed(outputLocationNames)) {
            OutputWriterRemoveDynamicInputCommand command = new OutputWriterRemoveDynamicInputCommand(this.endpointType, this.dynEndpointIdToManage, names, new ArrayList<String>(outputLocationIds), new Refreshable[]{this});
            this.execute((WorkflowNodeCommand)command);
        }
    }

    protected static boolean deleteConfirmed(Set<String> outputLocationNames) {
        return outputLocationNames.isEmpty() || MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.editingInputWithOutputLocationDialogTitle, (String)StringUtils.format((String)Messages.deletingInputWithOutputLocationDialogText, (Object[])new Object[]{outputLocationNames.toString()}));
    }

    private List<String> getDynamicEndpointNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (EndpointDescription e : this.endpointManager.getDynamicEndpointDescriptions()) {
            result.add(e.getName());
        }
        return result;
    }

    protected String outputIdForInputName(String inputName) {
        String jsonString = this.configuration.getConfigurationDescription().getConfigurationValue("outputLocations");
        if (jsonString == null) {
            jsonString = "";
        }
        try {
            OutputLocationList list = (OutputLocationList)this.jsonMapper.readValue(jsonString, OutputLocationList.class);
            for (OutputLocation ol : list.getOutputLocations()) {
                if (!ol.getInputs().contains(inputName)) continue;
                return ol.getGroupId();
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when reading JSON: " + e.getMessage()));
        }
        return null;
    }

    protected String outputNameForInputName(String inputName) {
        String jsonString = this.configuration.getConfigurationDescription().getConfigurationValue("outputLocations");
        if (jsonString == null) {
            jsonString = "";
        }
        try {
            OutputLocationList list = (OutputLocationList)this.jsonMapper.readValue(jsonString, OutputLocationList.class);
            for (OutputLocation ol : list.getOutputLocations()) {
                if (!ol.getInputs().contains(inputName)) continue;
                return ol.getFilename();
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when reading JSON: " + e.getMessage()));
        }
        return null;
    }

    protected static enum DataTypeInputHandling {
        InputInvolvedInTarget,
        InputNotInvolvedInTarget,
        DoNotRemoveCompatibleTypes;

    }
}

