/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.SingleCommandHandler;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class MultiCommandHandler
implements Callable<CommandExecutionResult> {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String ESCAPED_DOUBLE_QUOTE = "\\\"";
    private static final String SEQUENTIAL_EXECUTION_SEPARATOR = ";";
    private final List<String> rawTokens;
    private final Deque<String> remainingTokens;
    private TextOutputReceiver outputReceiver;
    private final SingleCommandHandler singleCommandHandler;
    private volatile Object initiatorInformation;

    public MultiCommandHandler(List<String> tokens, TextOutputReceiver outputReceiver, SingleCommandHandler singleCommandHandler, File profileOutput) {
        this.rawTokens = tokens;
        this.remainingTokens = new LinkedList<String>();
        this.outputReceiver = outputReceiver;
        this.singleCommandHandler = singleCommandHandler;
    }

    public MultiCommandHandler(List<String> tokens, TextOutputReceiver outputReceiver, SingleCommandHandler singleCommandHandler) {
        this(tokens, outputReceiver, singleCommandHandler, null);
    }

    @Override
    @TaskDescription(value="Text command execution")
    public CommandExecutionResult call() {
        this.outputReceiver.onStart();
        try {
            List<String> normalizedTokens = this.normalizeTokens(this.rawTokens);
            this.remainingTokens.addAll(normalizedTokens);
        }
        catch (IllegalArgumentException e) {
            this.outputReceiver.addOutput("Syntax Error: " + e.getMessage());
            this.outputReceiver.onFinished();
            return CommandExecutionResult.ERROR;
        }
        if (this.remainingTokens.isEmpty()) {
            CommandContext context = new CommandContext(new ArrayList<String>(this.remainingTokens), this.outputReceiver, this.initiatorInformation);
            this.outputReceiver.onFatalError((Exception)CommandException.requestHelp(context));
            return CommandExecutionResult.DEFAULT;
        }
        try {
            String token;
            LinkedList<String> collectedTokens = new LinkedList<String>();
            do {
                if ((token = this.getNextToken()) == null || token.equals(SEQUENTIAL_EXECUTION_SEPARATOR)) {
                    this.processSequentialPart(collectedTokens);
                    collectedTokens = new LinkedList();
                    continue;
                }
                collectedTokens.add(token);
            } while (token != null);
            this.outputReceiver.onFinished();
            return CommandExecutionResult.DEFAULT;
        }
        catch (CommandException e) {
            this.outputReceiver.onFatalError((Exception)e);
            return CommandExecutionResult.ERROR;
        }
    }

    public Object getInitiatorInformation() {
        return this.initiatorInformation;
    }

    public void setInitiatorInformation(Object shellAccountInformation) {
        this.initiatorInformation = shellAccountInformation;
    }

    private List<String> normalizeTokens(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        String quotedPartBuffer = null;
        for (String token : input) {
            if (token.isEmpty()) continue;
            if (quotedPartBuffer == null) {
                if (token.startsWith(DOUBLE_QUOTE) && !token.equals(DOUBLE_QUOTE)) {
                    if (token.endsWith(DOUBLE_QUOTE) && !token.endsWith(ESCAPED_DOUBLE_QUOTE)) {
                        output.add(this.unescapeQuotes(token.substring(1, token.length() - 1)));
                        continue;
                    }
                    quotedPartBuffer = token.substring(1);
                    continue;
                }
                output.add(this.unescapeQuotes(token));
                continue;
            }
            if (token.endsWith(DOUBLE_QUOTE) && !token.endsWith(ESCAPED_DOUBLE_QUOTE)) {
                quotedPartBuffer = String.valueOf(quotedPartBuffer) + " " + token.substring(0, token.length() - 1);
                output.add(this.unescapeQuotes(quotedPartBuffer));
                quotedPartBuffer = null;
                continue;
            }
            quotedPartBuffer = String.valueOf(quotedPartBuffer) + " " + token;
        }
        if (quotedPartBuffer != null) {
            throw new IllegalArgumentException("Unfinished quoted command part: " + quotedPartBuffer);
        }
        return output;
    }

    private String unescapeQuotes(String substring) {
        return substring.replace(ESCAPED_DOUBLE_QUOTE, DOUBLE_QUOTE);
    }

    private String getNextToken() {
        return this.remainingTokens.pollFirst();
    }

    private void processSequentialPart(List<String> tokens) throws CommandException {
        if (tokens.isEmpty()) {
            return;
        }
        this.executeSingleCommand(tokens);
    }

    private void executeSingleCommand(List<String> tokens) throws CommandException {
        CommandContext commandContext = new CommandContext(tokens, this.outputReceiver, this.initiatorInformation);
        this.singleCommandHandler.execute(commandContext);
    }
}

