/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.ui;

import com.googlecode.lanterna.TerminalFacade;
import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.DefaultBackgroundRenderer;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.ActionListBox;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.component.RadioCheckBoxList;
import com.googlecode.lanterna.gui.dialog.ListSelectDialog;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.listener.WindowAdapter;
import com.googlecode.lanterna.gui.listener.WindowListener;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalSize;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileUtils;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.configuration.ui.LanternaUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfileSelectionUI {
    private static LayoutParameter lp;
    private static final String OPTION_SELECT_PROFILE = "Select a profile and start RCE.";
    private static final String OPTION_SELECT_DEFAULT_PROFILE = "Select the default profile for future runs.";
    private static final String BACKGROUND_MESSAGE = "Profile Selection";
    private static final int PROFILE_LIST_WIDTH = 60;
    private static final String DEFAULT_WARNING_TEXT = "Note: If you select a default profile here, RCE will use this profile on the next start (or restart), if you do not use the profile option (\"-p\"). This is also the case if you have configured RCE as a service.";
    private GUIScreen guiScreen;
    private Profile selectedProfile = null;
    private Terminal terminal;
    private boolean exitChooserUI = false;
    private final Log log = LogFactory.getLog(this.getClass());

    public ProfileSelectionUI(Terminal terminal) {
        this.terminal = terminal;
    }

    public ProfileSelectionUI() {
    }

    public Profile run() throws ProfileException {
        this.guiScreen = this.terminal != null ? TerminalFacade.createGUIScreen((Terminal)this.terminal) : TerminalFacade.createGUIScreen();
        if (this.guiScreen == null) {
            this.log.error((Object)"Failed to initialize text-mode UI; terminating");
            return null;
        }
        this.guiScreen.setBackgroundRenderer((GUIScreenBackgroundRenderer)new DefaultBackgroundRenderer(BACKGROUND_MESSAGE));
        this.guiScreen.getScreen().startScreen();
        this.runMainLoop();
        this.guiScreen.getScreen().stopScreen();
        return this.selectedProfile;
    }

    private void runMainLoop() throws ProfileException {
        while (!this.exitChooserUI) {
            MainMenuAction selectProfileAction = new MainMenuAction(this, OPTION_SELECT_PROFILE){

                @Override
                public void execute() {
                    try {
                        File profilesParentDirectory = ProfileUtils.getProfilesParentDirectory();
                        guiScreen.showWindow((Window)new SelectProfileWindow(profilesParentDirectory), GUIScreen.Position.CENTER);
                        if (selectedProfile != null) {
                            exitChooserUI = true;
                        }
                    }
                    catch (ProfileException profileException) {
                        LanternaUtils.showErrorMessageBox((GUIScreen)guiScreen, (String)"The profiles parent directory cannot be created or it is not a directory.");
                    }
                }
            };
            MainMenuAction selectDefaultProfileAction = new MainMenuAction(this, OPTION_SELECT_DEFAULT_PROFILE){

                @Override
                public void execute() throws ProfileException {
                    guiScreen.showWindow((Window)new SelectDefaultProfileWindow(), GUIScreen.Position.CENTER);
                }
            };
            MainMenuAction action = this.showMainMenu(selectProfileAction, selectDefaultProfileAction);
            if (action == null) {
                this.exitChooserUI = true;
                return;
            }
            action.execute();
        }
    }

    private MainMenuAction showMainMenu(MainMenuAction selectProfileAction, MainMenuAction selectDefaultProfileAction) {
        return (MainMenuAction)ListSelectDialog.showDialog((GUIScreen)this.guiScreen, (String)"Select Action", null, (Object[])new MainMenuAction[]{selectProfileAction, selectDefaultProfileAction});
    }

    public class DeselectableRadioCheckBoxList
    extends RadioCheckBoxList {
        private static final int UNSELECTED = -1;

        protected Theme.Definition getListItemThemeDefinition(Theme theme) {
            return theme.getDefinition(Theme.Category.DIALOG_AREA);
        }

        protected Interactable.Result unhandledKeyboardEvent(Key key) {
            if (this.getSelectedIndex() == -1) {
                return Interactable.Result.EVENT_NOT_HANDLED;
            }
            if (key.getKind() == Key.Kind.Enter || key.getCharacter() == ' ') {
                if (this.isChecked(this.getSelectedIndex()).booleanValue()) {
                    this.setCheckedItemIndex(-1);
                } else {
                    this.setCheckedItemIndex(this.getSelectedIndex());
                }
                return Interactable.Result.EVENT_HANDLED;
            }
            return Interactable.Result.EVENT_NOT_HANDLED;
        }
    }

    private abstract class MainMenuAction {
        private final String label;

        MainMenuAction(String label) {
            this.label = label;
        }

        public abstract void execute() throws ProfileException;

        public String toString() {
            return this.label;
        }
    }

    private class SelectDefaultProfileWindow
    extends Window {
        SelectDefaultProfileWindow() throws ProfileException {
            super(ProfileSelectionUI.OPTION_SELECT_DEFAULT_PROFILE);
            File profileParentDirectory = ProfileUtils.getProfilesParentDirectory();
            String allProfilesPanelLabel = StringUtils.format((String)"All available profiles in %s", (Object[])new Object[]{profileParentDirectory.getAbsolutePath()});
            Panel allProfilesPanel = new Panel(allProfilesPanelLabel);
            allProfilesPanel.setBorder((Border)new Border.Standard());
            final DeselectableRadioCheckBoxList allProfilesListBox = new DeselectableRadioCheckBoxList();
            allProfilesListBox.setPreferredSize(new TerminalSize(60, 10));
            File savedDefaultProfile = null;
            try {
                savedDefaultProfile = CommonProfileUtils.getSavedDefaultProfile();
            }
            catch (CommonProfileException e) {
                LanternaUtils.showErrorMessageBox((GUIScreen)ProfileSelectionUI.this.guiScreen, (String)e.getMessage());
            }
            for (Profile profile : ProfileUtils.listProfiles(profileParentDirectory)) {
                allProfilesListBox.addItem(profile);
                if (savedDefaultProfile == null || !savedDefaultProfile.getAbsolutePath().equals(profile.getProfileDirectory().getAbsolutePath())) continue;
                int index = allProfilesListBox.getNrOfItems() - 1;
                allProfilesListBox.setCheckedItemIndex(index);
            }
            allProfilesPanel.addComponent((Component)allProfilesListBox, new LayoutParameter[0]);
            this.addComponent((Component)allProfilesPanel, new LayoutParameter[0]);
            int width = allProfilesPanel.getPreferredSize().getColumns();
            Label warning = new Label(LanternaUtils.applyWordWrapping((String)ProfileSelectionUI.DEFAULT_WARNING_TEXT, (int)width));
            this.addComponent((Component)warning, new LayoutParameter[0]);
            Action okAction = new Action(){

                public void doAction() {
                    Object checkedItem = allProfilesListBox.getCheckedItem();
                    if (checkedItem == null) {
                        try {
                            CommonProfileUtils.clearDefaultProfile();
                            LanternaUtils.showSuccessMessageBox((GUIScreen)ProfileSelectionUI.this.guiScreen, (String)"No profile is selected as default profile.");
                        }
                        catch (CommonProfileException commonProfileException) {}
                    } else {
                        Profile checkedProfile = (Profile)checkedItem;
                        try {
                            checkedProfile.markAsDefaultProfile();
                            LanternaUtils.showSuccessMessageBox((GUIScreen)ProfileSelectionUI.this.guiScreen, (String)StringUtils.format((String)"Marked \"%s\" as the default profile.", (Object[])new Object[]{checkedProfile.getName()}));
                        }
                        catch (ProfileException profileException) {
                            LanternaUtils.showErrorMessageBox((GUIScreen)ProfileSelectionUI.this.guiScreen, (String)"Unable to store default profile selection.");
                        }
                    }
                    SelectDefaultProfileWindow.this.close();
                }
            };
            final Action cancelAction = () -> ((SelectDefaultProfileWindow)this).close();
            this.addComponent((Component)LanternaUtils.createOkCancelButtonPanel((Action)okAction, (Action)cancelAction), new LayoutParameter[0]);
            this.addWindowListener((WindowListener)new WindowAdapter(){

                public void onUnhandledKeyboardInteraction(Window arg0, Key key) {
                    if (key.getKind() == Key.Kind.Escape) {
                        cancelAction.doAction();
                    }
                }
            });
        }
    }

    private class SelectProfileWindow
    extends Window {
        SelectProfileWindow(File profileParentDirectory) {
            super(ProfileSelectionUI.OPTION_SELECT_PROFILE);
            Panel defaultProfilePanel = this.createDefaultProfilePanel();
            this.addComponent((Component)defaultProfilePanel, new LayoutParameter[0]);
            Panel recentProfilePanel = this.createRecentProfilePanel();
            this.addComponent((Component)recentProfilePanel, new LayoutParameter[0]);
            Panel allProfilesPanel = this.createAllProfilesPanel(profileParentDirectory);
            this.addComponent((Component)allProfilesPanel, new LayoutParameter[0]);
            this.addWindowListener((WindowListener)new WindowAdapter(){

                public void onUnhandledKeyboardInteraction(Window arg0, Key key) {
                    if (key.getKind() == Key.Kind.Escape) {
                        SelectProfileWindow.this.close();
                    }
                }
            });
            int w1 = defaultProfilePanel.getPreferredSize().getColumns();
            int w2 = recentProfilePanel.getPreferredSize().getColumns();
            int w3 = allProfilesPanel.getPreferredSize().getColumns();
            int width = Math.max(Math.max(60, w1), Math.max(w2, w3));
            defaultProfilePanel.setPreferredSize(new TerminalSize(width, 3));
            recentProfilePanel.setPreferredSize(new TerminalSize(width, 7));
            allProfilesPanel.setPreferredSize(new TerminalSize(width, 7));
        }

        private Panel createDefaultProfilePanel() {
            Panel defaultProfilePanel = new Panel("Start RCE with the default profile");
            defaultProfilePanel.setBorder((Border)new Border.Standard());
            ActionListBox defaultProfileListBox = new ActionListBox();
            try {
                File defaultProfilePath = ProfileUtils.getDefaultProfilePath();
                Action startWithDefaultProfileAction = () -> {
                    try {
                        ProfileSelectionUI.this.selectedProfile = new CommonProfile.Builder(defaultProfilePath).create(true).migrate(false).buildUserProfile();
                        this.close();
                    }
                    catch (ProfileException e) {
                        LanternaUtils.showErrorMessageBox((GUIScreen)ProfileSelectionUI.this.guiScreen, (String)e.getMessage());
                    }
                };
                defaultProfileListBox.addAction(defaultProfilePath.getAbsolutePath(), startWithDefaultProfileAction);
                defaultProfilePanel.addComponent((Component)defaultProfileListBox, new LayoutParameter[0]);
            }
            catch (ProfileException profileException) {
                defaultProfilePanel.addComponent((Component)new Label("Unable to determine the default profile.", 60), new LayoutParameter[0]);
            }
            return defaultProfilePanel;
        }

        private Panel createRecentProfilePanel() {
            Panel recentProfilePanel = new Panel("Recently used profiles");
            recentProfilePanel.setBorder((Border)new Border.Standard());
            ActionListBox recentProfileListBox = new ActionListBox();
            List<Profile> recentlyUsedProfiles = null;
            try {
                recentlyUsedProfiles = CommonProfileUtils.getRecentlyUsedProfiles();
            }
            catch (CommonProfileException commonProfileException) {}
            if (recentlyUsedProfiles == null) {
                recentProfilePanel.addComponent((Component)new Label("Unable to load most recently used profiles.", 60), new LayoutParameter[0]);
            } else {
                LinkedList<Profile> compatibleProfiles = new LinkedList<Profile>();
                for (Profile recentlyUsedProfile : recentlyUsedProfiles) {
                    try {
                        if (!recentlyUsedProfile.hasUpgradeableVersion()) continue;
                        compatibleProfiles.add(recentlyUsedProfile);
                    }
                    catch (ProfileException e) {
                        recentProfilePanel.addComponent((Component)new Label("Could not determine version of profile \"%s\". See log for more details.", 60), new LayoutParameter[0]);
                        ProfileSelectionUI.this.log.error((Object)String.format("Could not determine version of profile \"%s\".", recentlyUsedProfile.getName()), (Throwable)e);
                    }
                }
                for (Profile profile : compatibleProfiles) {
                    Action startWithProfileAction = () -> {
                        ProfileSelectionUI.this.selectedProfile = profile;
                        this.close();
                    };
                    recentProfileListBox.addAction(profile.getProfileDirectory().getAbsolutePath(), startWithProfileAction);
                }
                recentProfilePanel.addComponent((Component)recentProfileListBox, new LayoutParameter[0]);
            }
            return recentProfilePanel;
        }

        private Panel createAllProfilesPanel(File profileParentDirectory) {
            String allProfilesPanelLabel = StringUtils.format((String)"All available profiles in %s", (Object[])new Object[]{profileParentDirectory.getAbsolutePath()});
            Panel allProfilesPanel = new Panel(allProfilesPanelLabel);
            allProfilesPanel.setBorder((Border)new Border.Standard());
            ActionListBox allProfilesListBox = new ActionListBox();
            List<Profile> allProfiles = ProfileUtils.listProfiles(profileParentDirectory);
            LinkedList<Profile> compatibleProfiles = new LinkedList<Profile>();
            for (Profile profile : allProfiles) {
                try {
                    if (!profile.hasCurrentVersion() && !profile.hasUpgradeableVersion()) continue;
                    compatibleProfiles.add(profile);
                }
                catch (ProfileException e) {
                    allProfilesPanel.addComponent((Component)new Label("Could not determine version of profile \"%s\". See log for more details.", 60), new LayoutParameter[0]);
                    ProfileSelectionUI.this.log.error((Object)String.format("Could not determine version of profile \"%s\".", profile.getName()), (Throwable)e);
                }
            }
            for (Profile profile : compatibleProfiles) {
                Action startWithProfileAction = () -> {
                    ProfileSelectionUI.this.selectedProfile = profile;
                    this.close();
                };
                allProfilesListBox.addAction(profile.getName(), startWithProfileAction);
            }
            allProfilesPanel.addComponent((Component)allProfilesListBox, new LayoutParameter[0]);
            return allProfilesPanel;
        }
    }
}

