/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.gui.introduction.SaveUserInputParameters;
import de.rcenvironment.core.gui.introduction.WelcomeScreenScriptFile;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.osgi.service.prefs.BackingStoreException;

public class SaveUserInput
implements IIntroAction {
    private static final String RELATIVE_PATH_TO_BUNDLE = SaveUserInput.getRelativePathToBundle();
    private static final String RELATIVE_PATH_TO_SCRIPT_FOLDER = "content/script/";
    private static final String SCRIPT_FILENAME = "intro.js";
    private static final String ABSOLUTE_PATH_TO_SCRIPT = Paths.get(RELATIVE_PATH_TO_BUNDLE, "content/script/", "intro.js").toString();
    private final Log log = LogFactory.getLog(this.getClass());

    private static String getRelativePathToBundle() {
        String relativePathToBundle = Platform.getBundle((String)"de.rcenvironment.core.gui.introduction").getLocation();
        relativePathToBundle = relativePathToBundle.substring(relativePathToBundle.indexOf("/") + 1, relativePathToBundle.length());
        return relativePathToBundle;
    }

    public void run(IIntroSite site, Properties properties) {
        SaveUserInputParameters parameters = SaveUserInputParameters.createFromProperties(properties);
        this.storeCheckboxValueToPreferences(parameters.isCheckboxChecked());
        this.persistUserPreferenceToScriptFile();
    }

    private void persistUserPreferenceToScriptFile() {
        try {
            boolean preferencesContainShowIntroKey = this.preferencesContainShowIntroKey();
            WelcomeScreenScriptFile scriptFile = WelcomeScreenScriptFile.createFromAbsolutePath(ABSOLUTE_PATH_TO_SCRIPT);
            scriptFile.persistUserChoice(preferencesContainShowIntroKey);
        }
        catch (BackingStoreException e) {
            this.logExceptionAsError(e);
        }
    }

    private boolean preferencesContainShowIntroKey() throws BackingStoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui");
        preferences.flush();
        List<String> prefKeyList = Arrays.asList(preferences.keys());
        return prefKeyList.contains("showIntro");
    }

    private void storeCheckboxValueToPreferences(boolean userHasCheckedCheckbox) {
        PlatformUI.getPreferenceStore().setValue("showIntro", !userHasCheckedCheckbox);
    }

    private void logExceptionAsError(BackingStoreException e) {
        this.log.error((Object)"Preferences operation could not be completed", (Throwable)e);
    }
}

