/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.SecureStorageImportService;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SecureStorageImportServiceImpl
implements SecureStorageImportService {
    @Reference
    private SecureStorageService secureStorageService;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void processImportDirectory(File importDirectory, String secureStoreParentPath, BiFunction<String, String, String> keyMapping, BiFunction<String, String, String> valueMapping, boolean trim, boolean failOnMultiLine) throws OperationFailureException {
        if (!importDirectory.isDirectory()) {
            this.log.debug((Object)("Import directory " + importDirectory.getAbsolutePath() + " does not exist or is not a directory, so it will be ignored"));
            return;
        }
        this.log.debug((Object)("Checking import directory " + importDirectory.getAbsolutePath()));
        Collection files = FileUtils.listFiles((File)importDirectory, null, (boolean)false);
        for (File file : files) {
            this.processImportFile(file, secureStoreParentPath, keyMapping, valueMapping, trim, failOnMultiLine);
        }
    }

    @Override
    public boolean processImportFile(File importFile, String secureStoreParentPath, BiFunction<String, String, String> keyMapping, BiFunction<String, String, String> valueMapping, boolean trim, boolean failOnMultiLine) throws OperationFailureException {
        String content;
        importFile = importFile.getAbsoluteFile();
        this.log.debug((Object)("Importing " + importFile + " ..."));
        try {
            content = FileUtils.readFileToString((File)importFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            this.log.warn((Object)StringUtils.format((String)"Failed to read %s: %s", (Object[])new Object[]{importFile, e.toString()}));
            return false;
        }
        if (trim) {
            content = org.apache.commons.lang3.StringUtils.trim((String)content);
        }
        if (failOnMultiLine && org.apache.commons.lang3.StringUtils.containsAny((CharSequence)content, (char[])new char[]{'\r', '\n'})) {
            this.log.warn((Object)("Ignoring import file " + importFile + " as it contains more than one line of text"));
            return false;
        }
        String sanitizedFileName = importFile.getName();
        if (sanitizedFileName.endsWith(".txt")) {
            sanitizedFileName = sanitizedFileName.substring(0, sanitizedFileName.length() - 4);
        }
        String key = this.deriveStorageKey(sanitizedFileName, content, keyMapping);
        String value = this.deriveStorageValue(sanitizedFileName, content, valueMapping);
        if (key == null) {
            this.log.info((Object)("Ignoring input file " + importFile.getAbsolutePath() + "; check recent log output for details"));
            return false;
        }
        if (value != null) {
            try {
                this.secureStorageService.getSecureStorageSection(secureStoreParentPath).store(key, value);
            }
            catch (IOException e) {
                throw new OperationFailureException("Failed to store the imported data read from " + importFile + ": " + e.toString());
            }
        }
        try {
            this.secureStorageService.getSecureStorageSection(secureStoreParentPath).delete(key);
        }
        catch (IOException e) {
            throw new OperationFailureException("Failed to delete an entry based on the data read from " + importFile + ": " + e.toString());
        }
        try {
            Files.delete(importFile.toPath());
            this.log.info((Object)("Successfully imported and deleted " + importFile));
            return true;
        }
        catch (IOException iOException) {
            this.log.warn((Object)("Successfully imported, but failed to delete " + importFile));
            return true;
        }
    }

    private String deriveStorageKey(String sanitizedFileName, String content, BiFunction<String, String, String> keyMapping) {
        if (keyMapping != null) {
            return keyMapping.apply(sanitizedFileName, content);
        }
        return sanitizedFileName;
    }

    private String deriveStorageValue(String sanitizedFileName, String content, BiFunction<String, String, String> valueMapping) {
        if (valueMapping != null) {
            return valueMapping.apply(sanitizedFileName, content);
        }
        return content;
    }
}

