/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ParallelComponentCaller {
    private static final Log LOG = LogFactory.getLog(ParallelComponentCaller.class);
    private final String logMessagePart;
    private final Set<String> compsToConsider;

    protected ParallelComponentCaller(Set<String> componentsToConsider, WorkflowExecutionContext wfExeCtx) {
        this.compsToConsider = componentsToConsider;
        this.logMessagePart = WorkflowExecutionUtils.substituteWorkflowNameAndExeId(wfExeCtx);
    }

    protected Throwable callParallelAndWait() {
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Throwable.class);
        Iterator<String> iterator = this.compsToConsider.iterator();
        while (iterator.hasNext()) {
            String executionId;
            final String finalExecutionId = executionId = iterator.next();
            callablesGroup.add((Callable)new Callable<Throwable>(){

                @Override
                @TaskDescription(value="Call method of workflow component")
                public Throwable call() throws Exception {
                    try {
                        ParallelComponentCaller.this.callSingleComponent(finalExecutionId);
                    }
                    catch (ExecutionControllerException | RemoteOperationException | RuntimeException e) {
                        ParallelComponentCaller.this.onErrorInSingleComponentCall(finalExecutionId, e);
                        return e;
                    }
                    return null;
                }
            }, StringUtils.format((String)"Call component ('%s'): %s", (Object[])new Object[]{finalExecutionId, this.getMethodToCallAsString()}));
        }
        List throwables = callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
            }
        });
        for (Throwable t : throwables) {
            if (t == null) continue;
            this.logError(t);
        }
        for (Throwable t : throwables) {
            if (t == null) continue;
            return new Throwable(StringUtils.format((String)"Failed to %s component(s)", (Object[])new Object[]{this.getMethodToCallAsString()}), t);
        }
        return null;
    }

    protected abstract void callSingleComponent(String var1) throws ExecutionControllerException, RemoteOperationException;

    protected abstract String getMethodToCallAsString();

    protected void onErrorInSingleComponentCall(String compExeId, Throwable t) {
    }

    protected void logError(Throwable t) {
        if (t instanceof RemoteOperationException) {
            LOG.error((Object)StringUtils.format((String)"Failed to %s component(s) of %s; cause: %s", (Object[])new Object[]{this.getMethodToCallAsString(), this.logMessagePart, t.toString()}));
        } else {
            LOG.error((Object)StringUtils.format((String)"Failed to %s component(s) of %s", (Object[])new Object[]{this.getMethodToCallAsString(), this.logMessagePart, t}));
        }
    }
}

