/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.executor.properties;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class WhitespaceShowListener
implements PaintListener {
    private static final char SPACE_SIGN = '\u00b7';
    private static final char IDEOGRAPHIC_SPACE_SIGN = '\u00b0';
    private static final char TAB_SIGN = '\u00bb';
    private static final char CARRIAGE_RETURN_SIGN = '\u00a4';
    private static final char LINE_FEED_SIGN = '\u00b6';
    private StyledText scriptingText;
    private boolean on;
    private Color fg = null;

    public WhitespaceShowListener(StyledText scriptingText) {
        this.scriptingText = scriptingText;
        this.on = false;
        this.fg = Display.getCurrent().getSystemColor(15);
    }

    public void handleDrawRequest(GC gc) {
        int endLine;
        if (!this.on) {
            return;
        }
        int startLine = this.scriptingText.getTopIndex() - 1;
        if (startLine < 0) {
            startLine = 0;
        }
        if ((endLine = this.scriptingText.getTopIndex() + 1 + this.scriptingText.getBounds().height / this.scriptingText.getLineHeight()) > this.scriptingText.getLineCount() - 1) {
            endLine = this.scriptingText.getLineCount() - 1;
        }
        int startOffset = this.scriptingText.getOffsetAtLine(startLine);
        int endOffset = this.scriptingText.getOffsetAtLine(endLine) + this.scriptingText.getLine(endLine).length() - 1;
        String text = this.scriptingText.getText();
        StringBuffer visibleChar = new StringBuffer(10);
        int textOffset = startOffset;
        while (textOffset <= endOffset) {
            block14: {
                boolean eol;
                int delta;
                block13: {
                    delta = 0;
                    eol = false;
                    if (textOffset >= text.length()) break block13;
                    delta = 1;
                    char c = text.charAt(textOffset);
                    switch (c) {
                        case ' ': {
                            visibleChar.append('\u00b7');
                            break;
                        }
                        case '\u3000': {
                            visibleChar.append('\u00b0');
                            break;
                        }
                        case '\t': {
                            visibleChar.append('\u00bb');
                            break;
                        }
                        case '\r': {
                            visibleChar.append('\u00a4');
                            if (textOffset >= text.length() - 1 || text.charAt(textOffset + 1) != '\n') {
                                eol = true;
                                break;
                            }
                            break block14;
                        }
                        case '\n': {
                            visibleChar.append('\u00b6');
                            break;
                        }
                        default: {
                            delta = 0;
                        }
                    }
                }
                if (!eol && visibleChar.length() > 0) {
                    int widgetOffset = 0 + textOffset - visibleChar.length() + delta;
                    this.draw(gc, widgetOffset, visibleChar.toString());
                }
                visibleChar.delete(0, visibleChar.length());
            }
            ++textOffset;
        }
    }

    private void draw(GC gc, int offset, String s) {
        int baseline = this.scriptingText.getBaseline(offset);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int fontBaseline = fontMetrics.getAscent() + fontMetrics.getLeading();
        int baslineDelta = baseline - fontBaseline;
        Point pos = this.scriptingText.getLocationAtOffset(offset);
        gc.setForeground(this.fg);
        gc.drawString(s, pos.x, pos.y + baslineDelta, true);
    }

    public void drawStyledText() {
        GC gc = new GC((Drawable)this.scriptingText);
        gc.setAdvanced(false);
        this.handleDrawRequest(gc);
    }

    public void redrawAll() {
        this.scriptingText.redraw();
    }

    public void paintControl(PaintEvent event) {
        this.handleDrawRequest(event.gc);
    }

    public boolean isEnabled() {
        return this.on;
    }

    public void setEnabled(boolean enabled) {
        this.on = enabled;
    }
}

