/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.wizards.toolintegration.WizardToolConfigurationDialog;
import de.rcenvironment.core.gui.wizards.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ToolConfigurationPage
extends ToolIntegrationWizardPage {
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_launchsettings";
    private static final int INDENT_KEEP_ON_ERROR_BUTTON = 20;
    private static final int TOOL_CONFIG_TABLE_HEIGHT = 100;
    private Table toolConfigTable;
    private Button tableButtonAdd;
    private Button tableButtonEdit;
    private Button tableButtonRemove;
    private Map<String, Object> configurationMap;
    private Button iterationDirectoryCheckbox;
    private Button copyNeverButton;
    private Button copyOnceButton;
    private Button copyAlwaysButton;
    private Button deleteTempDirNeverCheckbox;
    private Button deleteTempDirOnceCheckbox;
    private Button deleteTempDirAlwaysCheckbox;
    private Button deleteTempDirNotOnErrorIterationCheckbox;
    private Button deleteTempDirNotOnErrorOnceCheckbox;

    protected ToolConfigurationPage(String pageName, Map<String, Object> configurationMap) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.toolConfigPageDescription);
        this.configurationMap = configurationMap;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        GridData g = new GridData(768);
        container.setLayoutData((Object)g);
        this.createTable(container);
        Composite checkboxComposite = new Composite(container, 0);
        checkboxComposite.setLayout((Layout)new GridLayout(1, false));
        GridData iterationCheckboxCompositeData = new GridData();
        iterationCheckboxCompositeData.horizontalSpan = 2;
        checkboxComposite.setLayoutData((Object)iterationCheckboxCompositeData);
        this.iterationDirectoryCheckbox = this.createSingleCheckboxes(checkboxComposite, Messages.useIterationDirectoriesText, "useIterationDirectories");
        Composite groupsComposite = new Composite(container, 0);
        groupsComposite.setLayout((Layout)new GridLayout(2, false));
        GridData groupCompositeData = new GridData();
        groupCompositeData.horizontalSpan = 2;
        groupsComposite.setLayoutData((Object)groupCompositeData);
        Group copyToolBehaviorGroup = new Group(groupsComposite, 0);
        copyToolBehaviorGroup.setText(Messages.copyGroupTitle);
        copyToolBehaviorGroup.setLayout((Layout)new GridLayout(1, false));
        copyToolBehaviorGroup.setLayoutData((Object)new GridData(1808));
        this.copyNeverButton = this.createCopyRadioButton((Composite)copyToolBehaviorGroup, Messages.copyNever, "never");
        this.copyNeverButton.setSelection(true);
        this.copyOnceButton = this.createCopyRadioButton((Composite)copyToolBehaviorGroup, Messages.copyOnce, "once");
        this.copyAlwaysButton = this.createCopyRadioButton((Composite)copyToolBehaviorGroup, Messages.copyAlways, "always");
        Group deleteTempDirBehaviorGroup = new Group(groupsComposite, 0);
        deleteTempDirBehaviorGroup.setText(Messages.deleteGroupTitle);
        deleteTempDirBehaviorGroup.setLayout((Layout)new GridLayout(1, false));
        deleteTempDirBehaviorGroup.setLayoutData((Object)new GridData(768));
        this.deleteTempDirNeverCheckbox = this.createDeleteTempDirectoryCheckbox((Composite)deleteTempDirBehaviorGroup, Messages.deleteNever, "deleteWorkingDirectoriesNever");
        this.deleteTempDirOnceCheckbox = this.createDeleteTempDirectoryCheckbox((Composite)deleteTempDirBehaviorGroup, Messages.deleteOnce, "deleteWorkingDirectoriesAfterWorkflowExecution");
        this.deleteTempDirOnceCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolConfigurationPage.this.deleteTempDirNotOnErrorOnceCheckbox.setEnabled(ToolConfigurationPage.this.deleteTempDirOnceCheckbox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.deleteTempDirNotOnErrorOnceCheckbox = this.createDeleteTempDirectoryCheckbox((Composite)deleteTempDirBehaviorGroup, Messages.deleteNotOnErrorOnce, "deleteWorkingDirectoriesKeepOnErrorOnce");
        GridData keepOnErrorOnceData = new GridData();
        keepOnErrorOnceData.horizontalIndent = 20;
        this.deleteTempDirNotOnErrorOnceCheckbox.setLayoutData((Object)keepOnErrorOnceData);
        this.deleteTempDirAlwaysCheckbox = this.createDeleteTempDirectoryCheckbox((Composite)deleteTempDirBehaviorGroup, Messages.deleteAlways, "deleteWorkingDirectoriesAfterIteration");
        this.deleteTempDirAlwaysCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolConfigurationPage.this.deleteTempDirNotOnErrorIterationCheckbox.setEnabled(ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.deleteTempDirNotOnErrorIterationCheckbox = this.createDeleteTempDirectoryCheckbox((Composite)deleteTempDirBehaviorGroup, Messages.deleteNotOnErrorIteration, "deleteWorkingDirectoriesKeepOnErrorIteration");
        GridData keepOnErrorIterationData = new GridData();
        keepOnErrorIterationData.horizontalIndent = 20;
        this.deleteTempDirNotOnErrorIterationCheckbox.setLayoutData((Object)keepOnErrorIterationData);
        new Label((Composite)deleteTempDirBehaviorGroup, 0).setText(Messages.deleteToolNote);
        this.updateCheckBoxes();
        this.updateButtonActivation();
        this.setPageComplete(false);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.updatePageComplete();
    }

    private Button createCopyRadioButton(Composite copyToolBehaviorGroup, String text, final String key) {
        Button newButton = new Button(copyToolBehaviorGroup, 16);
        newButton.setText(text);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolConfigurationPage.this.configurationMap.put("copyToolBehavior", key);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        return newButton;
    }

    private Button createDeleteTempDirectoryCheckbox(Composite container, String text, final String key) {
        Button checkBox = new Button(container, 32);
        checkBox.setText(text);
        GridData checkBoxData = new GridData();
        checkBox.setLayoutData((Object)checkBoxData);
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolConfigurationPage.this.configurationMap.put(key, ((Button)arg0.getSource()).getSelection());
                ToolConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        return checkBox;
    }

    private Button createSingleCheckboxes(Composite container, String text, final String key) {
        Button checkBox = new Button(container, 32);
        checkBox.setText(text);
        GridData checkBoxData = new GridData();
        checkBox.setLayoutData((Object)checkBoxData);
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolConfigurationPage.this.configurationMap.put(key, ((Button)arg0.getSource()).getSelection());
                if (arg0.getSource().equals(ToolConfigurationPage.this.iterationDirectoryCheckbox)) {
                    if (ToolConfigurationPage.this.copyAlwaysButton.getSelection() && !((Button)arg0.getSource()).getSelection()) {
                        ToolConfigurationPage.this.copyAlwaysButton.setSelection(false);
                        ToolConfigurationPage.this.copyOnceButton.setSelection(true);
                        ToolConfigurationPage.this.configurationMap.put("copyToolBehavior", "once");
                    }
                    if (ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.getSelection() && !((Button)arg0.getSource()).getSelection()) {
                        ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.setSelection(false);
                        ToolConfigurationPage.this.deleteTempDirNotOnErrorIterationCheckbox.setSelection(false);
                        ToolConfigurationPage.this.configurationMap.put("deleteWorkingDirectoriesAfterIteration", false);
                    }
                    ToolConfigurationPage.this.copyAlwaysButton.setEnabled(((Button)arg0.getSource()).getSelection());
                    ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.setEnabled(((Button)arg0.getSource()).getSelection());
                    ToolConfigurationPage.this.deleteTempDirNotOnErrorIterationCheckbox.setEnabled(((Button)arg0.getSource()).getSelection() && ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.isEnabled() && ToolConfigurationPage.this.deleteTempDirAlwaysCheckbox.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        return checkBox;
    }

    private void createTable(Composite client) {
        Composite tableComposite = new Composite(client, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this.toolConfigTable = new Table(tableComposite, 68356);
        this.toolConfigTable.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 4);
        tableLayoutData.heightHint = 100;
        tableComposite.setLayoutData((Object)tableLayoutData);
        TableColumn col1 = new TableColumn(this.toolConfigTable, 0);
        col1.setText(Messages.host);
        TableColumn col2 = new TableColumn(this.toolConfigTable, 0);
        col2.setText(Messages.toolDirectory);
        TableColumn col3 = new TableColumn(this.toolConfigTable, 0);
        col3.setText(Messages.version);
        TableColumn col4 = new TableColumn(this.toolConfigTable, 0);
        col4.setText(Messages.rootWorkingDir);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(30, true));
        this.tableButtonAdd = new Button(client, 0x800000);
        this.tableButtonAdd.setText(Messages.add);
        this.tableButtonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableButtonAdd.addSelectionListener((SelectionListener)new ButtonSelectionListener(this.tableButtonAdd, this.toolConfigTable));
        this.tableButtonEdit = new Button(client, 0x800000);
        this.tableButtonEdit.setText(Messages.edit);
        this.tableButtonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableButtonEdit.addSelectionListener((SelectionListener)new ButtonSelectionListener(this.tableButtonEdit, this.toolConfigTable));
        this.tableButtonRemove = new Button(client, 0x800000);
        this.tableButtonRemove.setText(Messages.remove);
        this.tableButtonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableButtonRemove.addSelectionListener((SelectionListener)new ButtonSelectionListener(this.tableButtonRemove, this.toolConfigTable));
        this.fillContextMenu(this.toolConfigTable);
        this.toolConfigTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolConfigurationPage.this.updateButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.toolConfigTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = ToolConfigurationPage.this.toolConfigTable.getSelection();
                ToolConfigurationPage.this.editSelection(selection);
            }
        });
        this.toolConfigTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] selection = ToolConfigurationPage.this.toolConfigTable.getSelection();
                    ToolConfigurationPage.this.removeSelection(selection);
                    ToolConfigurationPage.this.updateTable();
                    ToolConfigurationPage.this.updateButtonActivation();
                }
            }
        });
    }

    private void updatePageComplete() {
        String errorMessage = "";
        boolean isPageComplete = true;
        List launchSettings = (List)this.configurationMap.get("launchSettings");
        if (launchSettings == null || launchSettings.isEmpty()) {
            errorMessage = String.valueOf(errorMessage) + Messages.toolExecutionConfigurationNeeded + "\n";
            isPageComplete &= false;
        } else if (!(this.deleteTempDirAlwaysCheckbox.getSelection() || this.deleteTempDirNeverCheckbox.getSelection() || this.deleteTempDirOnceCheckbox.getSelection())) {
            errorMessage = String.valueOf(errorMessage) + Messages.tempDirBehaviourNeeded;
            isPageComplete &= false;
        }
        if (!isPageComplete) {
            this.setMessage(errorMessage, 3);
        } else if (this.toolConfigTable.getItemCount() > 0) {
            Optional error = ComponentIdRules.validateComponentVersionRules((String)this.toolConfigTable.getItem(0).getText(2));
            if (error.isPresent()) {
                this.setMessage(StringUtils.format((String)"The chosen version is not valid.\n %s.", (Object[])new Object[]{error.get()}), 3);
                isPageComplete = false;
            } else {
                this.setMessage("Currently, only one launch setting is possible", 2);
            }
        } else {
            this.setMessage(errorMessage, 0);
        }
        this.setPageComplete(isPageComplete);
    }

    private void updateCheckBoxes() {
        if (this.configurationMap.get("useIterationDirectories") != null && ((Boolean)this.configurationMap.get("useIterationDirectories")).booleanValue()) {
            this.iterationDirectoryCheckbox.setSelection(true);
            this.copyAlwaysButton.setEnabled(true);
            this.deleteTempDirAlwaysCheckbox.setEnabled(true);
        } else {
            this.copyAlwaysButton.setEnabled(false);
            this.copyAlwaysButton.setSelection(false);
            this.deleteTempDirAlwaysCheckbox.setEnabled(false);
            this.iterationDirectoryCheckbox.setSelection(false);
        }
        ToolIntegrationContext context = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext();
        this.copyNeverButton.setEnabled(true);
        this.copyOnceButton.setEnabled(true);
        this.copyAlwaysButton.setEnabled(this.iterationDirectoryCheckbox.getSelection());
        if (context.getDisabledIntegrationKeys() != null) {
            String[] stringArray = context.getDisabledIntegrationKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if ("never".equals(key)) {
                    this.copyNeverButton.setEnabled(false);
                }
                if ("once".equals(key)) {
                    this.copyOnceButton.setEnabled(false);
                }
                if ("always".equals(key)) {
                    this.copyAlwaysButton.setEnabled(false);
                }
                ++n2;
            }
        }
        if (this.configurationMap.get("copyToolBehavior") != null) {
            if (((String)this.configurationMap.get("copyToolBehavior")).equals("never")) {
                this.copyNeverButton.setSelection(true);
                this.copyOnceButton.setSelection(false);
                this.copyAlwaysButton.setSelection(false);
            } else if (((String)this.configurationMap.get("copyToolBehavior")).equals("once")) {
                this.copyOnceButton.setSelection(true);
                this.copyNeverButton.setSelection(false);
                this.copyAlwaysButton.setSelection(false);
            } else if (((String)this.configurationMap.get("copyToolBehavior")).equals("always")) {
                if (this.copyAlwaysButton.isEnabled()) {
                    this.copyAlwaysButton.setSelection(true);
                    this.copyNeverButton.setSelection(false);
                    this.copyOnceButton.setSelection(false);
                } else {
                    this.copyAlwaysButton.setSelection(false);
                    this.copyNeverButton.setSelection(false);
                    this.copyOnceButton.setSelection(true);
                }
            }
        } else if (this.copyNeverButton.isEnabled()) {
            this.copyAlwaysButton.setSelection(false);
            this.copyOnceButton.setSelection(false);
            this.copyNeverButton.setSelection(true);
            this.configurationMap.put("copyToolBehavior", "never");
        } else if (this.copyAlwaysButton.isEnabled()) {
            this.copyAlwaysButton.setSelection(true);
            this.copyNeverButton.setSelection(false);
            this.copyOnceButton.setSelection(false);
            this.configurationMap.put("copyToolBehavior", "always");
        } else {
            this.configurationMap.put("copyToolBehavior", "once");
        }
        if (!this.copyNeverButton.isEnabled() && this.copyNeverButton.getSelection()) {
            this.copyOnceButton.setSelection(true);
            this.copyNeverButton.setSelection(false);
        }
        if (!this.copyOnceButton.isEnabled() && this.copyOnceButton.getSelection()) {
            this.copyNeverButton.setSelection(true);
            this.copyOnceButton.setSelection(false);
        }
        if (this.configurationMap.get("deleteWorkingDirectoriesNever") != null && ((Boolean)this.configurationMap.get("deleteWorkingDirectoriesNever")).booleanValue()) {
            this.deleteTempDirNeverCheckbox.setSelection(true);
        } else {
            this.deleteTempDirNeverCheckbox.setSelection(false);
        }
        if (this.configurationMap.get("deleteWorkingDirectoriesAfterWorkflowExecution") != null && ((Boolean)this.configurationMap.get("deleteWorkingDirectoriesAfterWorkflowExecution")).booleanValue()) {
            this.deleteTempDirOnceCheckbox.setSelection(true);
        } else {
            this.deleteTempDirOnceCheckbox.setSelection(false);
        }
        if (this.configurationMap.get("deleteWorkingDirectoriesAfterIteration") != null && ((Boolean)this.configurationMap.get("deleteWorkingDirectoriesAfterIteration")).booleanValue()) {
            this.deleteTempDirAlwaysCheckbox.setSelection(true);
        } else {
            this.deleteTempDirAlwaysCheckbox.setSelection(false);
        }
        if (this.configurationMap.get("deleteWorkingDirectoriesKeepOnErrorIteration") != null && ((Boolean)this.configurationMap.get("deleteWorkingDirectoriesKeepOnErrorIteration")).booleanValue()) {
            this.deleteTempDirNotOnErrorIterationCheckbox.setSelection(true);
        }
        if (this.configurationMap.get("deleteWorkingDirectoriesKeepOnErrorOnce") != null && ((Boolean)this.configurationMap.get("deleteWorkingDirectoriesKeepOnErrorOnce")).booleanValue()) {
            this.deleteTempDirNotOnErrorOnceCheckbox.setSelection(true);
        }
        this.deleteTempDirNotOnErrorIterationCheckbox.setEnabled(this.deleteTempDirAlwaysCheckbox.isEnabled() && this.deleteTempDirAlwaysCheckbox.getSelection());
        this.deleteTempDirNotOnErrorOnceCheckbox.setEnabled(this.deleteTempDirOnceCheckbox.getSelection());
        this.deleteTempDirNotOnErrorOnceCheckbox.setSelection(this.deleteTempDirNotOnErrorOnceCheckbox.getSelection() && this.deleteTempDirNotOnErrorOnceCheckbox.isEnabled());
        this.deleteTempDirNotOnErrorIterationCheckbox.setSelection(this.deleteTempDirNotOnErrorIterationCheckbox.getSelection() && this.deleteTempDirNotOnErrorIterationCheckbox.isEnabled() && this.iterationDirectoryCheckbox.getSelection());
    }

    private void updateTable() {
        this.toolConfigTable.removeAll();
        if (this.configurationMap.get("launchSettings") != null) {
            List configs = (List)this.configurationMap.get("launchSettings");
            for (Map currentConfig : configs) {
                TableItem item = new TableItem(this.toolConfigTable, 0);
                item.setText(0, (String)currentConfig.get("host"));
                item.setText(1, (String)currentConfig.get("toolDirectory"));
                item.setText(2, (String)currentConfig.get("version"));
                String rootDir = (String)currentConfig.get("rootWorkingDirectory");
                if (rootDir == null || rootDir.isEmpty()) {
                    item.setText(3, "RCE temp directory");
                    continue;
                }
                item.setText(3, (String)currentConfig.get("rootWorkingDirectory"));
            }
        }
        this.updatePageComplete();
    }

    private void updateButtonActivation() {
        boolean hasOneConfig = this.toolConfigTable.getItemCount() > 0;
        this.tableButtonAdd.setEnabled(!hasOneConfig);
        boolean enabled = this.toolConfigTable.getSelection() != null && this.toolConfigTable.getSelectionCount() > 0 && this.toolConfigTable.getItemCount() != 0;
        this.tableButtonEdit.setEnabled(enabled);
        this.tableButtonRemove.setEnabled(enabled);
        this.itemAdd.setEnabled(!hasOneConfig);
        this.itemEdit.setEnabled(enabled);
        this.itemRemove.setEnabled(enabled);
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.updatePageValues();
    }

    private void updatePageValues() {
        this.updateCheckBoxes();
        this.updateTable();
        this.updateButtonActivation();
        this.updatePageComplete();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    private void addSelection() {
        List<Map<String, String>> configs = new LinkedList();
        if (this.configurationMap.get("launchSettings") != null) {
            configs = (List)this.configurationMap.get("launchSettings");
        } else {
            this.configurationMap.put("launchSettings", configs);
        }
        WizardToolConfigurationDialog wtcd = new WizardToolConfigurationDialog(null, Messages.addDiaglogTitle, ((ToolIntegrationWizard)this.getWizard()).getCurrentContext());
        int exit = wtcd.open();
        if (exit == 0) {
            configs.add(wtcd.getConfig());
        }
    }

    private void editSelection(TableItem[] selection) {
        if (selection != null && selection.length > 0) {
            List configs = (List)this.configurationMap.get("launchSettings");
            Map selectedConfig = null;
            for (Map currentConfig : configs) {
                if (!((String)currentConfig.get("host")).equals(selection[0].getText(0)) || !((String)currentConfig.get("toolDirectory")).equals(selection[0].getText(1))) continue;
                selectedConfig = currentConfig;
            }
            HashMap<String, String> selectedConfigCopy = new HashMap<String, String>();
            selectedConfigCopy.putAll(selectedConfig);
            WizardToolConfigurationDialog wtcd = new WizardToolConfigurationDialog(null, Messages.editDiaglogTitle, selectedConfigCopy, ((ToolIntegrationWizard)this.getWizard()).getCurrentContext());
            int exit = wtcd.open();
            if (exit == 0) {
                configs.remove(selectedConfig);
                configs.add(wtcd.getConfig());
                this.configurationMap.remove("launchSettings");
                this.configurationMap.put("launchSettings", configs);
                this.updateTable();
            }
        }
    }

    private void removeSelection(TableItem[] selection) {
        if (selection != null && selection.length > 0) {
            List configs = (List)this.configurationMap.get("launchSettings");
            Map selectedConfig = null;
            for (Map currentConfig : configs) {
                if (!((String)currentConfig.get("host")).equals(selection[0].getText(0)) || !((String)currentConfig.get("toolDirectory")).equals(selection[0].getText(1))) continue;
                selectedConfig = currentConfig;
            }
            configs.remove(selectedConfig);
        }
    }

    @Override
    public void updatePage() {
    }

    @Override
    protected void onAddClicked() {
        this.addSelection();
        this.updateTable();
        this.updateButtonActivation();
    }

    @Override
    protected void onEditClicked() {
        TableItem[] selection = this.toolConfigTable.getSelection();
        this.editSelection(selection);
        this.updateTable();
        this.updateButtonActivation();
    }

    @Override
    protected void onRemoveClicked() {
        TableItem[] selection = this.toolConfigTable.getSelection();
        this.removeSelection(selection);
        this.updateTable();
        this.updateButtonActivation();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private final Button button;
        private final Table table;

        ButtonSelectionListener(Button button, Table table) {
            this.button = button;
            this.table = table;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableItem[] selection = this.table.getSelection();
            if (this.button.equals(ToolConfigurationPage.this.tableButtonAdd)) {
                ToolConfigurationPage.this.addSelection();
            } else if (this.button.equals(ToolConfigurationPage.this.tableButtonEdit)) {
                ToolConfigurationPage.this.editSelection(selection);
            } else if (this.button.equals(ToolConfigurationPage.this.tableButtonRemove)) {
                ToolConfigurationPage.this.removeSelection(selection);
            }
            ToolConfigurationPage.this.updateTable();
            ToolConfigurationPage.this.updateButtonActivation();
        }
    }
}

