/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.relay.internal;

import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.ServerSideUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkEndpointService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.communication.uplink.session.internal.AbstractUplinkSessionImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ServerSideUplinkSessionImpl
extends AbstractUplinkSessionImpl
implements ServerSideUplinkSession {
    private final String clientInformationString;
    private final String localSessionId;
    private String logDescriptor;
    private final CommonUplinkLowLevelProtocolWrapper protocolWrapper;
    private final ServerSideUplinkEndpointService serverSideUplinkEndpointService;
    private final UplinkProtocolMessageConverter messageConverter;

    public ServerSideUplinkSessionImpl(final String clientInformationString, final String loginAccountName, InputStream inputStream, OutputStream outputStream, final ServerSideUplinkEndpointService serverSideUplinkEndpointService, ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        super(concurrencyUtilsFactory);
        this.clientInformationString = clientInformationString;
        this.serverSideUplinkEndpointService = serverSideUplinkEndpointService;
        this.localSessionId = serverSideUplinkEndpointService.assignSessionId(this);
        this.updateLogDescriptor();
        this.messageConverter = new UplinkProtocolMessageConverter("server session " + this.localSessionId);
        this.protocolWrapper = new ServerSideUplinkLowLevelProtocolWrapper(inputStream, outputStream, new UplinkConnectionLowLevelEventHandler(){

            @Override
            public void provideOrProcessHandshakeData(Map<String, String> incomingData, Map<String, String> outgoingData) throws ProtocolException, UplinkConnectionRefusedException {
                String effectiveSessionQualifier;
                String effectiveAccountName;
                String assignedNamespaceId;
                boolean namespaceAcquired;
                ServerSideUplinkSessionImpl.this.markClientHandshakeSentOrReceived();
                Objects.requireNonNull(incomingData);
                Objects.requireNonNull(outgoingData);
                outgoingData.putAll(incomingData);
                String clientProtocolVersion = incomingData.get("protocolVersion");
                if (StringUtils.isNullorEmpty((String)clientProtocolVersion)) {
                    this.refuseConnection(UplinkProtocolErrorType.INVALID_HANDSHAKE_DATA, "Missing handshake version information");
                }
                if (!clientProtocolVersion.equals("alpha6")) {
                    this.refuseConnection(UplinkProtocolErrorType.PROTOCOL_VERSION_MISMATCH, "The client and server are using incompatible versions of the Uplink protocol (" + clientProtocolVersion + " vs. " + "alpha6" + "). Please use a client version matching the server you are connecting to.");
                }
                if (!(namespaceAcquired = serverSideUplinkEndpointService.attemptToAssignNamespaceId(assignedNamespaceId = ServerSideUplinkSessionImpl.this.deriveAssignedNamespaceId(effectiveAccountName = ServerSideUplinkSessionImpl.this.determineEffectiveAccountName(loginAccountName), effectiveSessionQualifier = ServerSideUplinkSessionImpl.this.determineEffectiveSessionQualifier(loginAccountName, incomingData)), ServerSideUplinkSessionImpl.this))) {
                    this.refuseConnection(UplinkProtocolErrorType.CLIENT_NAMESPACE_COLLISION, "The combination of account name \"" + effectiveAccountName + "\" and client ID \"" + effectiveSessionQualifier + "\" is already in use. To allow parallel logins, use a different client ID for each client.");
                }
                ServerSideUplinkSessionImpl.this.setAssignedNamespaceId(assignedNamespaceId);
                ServerSideUplinkSessionImpl.this.updateLogDescriptor();
                outgoingData.put("namespace", assignedNamespaceId);
                if (incomingData.containsKey("simulateHandshakeFailure")) {
                    ServerSideUplinkSessionImpl.this.setSessionState(UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR);
                    throw new ProtocolException(incomingData.get("simulateHandshakeFailure"));
                }
                if (incomingData.containsKey("simulateRefusedConnection")) {
                    this.refuseConnection(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, incomingData.get("simulateRefusedConnection"));
                }
                if (incomingData.containsKey("simulateHandshakeTimeout")) {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ServerSideUplinkSessionImpl.this.log.warn((Object)"Interrupted while simulating handshake timeout");
                    }
                }
                ServerSideUplinkSessionImpl.this.markServerHandshakeSentOrReceived();
            }

            private void refuseConnection(UplinkProtocolErrorType errorType, String errorMessage) throws UplinkConnectionRefusedException {
                ServerSideUplinkSessionImpl.this.setSessionState(UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR);
                throw new UplinkConnectionRefusedException(errorType, errorMessage);
            }

            @Override
            public void onHandshakeComplete() {
                ServerSideUplinkSessionImpl.this.setSessionState(UplinkSessionState.ACTIVE);
            }

            @Override
            public void onRegularGoodbyeMessage() {
                this.closeServerSideSession();
            }

            @Override
            public void onErrorGoodbyeMessage(UplinkProtocolErrorType errorType, String errorMessage) {
                ServerSideUplinkSessionImpl.this.log.info((Object)StringUtils.format((String)"Received a remote error message from %s, closing the session: %s [type %s]", (Object[])new Object[]{clientInformationString, errorMessage, errorType.name()}));
                this.closeServerSideSession();
            }

            @Override
            public void onNonProtocolError(IOException exception) {
                ServerSideUplinkSessionImpl.this.log.warn((Object)StringUtils.format((String)"Non-protocol error in session %s (will be closed): %s", (Object[])new Object[]{clientInformationString, exception.toString()}));
                this.closeServerSideSession();
            }

            private void closeServerSideSession() {
                ServerSideUplinkSessionImpl.this.markAsCloseRequestedByRemoteEvent();
            }

            @Override
            public void onMessageBlock(long channelId, MessageBlock messageBlock) {
                ServerSideUplinkSessionImpl.this.incomingMessageQueue.enqueue(() -> {
                    try {
                        serverSideUplinkEndpointService.onMessageBlock(ServerSideUplinkSessionImpl.this, channelId, messageBlock);
                    }
                    catch (ProtocolException e) {
                        ServerSideUplinkSessionImpl.this.log.error((Object)("Error processing a message received by server session " + ServerSideUplinkSessionImpl.this.getLocalSessionId()), (Throwable)e);
                    }
                });
            }
        }, "server session protocol wrapper " + this.localSessionId);
    }

    @Override
    public boolean runSession() {
        this.log.info((Object)("Handling Uplink session for " + this.clientInformationString));
        long startTime = System.currentTimeMillis();
        try {
            this.protocolWrapper.runSession();
        }
        catch (Throwable throwable) {
            try {
                long execTimeMsec = System.currentTimeMillis() - startTime;
                this.log.debug((Object)StringUtils.format((String)"Uplink session terminated for %s, duration: %d msec", (Object[])new Object[]{this.clientInformationString, execTimeMsec}));
                throw throwable;
            }
            catch (ProtocolException e) {
                this.log.error((Object)StringUtils.format((String)"Protocol error in Uplink session for %s: %s", (Object[])new Object[]{this.clientInformationString, e.getMessage()}));
                return false;
            }
            catch (IOException e) {
                this.log.warn((Object)StringUtils.format((String)"I/O error in Uplink session - the client (%s) may have closed the connection: %s", (Object[])new Object[]{this.clientInformationString, e.toString()}));
                return false;
            }
        }
        long execTimeMsec = System.currentTimeMillis() - startTime;
        this.log.debug((Object)StringUtils.format((String)"Uplink session terminated for %s, duration: %d msec", (Object[])new Object[]{this.clientInformationString, execTimeMsec}));
        return true;
    }

    @Override
    public void close() {
        this.markAsCloseRequestedLocally();
        this.protocolWrapper.closeOutgoingMessageStream();
    }

    @Override
    public CommonUplinkLowLevelProtocolWrapper getProtocolWrapper() {
        return this.protocolWrapper;
    }

    @Override
    public String getLocalSessionId() {
        return this.localSessionId;
    }

    @Override
    protected void onSessionStateChanged(UplinkSessionState oldState, UplinkSessionState newState) {
        boolean abortingPartialHandshake;
        if (newState == UplinkSessionState.ACTIVE) {
            this.serverSideUplinkEndpointService.setSessionActiveState(this, true);
        }
        boolean bl = abortingPartialHandshake = newState == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR && oldState == UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY;
        if (abortingPartialHandshake || newState == UplinkSessionState.PARTIALLY_CLOSED_BY_LOCAL || newState == UplinkSessionState.PARTIALLY_CLOSED_BY_REMOTE) {
            this.releaseNamespaceIdIfPresent();
        }
        if (oldState == UplinkSessionState.ACTIVE) {
            this.serverSideUplinkEndpointService.setSessionActiveState(this, false);
        }
        if (newState == UplinkSessionState.PARTIALLY_CLOSED_BY_REMOTE) {
            this.protocolWrapper.closeOutgoingMessageStream();
            this.markAsCloseRequestedLocally();
        }
    }

    private void releaseNamespaceIdIfPresent() {
        Optional<String> assignedNamespaceId = this.getAssignedNamespaceIdIfAvailable();
        if (assignedNamespaceId.isPresent()) {
            this.serverSideUplinkEndpointService.releaseNamespaceId(assignedNamespaceId.get(), this);
        } else {
            this.log.debug((Object)("Session " + this + " had no namespace assigned when could have been released; this can occur if a client never sends a handshake request"));
        }
    }

    private String determineEffectiveAccountName(String loginAccountName) {
        String effectiveAccountName;
        if (loginAccountName.length() > 8) {
            String truncated = loginAccountName.substring(0, 8);
            this.log.warn((Object)StringUtils.format((String)"Only the first %d characters of the login name '%s' ('%s') will be used for the client's unique identity; if possible, use login names that do not exceed %d characters", (Object[])new Object[]{8, loginAccountName, truncated, 8}));
            effectiveAccountName = truncated;
        } else {
            effectiveAccountName = loginAccountName;
        }
        return effectiveAccountName;
    }

    private String determineEffectiveSessionQualifier(String loginAccountName, Map<String, String> incomingData) {
        String effectiveSessionQualifier;
        String clientSessionQualifier = incomingData.get("sessionQualifier");
        if (StringUtils.isNullorEmpty((String)clientSessionQualifier)) {
            clientSessionQualifier = "default";
            this.log.debug((Object)("An Uplink client using account '" + loginAccountName + "' sent an empty client ID; using '" + clientSessionQualifier + "'"));
        }
        if (clientSessionQualifier.length() > 8) {
            String truncated = clientSessionQualifier.substring(0, 8);
            this.log.warn((Object)StringUtils.format((String)"Truncating client ID '%s' to '%s' as it exceeds the significant character limit (%d)", (Object[])new Object[]{clientSessionQualifier, truncated, 8}));
            effectiveSessionQualifier = truncated;
        } else {
            effectiveSessionQualifier = clientSessionQualifier;
        }
        return effectiveSessionQualifier;
    }

    private String deriveAssignedNamespaceId(String effectiveAccountName, String effectiveSessionQualifier) {
        String namespaceId = String.valueOf(org.apache.commons.lang3.StringUtils.rightPad((String)effectiveAccountName, (int)8, (char)'-')) + org.apache.commons.lang3.StringUtils.rightPad((String)effectiveSessionQualifier, (int)8, (char)'-');
        if (namespaceId.length() != 16) {
            throw new IllegalStateException();
        }
        return namespaceId;
    }
}

