/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccountControl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountImpl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.embedded.ssh.internal.TemporarySshAccountImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.mindrot.jbcrypt.BCrypt;

public class SshAuthenticationManager
implements PasswordAuthenticator,
TemporarySshAccountControl,
PublickeyAuthenticator {
    private SshConfiguration configuration;
    private List<TemporarySshAccount> temporaryAccounts;
    private final Log log = LogFactory.getLog(this.getClass());

    public SshAuthenticationManager(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean authenticate(String usernameParam, String passwordParam, ServerSession session) {
        boolean loginCorrect = false;
        if (usernameParam != null && !usernameParam.isEmpty() && passwordParam != null && !passwordParam.isEmpty()) {
            if (usernameParam.startsWith("t_")) {
                TemporarySshAccount tempUser = this.getTemporaryAccountByName(usernameParam);
                if (tempUser != null && this.checkPassword(tempUser, passwordParam)) {
                    loginCorrect = true;
                }
            } else {
                SshAccount user = this.configuration.getAccountByName(usernameParam, false);
                if (user != null && this.checkPassword(user, passwordParam)) {
                    loginCorrect = true;
                }
            }
        }
        return loginCorrect;
    }

    public boolean authenticate(String userName, PublicKey key, ServerSession session) {
        boolean loginCorrect = false;
        if (this.configuration.getAccountByName(userName, false) == null) {
            return false;
        }
        PublicKey knownKey = this.configuration.getAccountByName(userName, false).getPublicKeyObj();
        if (knownKey != null) {
            loginCorrect = key.equals(knownKey);
        }
        return loginCorrect;
    }

    public boolean isAllowedToExecuteConsoleCommand(String username, String command) {
        boolean isAllowed = false;
        SshAccountRole userRole = this.getRoleForUser(username);
        try {
            if (userRole != null) {
                boolean commandIsOnWhitelist = command.matches(userRole.getAllowedCommandRegEx());
                boolean commandIsOnBlacklist = command.matches(userRole.getDisallowedCommandRegEx());
                if (commandIsOnWhitelist && !commandIsOnBlacklist) {
                    isAllowed = true;
                }
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.log.error((Object)("Could not verify if user " + username + " is allowed to execute command " + command + ". Probable cause: The allowed commands pattern is invalid."));
        }
        return isAllowed;
    }

    public boolean isAllowedToUseScpDestination(String username, String destination) {
        boolean isAllowed = false;
        TemporarySshAccount tempUser = this.getTemporaryAccountByName(username);
        if (tempUser != null) {
            isAllowed = destination != null && destination.startsWith(tempUser.getVirtualScpRootPath()) && !destination.contains("../") && !destination.contains("..\\");
        }
        return isAllowed;
    }

    public boolean isAllowedToOpenShell(String username) {
        return this.getRoleForUser(username).isAllowedToOpenShell();
    }

    public boolean isAllowedToUseUplink(String username) {
        return this.getRoleForUser(username).isAllowedToUseUplink();
    }

    @Deprecated
    public boolean isTemporaryAccountName(String username) {
        return this.getTemporaryAccountByName(username) != null;
    }

    private SshAccountRole getRoleForUser(String userName) {
        SshAccount user = this.configuration.getAccountByName(userName, true);
        SshAccountRole role = null;
        if (user != null) {
            role = this.configuration.getRoleByName(user.getRole());
        }
        return role;
    }

    public SshAccount getAccountByLoginName(String loginName, boolean allowDisabled) {
        return this.configuration.getAccountByName(loginName, allowDisabled);
    }

    public SortedMap<String, SshAccount> getAllAcountsByLoginName() {
        TreeMap<String, SshAccount> result = new TreeMap<String, SshAccount>();
        for (SshAccountImpl account : this.configuration.getAccounts()) {
            result.put(account.getLoginName(), account);
        }
        return result;
    }

    @Deprecated
    public TemporarySshAccount getTemporaryAccountByName(String name) {
        TemporarySshAccount result = null;
        if (this.temporaryAccounts != null) {
            for (TemporarySshAccount tempUser : this.temporaryAccounts) {
                if (!tempUser.getLoginName().equals(name)) continue;
                result = tempUser;
            }
        }
        return result;
    }

    @Deprecated
    public List<TemporarySshAccount> getTemporaryAccounts() {
        return this.temporaryAccounts;
    }

    @Deprecated
    public void setTemporaryAccounts(List<TemporarySshAccount> tempUsers) {
        this.temporaryAccounts = tempUsers;
    }

    @Override
    @Deprecated
    public TemporarySshAccount createTemporarySshAccount() {
        if (this.temporaryAccounts == null) {
            this.temporaryAccounts = new CopyOnWriteArrayList<TemporarySshAccount>();
        }
        TemporarySshAccountImpl tempAccount = new TemporarySshAccountImpl();
        String randomAccountNamePart = RandomStringUtils.randomAlphanumeric((int)6);
        String username = "t_" + randomAccountNamePart;
        tempAccount.setLoginName(username);
        tempAccount.setPassword(RandomStringUtils.randomAlphanumeric((int)6));
        tempAccount.setVirtualScpRootPath("/temp/" + username);
        try {
            tempAccount.setLocalScpRootPath(TempFileServiceAccess.getInstance().createManagedTempDir("temp-scp-" + randomAccountNamePart));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary SCP directory", e);
        }
        this.log.debug((Object)StringUtils.format((String)"Created temporary SCP account '%s' with virtual SCP path '%s' mapped to local path '%s'", (Object[])new Object[]{tempAccount.getLoginName(), tempAccount.getVirtualScpRootPath(), tempAccount.getLocalScpRootPath().getAbsolutePath()}));
        this.temporaryAccounts.add(tempAccount);
        return tempAccount;
    }

    @Override
    @Deprecated
    public void discardTemporarySshAccount(String name) {
        int i = 0;
        while (i < this.temporaryAccounts.size()) {
            TemporarySshAccount tempUser = this.temporaryAccounts.get(i);
            if (tempUser.getLoginName().equals(name)) {
                this.temporaryAccounts.remove(i);
            }
            ++i;
        }
    }

    private boolean checkPassword(SshAccount account, String password) {
        if (account.getPasswordHash() != null) {
            boolean result = BCrypt.checkpw((String)password, (String)account.getPasswordHash());
            this.log.debug((Object)StringUtils.format((String)"Used password hash to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        if (account.getPassword() != null) {
            boolean result = account.getPassword().equals(password);
            this.log.warn((Object)StringUtils.format((String)"Used clear-text password to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        this.log.error((Object)("Consistency error: SSH login attempt with a password for user \"" + account.getLoginName() + "\", but the local account has neither a clear-text nor a hashed password"));
        return false;
    }
}

