/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputWithAnotherInputAndOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputWithAnotherInputAndOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputWithAnotherPossibleInputAndOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.ForwardingEndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputCoupledWithAnotherInputAndOutputSelectionPane
extends ForwardingEndpointSelectionPane {
    private final String dynEndpointId;
    private final String addDynInputId;
    private final String inputNameSuffix;
    private final Refreshable outputPane;
    private Map<String, String> metaDataInput = new HashMap<String, String>();
    private Map<String, String> metaDataInputWithSuffix = new HashMap<String, String>();
    private Map<String, String> metaDataOutput = new HashMap<String, String>();

    public InputCoupledWithAnotherInputAndOutputSelectionPane(String title, String endpointId, String addDynInputId, String inputNameSuffix, WorkflowNodeCommand.Executor executor, Refreshable outputPane) {
        super(title, EndpointType.INPUT, endpointId, new String[]{endpointId, addDynInputId}, executor);
        this.dynEndpointId = endpointId;
        this.addDynInputId = addDynInputId;
        this.inputNameSuffix = inputNameSuffix;
        this.outputPane = outputPane;
    }

    @Override
    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        this.metaDataInput.putAll(metaData);
        this.metaDataInputWithSuffix.putAll(metaData);
        AddDynamicInputWithAnotherInputAndOutputCommand command = new AddDynamicInputWithAnotherInputAndOutputCommand(this.dynEndpointId, this.addDynInputId, this.inputNameSuffix, name, type, this.metaDataInput, "startValues", this, this.outputPane);
        command.addMetaDataToInputWithSuffix(this.metaDataInputWithSuffix);
        command.setMetaDataOutput(this.metaDataOutput);
        this.execute(command);
    }

    @Override
    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        WorkflowNodeCommand command;
        if (oldDescription.getDynamicEndpointIdentifier().equals(this.dynEndpointIdToManage)) {
            command = new EditDynamicInputWithAnotherInputAndOutputCommand(oldDescription, newDescription, this.inputNameSuffix, "startValues", false, this, this.outputPane);
            ((EditDynamicInputWithAnotherInputAndOutputCommand)command).addMetaDataToInputWithSuffix(this.metaDataInputWithSuffix);
            ((EditDynamicInputWithAnotherInputAndOutputCommand)command).setMetaDataOutput(this.metaDataOutput);
        } else {
            command = new EditDynamicInputCommand(oldDescription.getDynamicEndpointIdentifier(), oldDescription.getName(), newDescription.getName(), newDescription.getDataType(), (Map<String, String>)newDescription.getMetaData(), this);
        }
        this.execute(command);
    }

    @Override
    protected void executeRemoveCommand(List<String> names) {
        RemoveDynamicInputWithAnotherPossibleInputAndOutputCommand command = new RemoveDynamicInputWithAnotherPossibleInputAndOutputCommand(this.dynEndpointId, names, this.inputNameSuffix, this, this.outputPane);
        this.execute(command);
    }

    @Override
    public void setMetaDataInput(Map<String, String> metaDataInput) {
        this.metaDataInput = metaDataInput;
    }

    public void setMetaDataInputWithSuffix(Map<String, String> metaDataInputWithSuffix) {
        this.metaDataInputWithSuffix = metaDataInputWithSuffix;
    }

    public void setMetaDataOutput(Map<String, String> metaDataOutput) {
        this.metaDataOutput = metaDataOutput;
    }
}

