/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.api.DefaultAuthorizationObjects;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.impl.ComponentAuthorizationSelectorImpl;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.formatter.Alignments;
import de.rcenvironment.core.utils.incubator.formatter.ArrayBasedDataTable;
import de.rcenvironment.core.utils.incubator.formatter.DataTable;
import de.rcenvironment.core.utils.incubator.formatter.Formatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ComponentsCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "components";
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private LocalComponentRegistrationService componentRegistrationService;
    private AuthorizationService authorizationService;
    private DefaultAuthorizationObjects defaultAuthorizationObjects;
    private UserComponentIdMappingService userComponentIdMappingService;

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(ROOT_COMMAND, "", false, "short form of \"components list\"", new String[0]));
        contributions.add(new CommandDescription("components list", "[--local] [--as-table]", false, "show available components; by default, components on the local node as well as those published by a reachable remote node are listed. Options:", new String[]{"--local  - only list components provided by the local node", "--as-table - format the output as a table that is especially suited for automated parsing"}));
        contributions.add(new CommandDescription("components list-auth", "", false, "Shows a list of all defined authorization settings. Note that these settings are independent of whether a matching component exists, which means that settings are kept when a component is removed and later added again.", new String[0]));
        contributions.add(new CommandDescription("components set-auth", "<component id> <groups>", false, "assigns a list of authorization groups to a component id; note that authorization settings always apply to all components with using this id, regardless of the component's version", new String[]{"<component id> - A component's id as listed by the \"components list\" command, e.g. \"rce/Parametric Study\", \"common/MyIntegratedTool\", or \"cpacs/MyCpacsTool\". This id must be enclosed in double quotes if it contains spaces.", "<groups> - A comma-separated list of user-defined authorization groups to assign. This replaces any previously assigned groups. Note that the specified groups must have been created or imported beforehand; see the \"auth create\" and \"auth import\" commands for details. Instead of a list of groups, the special value \"public\" can be used to grant access to any user within the visible network, while \"local\" revokes any previously granted access by remote users."}));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(ROOT_COMMAND);
        String firstParameter = context.peekNextToken();
        if (firstParameter == null || firstParameter.startsWith("-")) {
            this.performComponentsList(context);
            return;
        }
        String subCmd = context.consumeNextToken();
        if (subCmd.equals("list")) {
            this.performComponentsList(context);
        } else if (subCmd.equals("set-auth")) {
            this.performSetAuth(context);
        } else if (subCmd.equals("list-auth")) {
            this.performListAuth(context);
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentKnowledgeService = newInstance;
    }

    @Reference
    protected void bindComponentRegistrationService(LocalComponentRegistrationService newInstance) {
        this.componentRegistrationService = newInstance;
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
        this.defaultAuthorizationObjects = newInstance.getDefaultAuthorizationObjects();
    }

    @Reference
    protected void bindUserComponentIdMappingService(UserComponentIdMappingService newInstance) {
        this.userComponentIdMappingService = newInstance;
    }

    private void performComponentsList(CommandContext context) throws CommandException {
        TreeMap components = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        List options = context.consumeRemainingTokens();
        boolean localOnly = options.contains("--local");
        boolean remoteOnly = options.contains("--remote");
        if (localOnly && remoteOnly) {
            throw CommandException.syntaxError((String)"Only one of --local and --remote can be selected", (CommandContext)context);
        }
        boolean includeAuthInformation = true;
        boolean asTable = options.contains("--as-table");
        Collection<DistributedComponentEntry> installationSet = localOnly ? compKnowledge.getAllLocalInstallations() : (remoteOnly ? compKnowledge.getAllInstallations() : compKnowledge.getAllInstallations());
        for (DistributedComponentEntry entry : installationSet) {
            ComponentInstallation ci = entry.getComponentInstallation();
            if (components.get(ci.getNodeId()) == null) {
                components.put(ci.getNodeId(), new TreeMap(String.CASE_INSENSITIVE_ORDER));
            }
            ComponentInterface compInterface = ci.getComponentInterface();
            String component = String.valueOf(compInterface.getDisplayName()) + compInterface.getVersion();
            ((TreeMap)components.get(ci.getNodeId())).put(component, entry);
        }
        for (String nodeId : components.keySet()) {
            LogicalNodeId nodeIdObject = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId);
            if (!asTable) {
                context.println((Object)StringUtils.format((String)"Components available on %s:", (Object[])new Object[]{nodeIdObject}));
            }
            for (DistributedComponentEntry entry : ((TreeMap)components.get(nodeId)).values()) {
                String externalComponentId;
                String authData;
                String authPatternPart;
                String nodePrefixPattern;
                String basePattern;
                String versionPart;
                ComponentInterface compInterface;
                block16: {
                    block15: {
                        ComponentInstallation ci = entry.getComponentInstallation();
                        compInterface = ci.getComponentInterface();
                        versionPart = compInterface.getVersion();
                        basePattern = !asTable ? "  %2$s" : "%2$s|%1$s|%3$s";
                        if ("".equals(versionPart)) {
                            versionPart = "--";
                        }
                        nodePrefixPattern = asTable ? "%5$s|%6$s|" : "";
                        if (!includeAuthInformation) break block15;
                        authPatternPart = !asTable ? " <%4$s>" : "|%4$s";
                        switch (entry.getType()) {
                            case LOCAL: {
                                authData = "local";
                                break block16;
                            }
                            case FORCED_LOCAL: {
                                authData = "local-only";
                                break block16;
                            }
                            case SHARED: {
                                authData = "shared:" + entry.getDeclaredPermissionSet().getSignature();
                                break block16;
                            }
                            case REMOTE: {
                                authData = "remote:" + entry.getDeclaredPermissionSet().getSignature();
                                break block16;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    authPatternPart = "";
                    authData = "";
                }
                try {
                    externalComponentId = this.userComponentIdMappingService.fromInternalToExternalId(compInterface.getIdentifier());
                }
                catch (OperationFailureException operationFailureException) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Failed to determine/generate external id for component " + compInterface.getIdentifier() + "; falling back to display name"));
                    externalComponentId = compInterface.getDisplayName();
                }
                context.println((Object)StringUtils.format((String)(String.valueOf(nodePrefixPattern) + basePattern + authPatternPart), (Object[])new Object[]{compInterface.getIdentifier(), externalComponentId, versionPart, authData, nodeIdObject.getAssociatedDisplayName(), nodeIdObject.getLogicalNodeIdString()}));
            }
        }
    }

    private void performSetAuth(CommandContext context) throws CommandException {
        String componentId = context.consumeNextToken();
        String authSetting = context.consumeNextToken();
        if (authSetting == null || context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        if (componentId.isEmpty() || !componentId.contains("/")) {
            throw CommandException.syntaxError((String)"Invalid component id", (CommandContext)context);
        }
        AuthorizationPermissionSet permissionSet = this.parsePermissionSetString(authSetting, context);
        ComponentAuthorizationSelectorImpl selector = new ComponentAuthorizationSelectorImpl(componentId);
        this.componentRegistrationService.setComponentPermissions(selector, permissionSet);
        context.println((Object)StringUtils.format((String)"Set access authorization for component id \"%s\" to \"%s\"", (Object[])new Object[]{componentId, this.componentRegistrationService.getComponentPermissionSet(selector, true).getSignature()}));
    }

    private AuthorizationPermissionSet parsePermissionSetString(String authSetting, CommandContext context) throws CommandException {
        AuthorizationPermissionSet permissionSet;
        if ("local".equals(authSetting)) {
            permissionSet = this.defaultAuthorizationObjects.permissionSetLocalOnly();
        } else if ("public".equals(authSetting)) {
            permissionSet = this.defaultAuthorizationObjects.permissionSetPublicInLocalNetwork();
        } else {
            String[] groupIds = authSetting.split(",");
            ArrayList<AuthorizationAccessGroup> groupObjects = new ArrayList<AuthorizationAccessGroup>();
            String[] stringArray = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                String rawGroupId = stringArray[n2];
                String groupId = rawGroupId.trim();
                try {
                    AuthorizationAccessGroup group = this.authorizationService.findLocalGroupById(groupId);
                    if (group == null) {
                        throw CommandException.executionError((String)("There is no local group matching the id " + groupId), (CommandContext)context);
                    }
                    groupObjects.add(group);
                }
                catch (OperationFailureException e) {
                    throw CommandException.executionError((String)("Error assigning local group " + groupId + ": " + e.getMessage()), (CommandContext)context);
                }
                ++n2;
            }
            permissionSet = this.authorizationService.buildPermissionSet(groupObjects);
        }
        return permissionSet;
    }

    private void performListAuth(CommandContext context) {
        List externalSelectors = this.componentRegistrationService.listAuthorizationSelectorsForRemotableComponentsIncludingOrphans().stream().filter(selector -> !this.componentRegistrationService.getComponentPermissionSet((ComponentAuthorizationSelector)selector, true).isLocalOnly()).collect(Collectors.toList());
        if (externalSelectors.isEmpty()) {
            context.println((Object)"There are no external access permission(s)");
            return;
        }
        context.println((Object)StringUtils.format((String)"Found %d external access permission(s)", (Object[])new Object[]{externalSelectors.size()}));
        ArrayBasedDataTable outputTable = new ArrayBasedDataTable();
        outputTable.setAlignment(new Alignments[]{Alignments.LEFT, Alignments.LEFT, Alignments.LEFT});
        List<NamedComponentAuthorizationSelector> authorizationSelectorsWithoutOrphans = this.componentRegistrationService.listAuthorizationSelectorsForRemotableComponents();
        boolean allSelectorsAvailable = externalSelectors.stream().allMatch(authorizationSelectorsWithoutOrphans::contains);
        for (NamedComponentAuthorizationSelector selector2 : externalSelectors) {
            String externalId = selector2.getId();
            ArrayList<String> tableRow = new ArrayList<String>(Arrays.asList(externalId, this.componentRegistrationService.getComponentPermissionSet(selector2, true).getSignature()));
            if (!allSelectorsAvailable) {
                boolean selectorIsAvailable = authorizationSelectorsWithoutOrphans.contains(selector2);
                if (selectorIsAvailable) {
                    tableRow.add("");
                } else {
                    tableRow.add("not available");
                }
            }
            outputTable.addRow(tableRow.toArray(new String[0]));
        }
        StringBuilder[] stringBuilderArray = new Formatter().renderTable((DataTable)outputTable);
        int n = stringBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuilder sb = stringBuilderArray[n2];
            context.println((Object)sb.toString());
            ++n2;
        }
    }
}

