/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.WorkflowGraphEdge;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.component.execution.api.WorkflowGraphNode;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.GraphvizUtils;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class WorkflowGraph
implements Serializable {
    private static final String DUMMY = "dummy";
    private static final long serialVersionUID = -2028814913500870207L;
    private final Map<ComponentExecutionIdentifier, WorkflowGraphNode> nodes;
    private final Map<String, Set<WorkflowGraphEdge>> edges = new HashMap<String, Set<WorkflowGraphEdge>>();
    private final Map<ComponentExecutionIdentifier, Map<String, Set<Deque<WorkflowGraphHop>>>> determinedHopsToDriverOnFailure = new HashMap<ComponentExecutionIdentifier, Map<String, Set<Deque<WorkflowGraphHop>>>>();
    private final Map<ComponentExecutionIdentifier, WorkflowGraphNode> determinedDriverNodes = new HashMap<ComponentExecutionIdentifier, WorkflowGraphNode>();

    public WorkflowGraph(Map<ComponentExecutionIdentifier, WorkflowGraphNode> nodes, Set<WorkflowGraphEdge> edgeSet) {
        this.nodes = nodes;
        for (WorkflowGraphEdge edge : edgeSet) {
            String edgeKey = WorkflowGraph.createEdgeKey(edge);
            if (!this.edges.containsKey(edgeKey)) {
                this.edges.put(edgeKey, new HashSet());
            }
            this.edges.get(edgeKey).add(edge);
        }
    }

    public synchronized Set<Deque<WorkflowGraphHop>> getHopsToTraverseWhenResetting(ComponentExecutionIdentifier startNodeExecutionId) {
        HashSet<WorkflowGraphNode> alreadyVisitedNodes = new HashSet<WorkflowGraphNode>();
        ArrayList<List<WorkflowGraphEdge>> recursionResult = new ArrayList<List<WorkflowGraphEdge>>();
        this.recursion(alreadyVisitedNodes, this.nodes.get(startNodeExecutionId), EndpointCharacter.SAME_LOOP, new ArrayList<WorkflowGraphEdge>(), recursionResult);
        HashSet<Deque<WorkflowGraphHop>> hopsDequesSnapshot = new HashSet<Deque<WorkflowGraphHop>>();
        for (List list : recursionResult) {
            ComponentExecutionIdentifier lastExeId;
            ArrayDeque<WorkflowGraphHop> deque = new ArrayDeque<WorkflowGraphHop>();
            for (WorkflowGraphEdge edge : list) {
                WorkflowGraphNode currentNode = this.nodes.get(edge.getSourceExecutionIdentifier());
                WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
                WorkflowGraphHop nextHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), currentNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
                deque.addLast(nextHop);
            }
            ComponentExecutionIdentifier firstExeId = ((WorkflowGraphEdge)list.get(0)).getSourceExecutionIdentifier();
            if (firstExeId.equals(lastExeId = ((WorkflowGraphEdge)list.get(list.size() - 1)).getTargetExecutionIdentifier())) {
                hopsDequesSnapshot.add(deque);
                continue;
            }
            String dummyHopOuputName = DUMMY + UUID.randomUUID().toString();
            ComponentExecutionIdentifier dummyTargetExecutionIdentifier = new ComponentExecutionIdentifier(DUMMY + UUID.randomUUID().toString());
            String dummyTargetInputName = DUMMY + UUID.randomUUID().toString();
            WorkflowGraphHop nextHop = new WorkflowGraphHop(lastExeId, dummyHopOuputName, dummyTargetExecutionIdentifier, dummyTargetInputName);
            deque.addLast(nextHop);
            hopsDequesSnapshot.add(deque);
        }
        return hopsDequesSnapshot;
    }

    private void recursion(Set<WorkflowGraphNode> alreadyVisitedNodes, WorkflowGraphNode node, EndpointCharacter startEndpointCharacter, List<WorkflowGraphEdge> currentChain, List<List<WorkflowGraphEdge>> completedChains) {
        List<WorkflowGraphEdge> nextEdgesToVisit = this.nextEdgesToVisit(alreadyVisitedNodes, node, startEndpointCharacter);
        if (nextEdgesToVisit.isEmpty()) {
            if (!currentChain.isEmpty()) {
                completedChains.add(currentChain);
            }
            return;
        }
        for (WorkflowGraphEdge nextEdge : nextEdgesToVisit) {
            WorkflowGraphNode nextNode = this.nodes.get(nextEdge.getTargetExecutionIdentifier());
            ArrayList<WorkflowGraphEdge> currentChainCopy = new ArrayList<WorkflowGraphEdge>(currentChain);
            currentChainCopy.add(nextEdge);
            this.recursion(alreadyVisitedNodes, nextNode, nextEdge.getInputCharacter(), currentChainCopy, completedChains);
        }
    }

    private List<WorkflowGraphEdge> nextEdgesToVisit(Set<WorkflowGraphNode> alreadyVisitedNodes, WorkflowGraphNode startNode, EndpointCharacter startEndpointCharacter) {
        ArrayList<WorkflowGraphEdge> nextEdgesToVisit = new ArrayList<WorkflowGraphEdge>();
        for (String startNodeOutputId : startNode.getOutputIdentifiers()) {
            String tmpEdgeKey = WorkflowGraph.createEdgeKey(startNode, startNodeOutputId);
            if (!this.edges.containsKey(tmpEdgeKey)) continue;
            for (WorkflowGraphEdge edge : this.edges.get(tmpEdgeKey)) {
                WorkflowGraphNode targetNode = this.nodes.get(edge.getTargetExecutionIdentifier());
                if (alreadyVisitedNodes.contains(targetNode)) continue;
                if (startNode.isDriver()) {
                    if (!startEndpointCharacter.equals((Object)edge.getOutputCharacter())) continue;
                    nextEdgesToVisit.add(edge);
                    alreadyVisitedNodes.add(targetNode);
                    continue;
                }
                nextEdgesToVisit.add(edge);
                alreadyVisitedNodes.add(targetNode);
            }
        }
        return nextEdgesToVisit;
    }

    public Map<String, Set<Deque<WorkflowGraphHop>>> getHopsToTraverseOnFailure(ComponentExecutionIdentifier startNodeEecutionId) throws ComponentExecutionException {
        Map<String, Set<Deque<WorkflowGraphHop>>> hopsDequesPerOutput = this.nodes.get(startNodeEecutionId).isDriver() ? this.getHopsToTraverseToGetToLoopDriver(startNodeEecutionId, EndpointCharacter.OUTER_LOOP, this.determinedHopsToDriverOnFailure, false) : this.getHopsToTraverseToGetToLoopDriver(startNodeEecutionId, EndpointCharacter.SAME_LOOP, this.determinedHopsToDriverOnFailure, false);
        HashSet<String> visitedInputs = new HashSet<String>();
        Iterator<Map.Entry<String, Set<Deque<WorkflowGraphHop>>>> hopsDequesPerOutputIterator = hopsDequesPerOutput.entrySet().iterator();
        while (hopsDequesPerOutputIterator.hasNext()) {
            Map.Entry<String, Set<Deque<WorkflowGraphHop>>> hopsDequesForOutput = hopsDequesPerOutputIterator.next();
            Iterator<Deque<WorkflowGraphHop>> hopsForOutputIterator = hopsDequesForOutput.getValue().iterator();
            while (hopsForOutputIterator.hasNext()) {
                Deque<WorkflowGraphHop> hops = hopsForOutputIterator.next();
                String targetInputName = hops.getLast().getTargetInputName();
                if (visitedInputs.contains(targetInputName)) {
                    hopsForOutputIterator.remove();
                    continue;
                }
                visitedInputs.add(targetInputName);
            }
            if (!hopsDequesForOutput.getValue().isEmpty()) continue;
            hopsDequesPerOutputIterator.remove();
        }
        return hopsDequesPerOutput;
    }

    public WorkflowGraphNode getLoopDriver(ComponentExecutionIdentifier executionIdentifier) throws ComponentExecutionException {
        if (!this.determinedDriverNodes.containsKey(executionIdentifier)) {
            this.getHopsToTraverseOnFailure(executionIdentifier);
        }
        return this.determinedDriverNodes.get(executionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<Deque<WorkflowGraphHop>>> getHopsToTraverseToGetToLoopDriver(ComponentExecutionIdentifier startNodeExecutionId, EndpointCharacter startEnpointCharacter, Map<ComponentExecutionIdentifier, Map<String, Set<Deque<WorkflowGraphHop>>>> alreadyDeterminedHops, boolean isResetSearch) throws ComponentExecutionException {
        Map<ComponentExecutionIdentifier, Map<String, Set<Deque<WorkflowGraphHop>>>> map = alreadyDeterminedHops;
        synchronized (map) {
            if (!alreadyDeterminedHops.containsKey(startNodeExecutionId)) {
                HashMap hopsDequesPerOutput = new HashMap();
                WorkflowGraphNode startNode = this.nodes.get(startNodeExecutionId);
                for (String startNodeOutputId : startNode.getOutputIdentifiers()) {
                    Set<Object> hopsDeques = new HashSet();
                    if (this.edges.containsKey(WorkflowGraph.createEdgeKey(startNode, startNodeOutputId))) {
                        for (WorkflowGraphEdge startEdge : this.edges.get(WorkflowGraph.createEdgeKey(startNode, startNodeOutputId))) {
                            if (startNode.isDriver()) {
                                if (!startEnpointCharacter.equals((Object)startEdge.getOutputCharacter())) continue;
                                hopsDeques = this.startNewHopsSearch(startNode, startEdge, isResetSearch);
                                continue;
                            }
                            hopsDeques = this.startNewHopsSearch(startNode, startEdge, isResetSearch);
                        }
                        hopsDequesPerOutput.put(startNode.getEndpointName(startNodeOutputId), hopsDeques);
                        continue;
                    }
                    hopsDequesPerOutput.put(startNode.getEndpointName(startNodeOutputId), hopsDeques);
                }
                alreadyDeterminedHops.put(startNodeExecutionId, hopsDequesPerOutput);
            }
        }
        return this.createSnapshotOfHopsDeques(alreadyDeterminedHops.get(startNodeExecutionId));
    }

    private Map<String, Set<Deque<WorkflowGraphHop>>> createSnapshotOfHopsDeques(Map<String, Set<Deque<WorkflowGraphHop>>> hopDeques) {
        HashMap<String, Set<Deque<WorkflowGraphHop>>> hopsDequesSnapshot = new HashMap<String, Set<Deque<WorkflowGraphHop>>>();
        for (String outputName : hopDeques.keySet()) {
            hopsDequesSnapshot.put(outputName, new HashSet());
            for (Deque<WorkflowGraphHop> hops : hopDeques.get(outputName)) {
                ((Set)hopsDequesSnapshot.get(outputName)).add(new ArrayDeque<WorkflowGraphHop>(hops));
            }
        }
        return hopsDequesSnapshot;
    }

    private Set<Deque<WorkflowGraphHop>> startNewHopsSearch(WorkflowGraphNode startNode, WorkflowGraphEdge edge, boolean isResetSearch) throws ComponentExecutionException {
        HashSet<Deque<WorkflowGraphHop>> hopsDeques = new HashSet<Deque<WorkflowGraphHop>>();
        WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
        ArrayDeque<WorkflowGraphHop> hopsDeque = new ArrayDeque<WorkflowGraphHop>();
        WorkflowGraphHop firstHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), startNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
        hopsDeque.add(firstHop);
        this.determineHopsRecursively(startNode, edge, nextNode, hopsDeque, hopsDeques, isResetSearch);
        return hopsDeques;
    }

    private void determineHopsRecursively(WorkflowGraphNode startNode, WorkflowGraphEdge edge, WorkflowGraphNode targetNode, Deque<WorkflowGraphHop> hopsDeque, Set<Deque<WorkflowGraphHop>> hopsDeques, boolean isResetSearch) throws ComponentExecutionException {
        if (targetNode.getExecutionIdentifier().equals(startNode.getExecutionIdentifier())) {
            if (targetNode.isDriver() && isResetSearch) {
                hopsDeques.add(hopsDeque);
            }
            return;
        }
        if (this.nodeAlreadyVisitedThatWay(hopsDeque, targetNode, edge)) {
            return;
        }
        if (targetNode.isDriver()) {
            if (EndpointCharacter.OUTER_LOOP.equals((Object)edge.getInputCharacter())) {
                this.continueHopSearch(startNode, targetNode, hopsDeque, hopsDeques, isResetSearch, EndpointCharacter.OUTER_LOOP);
            } else if (EndpointCharacter.SAME_LOOP.equals((Object)edge.getInputCharacter())) {
                hopsDeques.add(hopsDeque);
                this.addNodeToDeterminedDriverNodes(startNode, targetNode);
            }
        } else {
            EndpointCharacter outputCharacterToConsider = EndpointCharacter.SAME_LOOP;
            if (this.hasNodeOppositeOutputCharacters(targetNode)) {
                switch (edge.getInputCharacter()) {
                    case SAME_LOOP: {
                        outputCharacterToConsider = EndpointCharacter.OUTER_LOOP;
                        break;
                    }
                    case OUTER_LOOP: {
                        outputCharacterToConsider = EndpointCharacter.SAME_LOOP;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown endpoint character: " + edge.getInputCharacter());
                    }
                }
            }
            this.continueHopSearch(startNode, targetNode, hopsDeque, hopsDeques, isResetSearch, outputCharacterToConsider);
        }
    }

    private boolean nodeAlreadyVisitedThatWay(Deque<WorkflowGraphHop> hopsDeque, WorkflowGraphNode nodeToVisit, WorkflowGraphEdge usedEdge) {
        for (WorkflowGraphHop hop : hopsDeque) {
            EndpointCharacter usedEdgesInputCharacter;
            if (!hop.getHopExecutionIdentifier().equals(nodeToVisit.getExecutionIdentifier())) continue;
            if (!this.hasNodeOppositeOutputCharacters(nodeToVisit)) {
                return true;
            }
            EndpointCharacter hopEdgesOutputCharacter = this.edges.get(WorkflowGraph.createEdgeKey(this.nodes.get(hop.getHopExecutionIdentifier()), hop.getHopOutputIdentifier())).iterator().next().getOutputCharacter();
            if (hopEdgesOutputCharacter.equals((Object)(usedEdgesInputCharacter = usedEdge.getInputCharacter()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasNodeOppositeOutputCharacters(WorkflowGraphNode node) {
        boolean sameLoop = false;
        boolean outerLoop = false;
        for (String nodeOutputId : node.getOutputIdentifiers()) {
            if (!this.edges.containsKey(WorkflowGraph.createEdgeKey(node, nodeOutputId))) continue;
            for (WorkflowGraphEdge edge : this.edges.get(WorkflowGraph.createEdgeKey(node, nodeOutputId))) {
                if (edge.getOutputCharacter().equals((Object)EndpointCharacter.SAME_LOOP)) {
                    sameLoop = true;
                    continue;
                }
                if (!edge.getOutputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) continue;
                outerLoop = true;
            }
        }
        return sameLoop && outerLoop;
    }

    private void continueHopSearch(WorkflowGraphNode startNode, WorkflowGraphNode targetNode, Deque<WorkflowGraphHop> hopsDeque, Set<Deque<WorkflowGraphHop>> hopsDeques, boolean isResetSearch, EndpointCharacter ... outputCharacters) throws ComponentExecutionException {
        for (String targetNodeOutputId : targetNode.getOutputIdentifiers()) {
            if (!this.edges.containsKey(WorkflowGraph.createEdgeKey(targetNode, targetNodeOutputId))) continue;
            for (WorkflowGraphEdge nextEdge : this.edges.get(WorkflowGraph.createEdgeKey(targetNode, targetNodeOutputId))) {
                if (!Arrays.asList(outputCharacters).contains(nextEdge.getOutputCharacter())) continue;
                this.continueHopsSearch(startNode, targetNode, nextEdge, hopsDeque, hopsDeques, isResetSearch);
            }
        }
    }

    private void continueHopsSearch(WorkflowGraphNode startNode, WorkflowGraphNode currentNode, WorkflowGraphEdge edge, Deque<WorkflowGraphHop> hopsDeque, Set<Deque<WorkflowGraphHop>> hopsDeques, boolean isResetSearch) throws ComponentExecutionException {
        ArrayDeque<WorkflowGraphHop> newHopDeque = new ArrayDeque<WorkflowGraphHop>(hopsDeque);
        WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
        WorkflowGraphHop nextHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), currentNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
        newHopDeque.add(nextHop);
        this.determineHopsRecursively(startNode, edge, nextNode, newHopDeque, hopsDeques, isResetSearch);
    }

    private void addNodeToDeterminedDriverNodes(WorkflowGraphNode startNode, WorkflowGraphNode driverNode) throws ComponentExecutionException {
        if (driverNode != null) {
            if (this.determinedDriverNodes.get(startNode.getExecutionIdentifier()) == null) {
                this.determinedDriverNodes.put(startNode.getExecutionIdentifier(), driverNode);
            } else if (!this.determinedDriverNodes.get(startNode.getExecutionIdentifier()).getExecutionIdentifier().equals(driverNode.getExecutionIdentifier())) {
                throw new ComponentExecutionException("Error in workflow graph search: newly determined driver node differs from driver node determined earlier");
            }
        }
    }

    public String toDotScript() {
        GraphvizUtils.DotFileBuilder builder = GraphvizUtils.createDotFileBuilder((String)"wf_graph");
        for (WorkflowGraphNode workflowGraphNode : this.nodes.values()) {
            builder.addVertex(workflowGraphNode.getExecutionIdentifier().toString(), workflowGraphNode.getName());
            if (workflowGraphNode.isDriver()) {
                builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "color", "#AA3939");
            } else if (this.hasNodeOppositeOutputCharacters(workflowGraphNode)) {
                builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "color", "#D4AA6A");
            }
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "shape", "rectangle");
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "fontsize", "10");
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "fontname", "Consolas");
        }
        for (Set set : this.edges.values()) {
            for (WorkflowGraphEdge edge : set) {
                HashMap<String, String> edgeProps = new HashMap<String, String>();
                edgeProps.put("fontsize", "10");
                edgeProps.put("fontname", "Consolas");
                if (edge.getInputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) {
                    edgeProps.put("color", "#55AA55");
                } else if (edge.getOutputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) {
                    edgeProps.put("color", "#4B698B");
                }
                String label = StringUtils.format((String)"%s > %s", (Object[])new Object[]{this.nodes.get(edge.getSourceExecutionIdentifier()).getEndpointName(edge.getOutputIdentifier()), this.nodes.get(edge.getTargetExecutionIdentifier()).getEndpointName(edge.getInputIdentifier())});
                builder.addEdge(edge.getSourceExecutionIdentifier().toString(), edge.getTargetExecutionIdentifier().toString(), label, edgeProps);
            }
        }
        return builder.getScriptContent();
    }

    private static String createEdgeKey(WorkflowGraphEdge edge) {
        return StringUtils.escapeAndConcat((String[])new String[]{edge.getSourceExecutionIdentifier().toString(), edge.getOutputIdentifier()});
    }

    private static String createEdgeKey(WorkflowGraphNode node, String outputIdentifier) {
        return StringUtils.escapeAndConcat((String[])new String[]{node.getExecutionIdentifier().toString(), outputIdentifier});
    }
}

