/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.executor.AbstractCommandLineExecutor;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.ProcessExtractor;
import de.rcenvironment.core.utils.executor.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalApacheCommandLineExecutor
extends AbstractCommandLineExecutor
implements CommandLineExecutor {
    private static final String LINUX_MAKE_FILE_EXECUTABLE_TEMPLATE = "chmod +x %s";
    private File workDir;
    private final Log log = LogFactory.getLog(this.getClass());
    private DefaultExecutor executor;
    private ExecuteWatchdog watchdog;
    private PipedInputStream pipedStdInputStream;
    private PipedInputStream pipedErrInputStream;
    private DefaultExecuteResultHandler resultHandler;
    private PipedOutputStream pipedStdOutputStream;
    private PipedOutputStream pipedErrOutputStream;
    private ExtendedPumpStreamHandler streamHandler;
    private ProcessExtractor processExtractor;
    private boolean cancelRequested = false;

    public LocalApacheCommandLineExecutor(File workDirPath) throws IOException {
        this.workDir = workDirPath;
    }

    @Override
    public void start(String commandString) throws IOException {
        this.start(commandString, null);
    }

    private void checkAndCreateWorkDir() throws IOException {
        if (!this.workDir.isDirectory()) {
            this.workDir.mkdirs();
            if (!this.workDir.isDirectory()) {
                throw new IOException("Failed to create provided work directory " + this.workDir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(CommandLine cmd, InputStream stdinStream) throws IOException {
        this.pipedStdOutputStream = new PipedOutputStream();
        this.pipedErrOutputStream = new PipedOutputStream();
        this.pipedStdInputStream = new PipedInputStream(this.pipedStdOutputStream);
        this.pipedErrInputStream = new PipedInputStream(this.pipedErrOutputStream);
        this.watchdog = new ExecuteWatchdog(-1L);
        this.executor = new DefaultExecutor();
        this.executor.setWatchdog(this.watchdog);
        this.resultHandler = new DefaultExecuteResultHandler();
        this.streamHandler = new ExtendedPumpStreamHandler(this.pipedStdOutputStream, this.pipedErrOutputStream, stdinStream);
        this.executor.setStreamHandler((ExecuteStreamHandler)this.streamHandler);
        this.executor.setWorkingDirectory(this.workDir);
        this.processExtractor = new ProcessExtractor();
        this.executor.setWatchdog((ExecuteWatchdog)this.processExtractor);
        LocalApacheCommandLineExecutor localApacheCommandLineExecutor = this;
        synchronized (localApacheCommandLineExecutor) {
            if (this.cancelRequested) {
                this.resultHandler.onProcessComplete(1);
            } else if (this.env.isEmpty()) {
                this.executor.execute(cmd, (ExecuteResultHandler)this.resultHandler);
            } else {
                this.executor.execute(cmd, this.env, (ExecuteResultHandler)this.resultHandler);
            }
        }
    }

    @Override
    public void start(String commandString, InputStream stdinStream) throws IOException {
        this.checkAndCreateWorkDir();
        CommandLine cmd = ProcessUtils.constructCommandLine(commandString);
        this.executeCommand(cmd, stdinStream);
    }

    private void executeShebangScript(String scriptString, InputStream stdinStream) throws IOException, InterruptedException {
        this.checkAndCreateWorkDir();
        File scriptFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename("script");
        this.log.debug((Object)StringUtils.format((String)"Writing script to %s", (Object[])new Object[]{scriptFile.getAbsolutePath()}));
        FileUtils.writeStringToFile((File)scriptFile, (String)scriptString, (boolean)false);
        this.log.debug((Object)scriptFile.exists());
        this.log.debug((Object)scriptFile.length());
        String makeExecutableCmd = StringUtils.format((String)LINUX_MAKE_FILE_EXECUTABLE_TEMPLATE, (Object[])new Object[]{scriptFile.getAbsolutePath()});
        LocalApacheCommandLineExecutor makeExecutableExecutor = new LocalApacheCommandLineExecutor(this.workDir);
        makeExecutableExecutor.start(makeExecutableCmd);
        int exitCode = makeExecutableExecutor.waitForTermination();
        this.log.debug((Object)StringUtils.format((String)"chmod +x finished with exit code %d", (Object[])new Object[]{exitCode}));
        this.log.debug((Object)("scriptFile.exists(): " + scriptFile.exists()));
        CommandLine cmd = new CommandLine(scriptFile.getAbsolutePath());
        this.executeCommand(cmd, stdinStream);
    }

    public void executeScript(String scriptString, InputStream stdinStream) throws IOException, InterruptedException {
        if (OS.isFamilyWindows()) {
            this.startMultiLineCommand(scriptString.split("\r?\n|\r"));
        } else if (OS.isFamilyUnix()) {
            if (scriptString.startsWith("#!/bin/sh\n") || scriptString.startsWith("#!/bin/bash\n")) {
                this.executeShebangScript(scriptString, stdinStream);
            } else {
                this.startMultiLineCommand(scriptString.split("\r?\n|\r"));
            }
        }
    }

    public void manuallyDestroyProcess() {
        this.watchdog.destroyProcess();
    }

    @Override
    public String getWorkDirPath() {
        return this.workDir.getAbsolutePath();
    }

    @Override
    public InputStream getStdout() {
        return this.pipedStdInputStream;
    }

    @Override
    public InputStream getStderr() {
        return this.pipedErrInputStream;
    }

    @Override
    public int waitForTermination() throws IOException, InterruptedException {
        this.resultHandler.waitFor();
        int exitValue = this.resultHandler.getExitValue();
        return exitValue;
    }

    public DefaultExecuteResultHandler getResultHandler() {
        return this.resultHandler;
    }

    @Override
    public void uploadFileToWorkdir(File localFile, String remoteLocation) throws IOException {
        File targetFile = new File(this.workDir, remoteLocation);
        this.log.debug((Object)("Local copy from " + localFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
        FileUtils.copyFile((File)localFile, (File)targetFile);
    }

    @Override
    public void downloadFileFromWorkdir(String remoteLocation, File localFile) throws IOException {
        FileUtils.copyFile((File)new File(this.workDir, remoteLocation), (File)localFile);
    }

    @Override
    public void downloadWorkdir(File localDir) throws IOException {
        FileUtils.copyDirectory((File)this.workDir, (File)localDir);
    }

    @Override
    public void remoteCopy(String remoteSource, String remoteTarget) throws IOException {
        FileUtils.copyFile((File)new File(remoteSource), (File)new File(remoteTarget));
    }

    @Override
    public void uploadDirectoryToWorkdir(File localDirectory, String remoteLocation) throws IOException {
        File targetDirectory = new File(this.workDir, remoteLocation);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory((File)localDirectory, (File)targetDirectory);
    }

    @Override
    public void downloadDirectoryFromWorkdir(String remoteLocation, File localDirectory) throws IOException {
        FileUtils.copyDirectory((File)new File(this.workDir, remoteLocation), (File)localDirectory);
    }

    @Override
    public void downloadFile(String remoteLocation, File localFile) throws IOException {
        FileUtils.copyFile((File)new File(remoteLocation), (File)localFile);
    }

    @Override
    public void downloadDirectory(String remoteLocation, File localDirectory) throws IOException {
        FileUtils.copyDirectory((File)new File(remoteLocation), (File)localDirectory);
    }

    @Override
    public void uploadFile(File localFile, String remoteLocation) throws IOException {
        FileUtils.copyFile((File)localFile, (File)new File(remoteLocation));
    }

    @Override
    public void uploadDirectory(File localDirectory, String remoteLocation) throws IOException {
        FileUtils.copyDirectory((File)localDirectory, (File)new File(remoteLocation));
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public synchronized boolean cancel() {
        this.cancelRequested = true;
        if (this.processExtractor == null) {
            return false;
        }
        Process process = this.processExtractor.getProcess();
        if (process == null) {
            return false;
        }
        try {
            int pid = ProcessUtils.getPid(process);
            ProcessUtils.killProcessTree(pid);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InterruptedException | NoSuchFieldException | SecurityException e) {
            this.log.error((Object)"Unable to cancel the process.", (Throwable)e);
            return false;
        }
        return true;
    }

    private class ExtendedPumpStreamHandler
    extends PumpStreamHandler {
        ExtendedPumpStreamHandler(PipedOutputStream pipedStdOutputStream, PipedOutputStream pipedErrOutputStream, InputStream stdinStream) {
            super((OutputStream)pipedStdOutputStream, (OutputStream)pipedErrOutputStream, stdinStream);
        }

        protected Thread createPump(InputStream is, OutputStream os) {
            return this.createPump(is, os, true);
        }
    }
}

