/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Given;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.core.utils.testing.TestParametersProvider;
import de.rcenvironment.extras.testscriptrunner.common.CommonTestConfiguration;
import de.rcenvironment.extras.testscriptrunner.common.CommonUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.CommonStateAndSteps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteAccessStandaloneClientDefinitions {
    private static StaticSettings staticSettings;
    private File testDir;
    private final Log log = LogFactory.getLog(this.getClass());
    private CommonStateAndSteps commonState;

    public RemoteAccessStandaloneClientDefinitions() throws IOException {
        this.testDir = new File(CommonUtils.getValidatedSystemTempDir(), "rce-standalone-testing");
        this.testDir.mkdirs();
        if (!this.testDir.isDirectory()) {
            throw new IOException("Failed to create test dir");
        }
        this.commonState = CommonStateAndSteps.getCurrent();
    }

    @Given(value="^a password file \"(.*?)\" containing \"(.*?)\"$")
    public void setUpPasswordFileWithContent(String filename, String content) throws Throwable {
        content = this.getStaticSettings().substitute(content);
        CommonUtils.validateStringMatches(filename, "[\\w\\.]+");
        File pwfile = new File(this.testDir, filename);
        FileUtils.writeStringToFile((File)pwfile, (String)content);
        this.log(String.format("Created password file '%s' containing '%s'", pwfile, content));
    }

    @Given(value="^no password file at \"(.*?)\"$")
    public void setUpNoPasswordFile(String filename) throws Throwable {
        CommonUtils.validateStringMatches(filename, "[\\w\\.]+");
        File pwfile = new File(this.testDir, filename);
        if (pwfile.delete()) {
            this.log(String.format("Deleted password file '%s'", pwfile));
        }
    }

    @When(value="^calling rce-remote with parameters$")
    public void invokeRceRemoteWithParameters(String parameters) throws Throwable {
        parameters = this.getStaticSettings().substitute(parameters);
        String command = String.valueOf(this.getStaticSettings().rceRemoteExeLocation.getAbsolutePath()) + " " + parameters;
        this.log("Executing command: " + command);
        IntegrationTestExecutorUtils.ExecutionResult executionResult = this.getStaticSettings().executor.executeAndWait(command);
        this.commonState.setParameterSubstitutionMap(this.getStaticSettings().substitutionMap);
        this.commonState.setCurrentExecutionResult(executionResult.applyLineFilter(new IntegrationTestExecutorUtils.LineFilter(){

            public boolean accept(String line) {
                return !line.startsWith("[DEBUG] ");
            }
        }));
        this.log("Finished rce-remote invocation");
    }

    private synchronized StaticSettings getStaticSettings() throws IOException {
        if (staticSettings == null) {
            staticSettings = new StaticSettings(CommonTestConfiguration.getParameters());
        }
        return staticSettings;
    }

    private void log(String string) {
        this.log.info((Object)string);
    }

    private final class StaticSettings {
        private final File rceRemoteExeLocation;
        private final Map<String, String> substitutionMap;
        private final IntegrationTestExecutorUtils executor;

        private StaticSettings(TestParametersProvider testParameters) throws IOException {
            RemoteAccessStandaloneClientDefinitions.this.log.info((Object)"Initializing static RemoteAccess-specific test settings");
            this.rceRemoteExeLocation = testParameters.getExistingFile("testexecutable.path");
            this.substitutionMap = new HashMap<String, String>();
            this.substitutionMap.put("workdir", RemoteAccessStandaloneClientDefinitions.this.testDir.getAbsolutePath());
            this.substitutionMap.put("/", File.separator);
            this.substitutionMap.put("CR", "\r");
            this.substitutionMap.put("LF", "\n");
            this.substitutionMap.put("list-tools-col-separator", " / ");
            this.substitutionMap.put("testserver.host", testParameters.getNonEmptyString("testserver.host"));
            this.substitutionMap.put("testserver.port", testParameters.getNonEmptyString("testserver.port"));
            this.substitutionMap.put("testserver.nodeId", testParameters.getNonEmptyString("testserver.nodeId"));
            this.substitutionMap.put("protocol.version.expected", testParameters.getNonEmptyString("protocol.version.expected"));
            this.substitutionMap.put("actual-pw", "the_pw");
            this.executor = new IntegrationTestExecutorUtils(this.rceRemoteExeLocation.getParentFile());
        }

        public String substitute(String input) {
            return CommonUtils.substitute(input, this.substitutionMap);
        }
    }
}

