/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.modules.concurrency.internal.ConcurrencyUtilsServiceHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchAggregatorImpl<T>
implements BatchAggregator<T> {
    private static Log log = LogFactory.getLog(BatchAggregatorImpl.class);
    private List<T> currentBatch;
    private final int maxBatchSize;
    private final long maxLatency;
    private final BatchProcessor<T> processor;
    private final AsyncOrderedExecutionQueue dispatchQueue;
    private final ConcurrencyUtilsServiceHolder internalServicesHolder;
    private final ConcurrencyUtilsFactory concurrencyUtilsFactory;

    public BatchAggregatorImpl(int maxBatchSize, long maxLatency, BatchProcessor<T> processor, ConcurrencyUtilsServiceHolder internalServicesHolder) {
        this.maxBatchSize = maxBatchSize;
        this.maxLatency = maxLatency;
        this.processor = processor;
        this.internalServicesHolder = internalServicesHolder;
        this.concurrencyUtilsFactory = internalServicesHolder.getConcurrencyUtilsFactory();
        this.dispatchQueue = this.concurrencyUtilsFactory.createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    }

    @Override
    public synchronized void enqueue(T element) {
        if (this.currentBatch == null) {
            this.startNewBatch();
        }
        this.currentBatch.add(element);
        int size = this.currentBatch.size();
        if (size >= this.maxBatchSize) {
            if (size > this.maxBatchSize) {
                throw new IllegalArgumentException("maxBatchSize exceeded?");
            }
            this.endCurrentBatchAndEnqueueForProcessing();
        }
    }

    protected static synchronized void setLogger(Log newLog) {
        log = newLog;
    }

    protected static synchronized Log getLogger() {
        return log;
    }

    private synchronized void onMaxLatencyTimerCallback(List<T> relevantBatch) {
        if (this.currentBatch != relevantBatch) {
            return;
        }
        this.endCurrentBatchAndEnqueueForProcessing();
    }

    private void startNewBatch() {
        this.currentBatch = new ArrayList<T>();
        this.internalServicesHolder.getAsyncTaskService().scheduleAfterDelay(new MaxLatencyTimerCallback(this.currentBatch), this.maxLatency);
    }

    private void endCurrentBatchAndEnqueueForProcessing() {
        this.dispatchQueue.enqueue(new DispatchRunnable(this.currentBatch, this.processor));
        this.currentBatch = null;
    }

    private final class DispatchRunnable<T>
    implements Runnable {
        private static final String ASYNC_TASK_DESCRIPTION = "BatchAggregator dispatch";
        private final List<T> detachedBatchReference;
        private final BatchProcessor<T> processor;

        private DispatchRunnable(List<T> detachedBatchReference, BatchProcessor<T> processor) {
            this.detachedBatchReference = detachedBatchReference;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TaskDescription(value="BatchAggregator dispatch")
        public void run() {
            try {
                this.processor.processBatch(this.detachedBatchReference);
            }
            catch (RuntimeException e) {
                Class<BatchAggregatorImpl> clazz = BatchAggregatorImpl.class;
                synchronized (BatchAggregatorImpl.class) {
                    log.error((Object)("Uncaught exception in batch processor " + this.processor), (Throwable)e);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    throw e;
                }
            }
            BatchAggregatorImpl.this.internalServicesHolder.getStatisticsTrackerService().getCounterCategory("AsyncOrderedExecutionQueue dispatch").count(ASYNC_TASK_DESCRIPTION);
        }
    }

    private final class MaxLatencyTimerCallback
    implements Runnable {
        private List<T> relevantBatch;

        MaxLatencyTimerCallback(List<T> relevantBatch) {
            this.relevantBatch = relevantBatch;
        }

        @Override
        @TaskDescription(value="BatchAggregator Max Latency Timer")
        public void run() {
            BatchAggregatorImpl.this.onMaxLatencyTimerCallback(this.relevantBatch);
        }
    }
}

