/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common;

import de.rcenvironment.components.excel.common.GarbageDestroyer;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DateTimeTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ExcelUtils {
    private ExcelUtils() {
    }

    public static File getAbsoluteFile(String pathOfFile) {
        File file = null;
        if (pathOfFile == null || pathOfFile.isEmpty()) {
            return file;
        }
        Path path = new Path(pathOfFile);
        if (path.isAbsolute()) {
            file = new File(pathOfFile);
            if (!file.exists()) {
                file = null;
            }
        } else {
            IFile fileEclipse = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (fileEclipse.exists()) {
                file = fileEclipse.getRawLocation().toFile();
            }
        }
        return file;
    }

    public static String smallTableToString(SmallTableTD table, String valueSeparator, String lineSeparator) {
        TypedDatum[][] array = table.toArray();
        if (array == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        int row = 0;
        while (row < array.length) {
            int col = 0;
            while (col < array[row].length) {
                String str;
                TypedDatum data = array[row][col];
                switch (data.getDataType()) {
                    case ShortText: {
                        str = ((ShortTextTD)data).getShortTextValue();
                        break;
                    }
                    case Float: {
                        str = String.valueOf(((FloatTD)data).getFloatValue());
                        break;
                    }
                    case Integer: {
                        str = String.valueOf(((IntegerTD)data).getIntValue());
                        break;
                    }
                    case Boolean: {
                        str = String.valueOf(((BooleanTD)data).getBooleanValue());
                        break;
                    }
                    case DateTime: {
                        str = ((DateTimeTD)data).getDateTime().toString();
                        break;
                    }
                    case Empty: {
                        str = new String();
                        break;
                    }
                    default: {
                        str = new String();
                    }
                }
                result.append(str);
                if (col != array[row].length - 1) {
                    result.append(valueSeparator);
                }
                ++col;
            }
            if (row + 1 < array.length) {
                result.append(lineSeparator);
            }
            ++row;
        }
        return result.toString();
    }

    public static int getRowIndexLastCellFilled(TypedDatum[][] dataStore) {
        int row = dataStore.length - 1;
        while (row >= 0) {
            int column = dataStore[0].length - 1;
            while (column >= 0) {
                if (dataStore[row][column] != null && dataStore[row][column].getDataType() != DataType.Empty) {
                    return row;
                }
                --column;
            }
            --row;
        }
        return 0;
    }

    public static int getColumnIndexLastCellFilled(TypedDatum[][] dataStore) {
        int row = dataStore.length - 1;
        while (row >= 0) {
            int column = dataStore[0].length - 1;
            while (column >= 0) {
                if (dataStore[row][column] != null && dataStore[row][column].getDataType() != DataType.Empty) {
                    return column;
                }
                --column;
            }
            --row;
        }
        return 0;
    }

    public static void destroyGarbage() {
        ConcurrencyUtils.getAsyncTaskService().execute((Runnable)new GarbageDestroyer());
    }
}

