/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.shutdown;

import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.start.common.Instance;
import de.rcenvironment.core.toolkitbridge.api.ToolkitBridge;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadlessShutdown {
    private static final int SHUTDOWN_TOKEN_LENGTH = 32;
    private static final String TOKEN_FILENAME = "shutdown.dat";
    private static final String HOST = "localhost";
    private static final int REGULAR_SHUTDOWN_WAIT_TIME_MSEC = 60000;
    private static final int BUFFERSIZE = 200;
    private BootstrapConfiguration bootstrapSettings;
    private final Log logger = LogFactory.getLog(this.getClass());

    public void executeByLaunchConfiguration(BootstrapConfiguration bootstrapConfiguration) {
        block8: {
            this.bootstrapSettings = bootstrapConfiguration;
            if (this.bootstrapSettings.isShutdownRequested()) {
                try {
                    try {
                        this.writeToLog("Running this instance as a shutdown signal sender");
                        this.sendShutdownTokenInternal(this.bootstrapSettings.getTargetShutdownDataDirectory());
                        break block8;
                    }
                    catch (IOException e) {
                        this.logger.error((Object)("Failed to shutdown external instance: " + e.getMessage()));
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    this.tryToRemoveInternalProfileDir();
                    System.exit(0);
                }
            }
            try {
                this.initReceiver(this.bootstrapSettings.getOwnShutdownDataDirectory());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void shutdownExternalInstance(File externalProfileDir) throws IOException {
        this.sendShutdownTokenInternal(new File(externalProfileDir, "internal"));
    }

    private void writeToLog(String text) {
        this.logger.debug((Object)text);
    }

    private void initReceiver(File shutdownDataDir) throws IOException {
        if (!shutdownDataDir.exists()) {
            shutdownDataDir.mkdirs();
        }
        final ServerSocket serverSocket = new ServerSocket(0);
        int port = serverSocket.getLocalPort();
        final String secretString = IdGenerator.secureRandomHexString((int)32);
        String secret = StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(port), secretString});
        File secretFile = new File(shutdownDataDir, TOKEN_FILENAME);
        FileUtils.writeStringToFile((File)secretFile, (String)secret);
        secretFile.deleteOnExit();
        this.writeToLog("Stored shutdown information at location " + secretFile.getAbsolutePath());
        ToolkitBridge.afterToolkitAvailable((Runnable)new Runnable(){

            @Override
            public void run() {
                HeadlessShutdown.this.startShutdownListener(serverSocket, secretString);
            }
        });
    }

    private void startShutdownListener(ServerSocket serverSocket, String secretString) {
        ConcurrencyUtils.getAsyncTaskService().execute("Service/daemon shutdown listener", () -> {
            this.writeToLog("Listening for shutdown signals");
            Socket client = null;
            String message = null;
            try {
                client = this.waitForConnection(serverSocket);
                message = this.readMessage(client);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (message != null) {
                this.writeToLog("Message \"" + message + "\" received");
                if (message.contains("shutdown") && message.contains(secretString)) {
                    this.logger.info((Object)"Received shutdown signal, shutting down");
                    IOUtils.closeQuietly((ServerSocket)serverSocket);
                    Instance.shutdown();
                    try {
                        Thread.sleep(60000L);
                        this.writeToLog("Regular shutdown time expired, shutting down hard using System.exit()");
                        System.exit(0);
                    }
                    catch (InterruptedException interruptedException) {
                        this.writeToLog("Received expected interrupt before the shutdown timeout expired");
                    }
                }
            }
        });
    }

    private Socket waitForConnection(ServerSocket serverSocket) throws IOException {
        this.writeToLog("Waiting for connection at port " + serverSocket.getLocalPort());
        Socket socket = serverSocket.accept();
        this.writeToLog("Accepted connection at port " + socket.getLocalPort());
        return socket;
    }

    private String readMessage(Socket socket) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        char[] buffer = new char[200];
        int length = bufferedReader.read(buffer, 0, 200);
        String message = new String(buffer, 0, length);
        return message;
    }

    private void sendShutdownTokenInternal(File shutdownDataDir) throws IOException, UnknownHostException {
        String content;
        File secretFile = new File(shutdownDataDir, TOKEN_FILENAME);
        if (!secretFile.exists()) {
            this.logger.warn((Object)"The shutdown configuration file does not exit. Most likely, the target instance is not running.");
            return;
        }
        try {
            content = FileUtils.readFileToString((File)secretFile);
        }
        catch (IOException e) {
            this.logger.warn((Object)("Failed to load shutdown configuration file: " + e.getMessage()));
            throw e;
        }
        int port = Integer.parseInt(StringUtils.splitAndUnescape((String)content)[0]);
        String secret = StringUtils.splitAndUnescape((String)content)[1];
        Socket socket = new Socket(HOST, port);
        String message = "shutdown " + secret;
        this.writeToLog("Sending \"" + message + "\" to " + HOST + ":" + port);
        this.writeMessageToConnection(socket, message);
    }

    private void tryToRemoveInternalProfileDir() {
        if (!this.bootstrapSettings.deleteInternalDataDirectoryIfEmpty()) {
            this.logger.warn((Object)("Failed to remove temporary profile directory " + this.bootstrapSettings.getInternalDataDirectory() + " although it should not contain any files"));
        }
    }

    private void writeMessageToConnection(Socket socket, String message) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        printWriter.print(message);
        printWriter.flush();
    }
}

