/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountImpl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import de.rcenvironment.core.embedded.ssh.internal.SshConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConfiguration {
    protected static final int DEFAULT_PORT = 31005;
    protected static final String DEFAULT_HOST = "127.0.0.1";
    protected static final Integer DEFAULT_IDLE_TIMEOUT_SECONDS = 600;
    private static final String CONFIG_PROPERTY_IDLE_TIMEOUT_SECONDS = "idleTimeoutSeconds";
    private boolean enabled = false;
    private String host;
    private int port;
    private Integer idleTimeoutSeconds;
    private List<SshAccountImpl> accounts = new ArrayList<SshAccountImpl>();
    private final List<SshAccountRole> roles;

    public SshConfiguration() {
        this.host = DEFAULT_HOST;
        this.port = 31005;
        this.roles = this.createPredefinedRoles();
    }

    public SshConfiguration(ConfigurationSegment configurationSegment) throws ConfigurationException, IOException {
        this.roles = this.createPredefinedRoles();
        this.enabled = configurationSegment.getBoolean("enabled", Boolean.valueOf(false));
        this.idleTimeoutSeconds = configurationSegment.getInteger(CONFIG_PROPERTY_IDLE_TIMEOUT_SECONDS, DEFAULT_IDLE_TIMEOUT_SECONDS);
        if (this.idleTimeoutSeconds <= 0) {
            LogFactory.getLog(this.getClass()).warn((Object)("Invalid value for SSH server setting 'idleTimeoutSeconds' - using default of " + DEFAULT_IDLE_TIMEOUT_SECONDS));
            this.idleTimeoutSeconds = DEFAULT_IDLE_TIMEOUT_SECONDS;
        }
        String oldHostSetting = configurationSegment.getString("host");
        String newHostSetting = configurationSegment.getString("ip");
        if (oldHostSetting != null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Deprecated SSH server configuration parameter \"host\" used - use \"ip\" instead");
            this.host = oldHostSetting;
        }
        if (newHostSetting != null) {
            if (oldHostSetting != null) {
                LogFactory.getLog(this.getClass()).error((Object)"Both \"host\" and \"ip\" settings of SSH server used; ignoring deprecated \"host\" setting");
            }
            this.host = newHostSetting;
        }
        if (this.host == null) {
            this.host = DEFAULT_HOST;
        }
        this.port = configurationSegment.getInteger("port", Integer.valueOf(31005));
        for (Map.Entry entry : configurationSegment.listElements("accounts").entrySet()) {
            try {
                SshAccountImpl account = (SshAccountImpl)((ConfigurationSegment)entry.getValue()).mapToObject(SshAccountImpl.class);
                account.setLoginName((String)entry.getKey());
                this.accounts.add(account);
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Error parsing the configuration for account \"" + (String)entry.getKey() + "\". The embedded SSH server will not be started.");
            }
        }
        if (configurationSegment.getSubSegment("roles").isPresentInCurrentConfiguration()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Deprecated \"roles\" configuration used. The roles will not be applied. Only predefined roles can be used. A list of available roles can be found in the configuration reference or the user guide.");
        }
    }

    private List<SshAccountRole> createPredefinedRoles() {
        ArrayList<SshAccountRole> predefRoles = new ArrayList<SshAccountRole>();
        String[] stringArray = SshConstants.PREDEFINED_ROLE_NAMES;
        int n = SshConstants.PREDEFINED_ROLE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            predefRoles.add(new SshAccountRole(roleName));
            ++n2;
        }
        return predefRoles;
    }

    public boolean validateConfiguration(Log logger) {
        boolean isValid = true;
        ArrayList<SshAccountImpl> valUsers = new ArrayList<SshAccountImpl>();
        if (this.host == null || this.host.isEmpty()) {
            logger.warn((Object)"SSH server host can not be empty");
        }
        if (this.port < 0 || this.port > 65535) {
            logger.warn((Object)"sshContactPoint must be between 0 and 65535");
            isValid = false;
        }
        if (this.accounts != null && !this.accounts.isEmpty()) {
            for (SshAccountImpl user : this.accounts) {
                boolean bl = isValid = user.validate(this.roles, logger) && isValid;
                if (valUsers.contains(user)) {
                    logger.warn((Object)("User names must be distinct. Found two users with name: " + user.getLoginName()));
                    isValid = false;
                    continue;
                }
                valUsers.add(user);
            }
        } else {
            logger.warn((Object)"Configuration did not include user definitions. At least one user must be defined.");
            isValid = false;
        }
        if (!isValid) {
            logger.error((Object)"Embedded SSH server will not be started due to an error in the configuration.");
        }
        return isValid;
    }

    public SshAccount getAccountByName(String loginName, boolean allowDisabled) {
        SshAccount curUser = null;
        for (SshAccount sshAccount : this.accounts) {
            if (!sshAccount.getLoginName().equals(loginName) || !allowDisabled && !sshAccount.isEnabled()) continue;
            if (curUser != null) {
                LogFactory.getLog(this.getClass()).error((Object)("Invalid state: more than one SSH account matched for login name '" + loginName + "'! Returning 'null' for safety"));
                return null;
            }
            curUser = sshAccount;
        }
        return curUser;
    }

    public SshAccountRole getRoleByName(String roleName) {
        SshAccountRole curRole = null;
        for (SshAccountRole role : this.roles) {
            if (!role.getRoleName().equals(roleName)) continue;
            curRole = role;
            break;
        }
        if (curRole == null) {
            curRole = this.getRoleByName("default");
        }
        return curRole;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean startSshConsole) {
        this.enabled = startSshConsole;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setPort(int sshContactPoint) {
        this.port = sshContactPoint;
    }

    public List<SshAccountImpl> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<SshAccountImpl> users) {
        this.accounts = users;
    }

    public List<SshAccountRole> getRoles() {
        return this.roles;
    }
}

