/*
 * Decompiled with CFR 0.152.
 */
package cucumber.java.runtime.osgi;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public abstract class OsgiObjectFactoryBase
implements ObjectFactory {
    private final Map<Class<?>, Object> instances = new HashMap();

    public void start() {
    }

    public void stop() {
        this.instances.clear();
    }

    public boolean addClass(Class<?> glueClass) {
        return true;
    }

    public <T> T getInstance(Class<T> glueClass) {
        T instance = glueClass.cast(this.instances.get(glueClass));
        if (instance == null) {
            instance = this.cacheNewInstance(glueClass);
            this.prepareGlueInstance(instance);
        }
        return instance;
    }

    protected abstract void prepareGlueInstance(Object var1);

    private <T> T cacheNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            this.instances.put(type, instance);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(String.format("%s doesn't have an empty constructor. If you need DI, put cucumber-picocontainer on the classpath", type), (Throwable)e);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }
}

