/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.core.utils.incubator.FileSystemOperations;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentOperationsImpl {
    private static final String RCE = "rce";
    private static final int BYTE_TO_MEGABYTE_FACTOR = 0x100000;
    private static final int CONSOLE_SHOW_PROGRESS_INTERVAL = 500;
    private static final String DELETION_MARKER_FILE_NAME = "markedForDeletion";
    private final Log log = LogFactory.getLog(this.getClass());
    private volatile boolean downloadRunning = false;
    private TextOutputReceiver userOutputReceiver;

    public void downloadFile(String url, File targetFile, boolean allowOverwrite, boolean showProgress) throws IOException {
        String targetPath = targetFile.getAbsolutePath();
        if (targetFile.exists()) {
            if (!allowOverwrite) {
                throw new IOException("Target file " + targetPath + " does already exist");
            }
            if (!targetFile.delete()) {
                throw new IOException("Failed to delete existing download file " + targetPath);
            }
        }
        File tempDownloadFile = new File(targetFile.getParentFile(), String.valueOf(targetFile.getName()) + ".tmp");
        this.log.debug((Object)StringUtils.format((String)"Starting download of %s to %s", (Object[])new Object[]{url, tempDownloadFile.getAbsolutePath()}));
        long sizeOfRequestedFile = this.getFileSize(new URL(url));
        if (sizeOfRequestedFile > tempDownloadFile.getParentFile().getUsableSpace()) {
            throw new IOException("Download failed, not enough diskspace.");
        }
        this.downloadRunning = true;
        if (showProgress) {
            ConcurrencyUtils.getAsyncTaskService().execute("Instance Management: Print download progress to console", () -> {
                long totalProgressValue = sizeOfRequestedFile / 0x100000L;
                long lastProgressValue = 0L;
                while (this.downloadRunning && tempDownloadFile.length() < sizeOfRequestedFile) {
                    long roundedProgressValue = tempDownloadFile.length() / 0x100000L;
                    if (roundedProgressValue != lastProgressValue) {
                        this.userOutputReceiver.addOutput("Downloaded " + roundedProgressValue + " MB of " + totalProgressValue + " MB");
                        lastProgressValue = roundedProgressValue;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.error((Object)"InterruptedException while download progress thread sleeps.");
                    }
                }
                this.userOutputReceiver.addOutput("Download finished.");
            });
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)tempDownloadFile);
            if (!tempDownloadFile.renameTo(targetFile)) {
                throw new IOException("Failed to move the completed download file " + tempDownloadFile.getAbsolutePath() + " to " + targetPath);
            }
        }
        finally {
            this.downloadRunning = false;
        }
    }

    public void installFromProductZip(File zipFile, File installationDir) throws IOException {
        if (installationDir.exists()) {
            throw new IOException("Target installation directory does already exist: " + installationDir.getAbsolutePath());
        }
        this.log.debug((Object)("Starting to extract " + zipFile.getAbsolutePath() + " to " + installationDir.getAbsolutePath()));
        if (!FileCompressionService.expandCompressedDirectoryFromFile((File)zipFile, (File)installationDir, (FileCompressionFormat)FileCompressionFormat.ZIP).booleanValue()) {
            this.log.error((Object)"Was not able to install from product zip due to an archive issue.");
            throw new IOException("Was not able to install from product zip due to an archive issue.");
        }
        File rceFolder = new File(installationDir, RCE);
        if (!rceFolder.isDirectory()) {
            throw new IOException("Expected 'rce' folder does not exist");
        }
        File newFolder = new File(installationDir, "something");
        rceFolder.renameTo(newFolder);
        File[] fileArray = newFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File contentFile = fileArray[n2];
            FileUtils.moveToDirectory((File)contentFile, (File)installationDir, (boolean)false);
            ++n2;
        }
        if (!newFolder.delete()) {
            throw new IOException("Failed to delete the nested 'rce' folder (which should be empty at this point)");
        }
        File execfile = new File(installationDir, RCE);
        if (execfile.exists()) {
            LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(installationDir);
            executor.start(StringUtils.format((String)"chmod +x %s", (Object[])new Object[]{execfile.getAbsolutePath()}));
        }
    }

    public void deleteInstallation(File installationDir) throws IOException {
        boolean containsRCEExecutable = false;
        boolean containsP2Folder = false;
        boolean containsPluginsFolder = false;
        boolean containsFeaturesFolder = false;
        boolean containsDeletionMarkerFile = false;
        File[] fileArray = installationDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (file.getName().equals("rce.exe") || file.getName().equals(RCE)) {
                    containsRCEExecutable = true;
                } else if (file.getName().equals(DELETION_MARKER_FILE_NAME)) {
                    containsDeletionMarkerFile = true;
                }
            } else if (file.isDirectory()) {
                if (file.getName().equals("p2")) {
                    containsP2Folder = true;
                } else if (file.getName().equals("plugins")) {
                    containsPluginsFolder = true;
                } else if (file.getName().equals("features")) {
                    containsFeaturesFolder = true;
                }
            }
            ++n2;
        }
        if (containsFeaturesFolder && containsP2Folder && containsPluginsFolder && containsRCEExecutable || containsDeletionMarkerFile) {
            int i = 10;
            boolean wasDeleted = false;
            do {
                FileSystemOperations.deleteSandboxDirectory((File)installationDir);
                if (!installationDir.exists()) {
                    wasDeleted = true;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Failed to delete installation directory at location " + installationDir.getAbsolutePath() + ". Task was interrupted.");
                }
            } while (--i > 0);
            if (!wasDeleted) {
                File markerFile = new File(installationDir, DELETION_MARKER_FILE_NAME);
                if (!markerFile.exists() && !markerFile.createNewFile()) {
                    throw new IOException("Could not delete installation directory at location " + installationDir.getAbsolutePath() + " and could not create a file marking it for future deletion. Possibly access rights are missing.");
                }
                throw new IOException("Could not delete installation directory at location " + installationDir.getAbsolutePath() + ". Most likely it is used by another program.");
            }
        } else {
            throw new IOException("The existing installation directory " + installationDir.getAbsolutePath() + " does not look like a valid RCE installation; aborting delete operation");
        }
    }

    private int getFileSize(URL url) throws IOException {
        HttpURLConnection httpConnection = null;
        try {
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestMethod("HEAD");
            httpConnection.getInputStream();
            int n = httpConnection.getContentLength();
            return n;
        }
        finally {
            if (httpConnection == null) {
                throw new IOException("Failed to get file size of remote file: " + url.toExternalForm());
            }
            httpConnection.disconnect();
        }
    }

    public void setUserOutputReceiver(TextOutputReceiver userOutputReceiver) {
        this.userOutputReceiver = userOutputReceiver;
    }
}

