/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import java.io.IOException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LoggingConfiguredProperlyValidator
extends DefaultInstanceValidator {
    private ConfigurationAdmin configurationAdmin;

    public InstanceValidationResult validate() {
        boolean isConfiguredProperly = false;
        Configuration paxLoggingConfiguration = null;
        try {
            String paxLoggingPid = "org.ops4j.pax.logging";
            paxLoggingConfiguration = this.configurationAdmin.getConfiguration(paxLoggingPid);
        }
        catch (IOException iOException) {
            return this.createInstanceValidationResultForFailure("Logging configuration");
        }
        String nonDefaultPaxConfigKey = "log4j.appender.CONSOLE";
        boolean bl = isConfiguredProperly = paxLoggingConfiguration.getProperties() != null && paxLoggingConfiguration.getProperties().get(nonDefaultPaxConfigKey) != null;
        if (!isConfiguredProperly) {
            return this.createInstanceValidationResultForFailure("Logging configuration");
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Logging configuration");
    }

    private InstanceValidationResult createInstanceValidationResultForFailure(String validationDisplayName) {
        return InstanceValidationResultFactory.createResultForFailureWhichAllowesToProceed((String)validationDisplayName, (String)"Failed to initialize background logging properly. Most likely, because RCE was started from another directory than its installation directory. (The installation directory is the directory that contains the 'rce' executable.)  It is recommended to start RCE again from its installation directory.", (String)"Failed to initialize background logging properly. Most likely, because RCE was started from another directory than its installation directory. (The installation directory is the directory that contains the 'rce' executable.)\n\n It is recommended to start RCE again from its installation directory.");
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin newService) {
        this.configurationAdmin = newService;
    }
}

