/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupListener;
import de.rcenvironment.core.authorization.api.AuthorizationIdRules;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.api.DefaultAuthorizationObjects;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.authorization.internal.AuthorizationAccessGroupImpl;
import de.rcenvironment.core.authorization.internal.AuthorizationConstants;
import de.rcenvironment.core.authorization.internal.AuthorizationPermissionSetImpl;
import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsConsumer;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final int PRE_RELEASE_KEY_DATA_LENGTH = 23;
    private static final String SECURE_STORAGE_NODE_ID = "authorization.accessGroups";
    private static final Pattern GROUP_EXPORT_FORMAT_PARSE_PATTERN = Pattern.compile("^(.+):([^:]+):(\\d:[^:]+)$");
    private final DefaultAuthorizationObjects defaultPermissionSets;
    private SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> accessibleGroupKeyData = new TreeMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData>();
    private final List<AuthorizationAccessGroupListener> groupChangeListeners = new ArrayList<AuthorizationAccessGroupListener>();
    private CryptographyOperationsProvider cryptographyOperations;
    private Object storageLock = new Object();
    private SecureStorageSection groupDataStorage;
    private volatile boolean initializingFromPersistedData;
    private final Log log = LogFactory.getLog(this.getClass());

    public AuthorizationServiceImpl() {
        this.defaultPermissionSets = new DefaultAuthorizationObjects(){

            @Override
            public AuthorizationAccessGroup accessGroupPublicInLocalNetwork() {
                return AuthorizationConstants.GROUP_OBJECT_PUBLIC_IN_LOCAL_NETWORK;
            }

            @Override
            public AuthorizationPermissionSet permissionSetPublicInLocalNetwork() {
                return AuthorizationConstants.PERMISSION_SET_PUBLIC_IN_LOCAL_NETWORK;
            }

            @Override
            public AuthorizationPermissionSet permissionSetLocalOnly() {
                return AuthorizationConstants.PERMISSION_SET_LOCAL_ONLY;
            }
        };
    }

    @Activate
    public void activate() {
        this.initializingFromPersistedData = true;
        this.restorePersistedGroups();
        this.initializingFromPersistedData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPersistentStorageAvailable() {
        Object object = this.storageLock;
        synchronized (object) {
            return this.groupDataStorage != null;
        }
    }

    @Override
    public DefaultAuthorizationObjects getDefaultAuthorizationObjects() {
        return this.defaultPermissionSets;
    }

    @Override
    public CryptographyOperationsProvider getCryptographyOperationsProvider() {
        return this.cryptographyOperations;
    }

    @Override
    public AuthorizationPermissionSet buildPermissionSet(AuthorizationAccessGroup ... groups) {
        return new AuthorizationPermissionSetImpl(groups);
    }

    @Override
    public AuthorizationPermissionSet buildPermissionSet(Collection<AuthorizationAccessGroup> groups) {
        return new AuthorizationPermissionSetImpl(groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthorizationAccessGroup> listAccessibleGroups(boolean includeHardcodedGroups) {
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            int size = this.accessibleGroupKeyData.size();
            if (includeHardcodedGroups) {
                ++size;
            }
            ArrayList<AuthorizationAccessGroup> result = new ArrayList<AuthorizationAccessGroup>(size);
            result.addAll(this.accessibleGroupKeyData.keySet());
            if (includeHardcodedGroups) {
                result.add(AuthorizationConstants.GROUP_OBJECT_PUBLIC_IN_LOCAL_NETWORK);
            }
            return result;
        }
    }

    @Override
    public boolean isValidGroupName(String displayName) {
        return !AuthorizationIdRules.validateAuthorizationGroupId(displayName).isPresent();
    }

    @Override
    public AuthorizationAccessGroup createLocalGroup(String displayName) throws OperationFailureException {
        Optional<String> validationError = AuthorizationIdRules.validateAuthorizationGroupId(displayName);
        if (validationError.isPresent()) {
            throw new OperationFailureException(validationError.get());
        }
        String idPart = IdGenerator.secureRandomHexString((int)16);
        AuthorizationAccessGroupKeyData keyMaterial = this.generateNewKeyData();
        return this.createAndRegisterGroup(displayName, idPart, keyMaterial);
    }

    @Override
    public AuthorizationAccessGroup representRemoteGroupId(String fullGroupId) throws OperationFailureException {
        Optional<String> validationError = AuthorizationIdRules.validateAuthorizationGroupFullId(fullGroupId = fullGroupId.trim());
        if (validationError.isPresent()) {
            throw new OperationFailureException(validationError.get());
        }
        String[] parts = fullGroupId.split(":");
        String groupName = parts[0];
        String idPart = parts[1];
        return new AuthorizationAccessGroupImpl(groupName, idPart, fullGroupId, this.defaultGroupDisplayName(groupName, idPart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizationAccessGroup findLocalGroupById(String searchString) throws OperationFailureException {
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            for (AuthorizationAccessGroup group : this.accessibleGroupKeyData.keySet()) {
                if (!group.getFullId().equals(searchString)) continue;
                return group;
            }
            AuthorizationAccessGroup match = null;
            for (AuthorizationAccessGroup group : this.accessibleGroupKeyData.keySet()) {
                if (!group.getName().equals(searchString) && !group.getIdPart().equals(searchString)) continue;
                if (match != null) {
                    throw new OperationFailureException(StringUtils.format((String)" The group id %s is ambiguous - it is matched by local groups %s and %s", (Object[])new Object[]{searchString, match.getFullId(), group.getFullId()}));
                }
                match = group;
            }
            return match;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizationAccessGroupKeyData getKeyDataForGroup(AuthorizationAccessGroup group) {
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            return (AuthorizationAccessGroupKeyData)this.accessibleGroupKeyData.get(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLocalGroupData(AuthorizationAccessGroup group) {
        List<AuthorizationAccessGroup> immutableGroupList;
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            this.accessibleGroupKeyData.remove(group);
            immutableGroupList = this.createImmutableCopyOfGroupList();
        }
        if (!this.initializingFromPersistedData) {
            this.deleteGroupFromPersistence(group);
        } else {
            this.log.warn((Object)"Unexpected state - group deleted during initialization?");
        }
        this.notifyChangeListeners(immutableGroupList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGroupAccessible(AuthorizationAccessGroup group) {
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            return this.accessibleGroupKeyData.containsKey(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportToString(AuthorizationAccessGroup group) {
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            block4: {
                if (this.isGroupAccessible(group)) break block4;
                return null;
            }
            String encodedKeyData = ((AuthorizationAccessGroupKeyData)this.accessibleGroupKeyData.get(group)).getEncodedStringForm();
            return String.valueOf(group.getFullId()) + ":" + encodedKeyData;
        }
    }

    @Override
    public AuthorizationAccessGroup importFromString(String externalFormat) throws OperationFailureException {
        SymmetricKey groupKey;
        Matcher matcher = GROUP_EXPORT_FORMAT_PARSE_PATTERN.matcher(externalFormat);
        if (!matcher.matches()) {
            throw new OperationFailureException("Invalid exported group data: " + externalFormat);
        }
        String keyString = matcher.group(3);
        try {
            groupKey = this.cryptographyOperations.decodeSymmetricKey(keyString);
        }
        catch (RuntimeException e) {
            throw new OperationFailureException("Invalid exported access key: " + e.toString());
        }
        return this.createAndRegisterGroup(matcher.group(1), matcher.group(2), new AuthorizationAccessGroupKeyData(groupKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference
    protected void bindSecureStorageService(SecureStorageService secureStorageService) {
        try {
            Object object = this.storageLock;
            synchronized (object) {
                this.groupDataStorage = secureStorageService.getSecureStorageSection(SECURE_STORAGE_NODE_ID);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to acquire Secure Storage, authorization information will not be persisted: " + e.toString()));
            this.groupDataStorage = null;
        }
    }

    @Reference
    protected void bindObjectBindingsService(ObjectBindingsService objectBindingsService) {
        objectBindingsService.setConsumer(AuthorizationAccessGroupListener.class, (ObjectBindingsConsumer)new ObjectBindingsConsumer<AuthorizationAccessGroupListener>(){

            public void addInstance(AuthorizationAccessGroupListener instance) {
                AuthorizationServiceImpl.this.addAuthorizationAccessGroupListener(instance);
            }

            public void removeInstance(AuthorizationAccessGroupListener instance) {
                AuthorizationServiceImpl.this.removeAuthorizationAccessGroupListener(instance);
            }
        });
    }

    @Reference
    public void bindCryptographyOperationsProvider(CryptographyOperationsProvider newInstance) {
        this.cryptographyOperations = newInstance;
    }

    @Override
    public boolean isPublicAccessGroup(AuthorizationAccessGroup accessGroup) {
        return accessGroup.getFullId().equals("public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean persistGroupData(AuthorizationAccessGroupImpl group, AuthorizationAccessGroupKeyData keyData) {
        boolean success = true;
        Object object = this.storageLock;
        synchronized (object) {
            if (this.groupDataStorage != null) {
                try {
                    this.groupDataStorage.store(group.getFullId(), keyData.getEncodedStringForm());
                }
                catch (OperationFailureException e) {
                    this.log.error((Object)("Error while saving new key data for access group " + group.getFullId() + ": " + e.toString()));
                    success = false;
                }
            } else {
                this.log.warn((Object)("Authorization storage is disabled - the new data for group " + group.getFullId() + " will not be saved! Export it and save the exported data manually to prevent losing group access"));
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePersistedGroups() {
        Object object = this.storageLock;
        synchronized (object) {
            String[] ids;
            if (this.groupDataStorage != null && (ids = this.groupDataStorage.listKeys()) != null && ids.length != 0) {
                List<AuthorizationAccessGroup> immutableGroupList;
                this.log.debug((Object)("Restoring " + ids.length + " persisted access group(s) with access keys"));
                SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
                synchronized (sortedMap) {
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        this.restorePersistedGroup(id);
                        ++n2;
                    }
                    immutableGroupList = this.createImmutableCopyOfGroupList();
                }
                this.notifyChangeListeners(immutableGroupList);
            }
        }
    }

    private void restorePersistedGroup(String id) {
        try {
            String[] idParts = id.split(":");
            if (idParts.length != 2) {
                this.log.error((Object)("Ignoring invalid access group id in secure storage: " + id));
                return;
            }
            String keyData = this.groupDataStorage.read(id, null);
            if (keyData == null || keyData.isEmpty()) {
                this.log.error((Object)("Ignoring invalid stored key data for access group " + id));
                return;
            }
            if (keyData.length() == 23) {
                this.log.warn((Object)("Ignoring pre-release 128 bit key for access group " + id + "; delete the related line in the secure storage file " + "<profile>/internal/settings.secure.dat to get rid of this message"));
                return;
            }
            SymmetricKey key = this.cryptographyOperations.decodeSymmetricKey(keyData);
            this.createAndRegisterGroup(idParts[0], idParts[1], new AuthorizationAccessGroupKeyData(key));
            this.log.debug((Object)("Restored persisted access group " + id));
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Error while restoring access group " + id + ": " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGroupFromPersistence(AuthorizationAccessGroup group) {
        Object object = this.storageLock;
        synchronized (object) {
            if (this.groupDataStorage != null) {
                try {
                    this.groupDataStorage.delete(group.getFullId());
                }
                catch (OperationFailureException operationFailureException) {
                    this.log.error((Object)("Failed to delete the local access group " + group.getFullId() + " from authorization storage - " + " it may return after a restart if it was present before startup"));
                }
            } else {
                this.log.warn((Object)("Authorization storage is disabled - group " + group.getFullId() + " was not deleted from storage and may return after restart if it was present before startup"));
            }
        }
    }

    private AuthorizationAccessGroupKeyData generateNewKeyData() throws OperationFailureException {
        return new AuthorizationAccessGroupKeyData(this.cryptographyOperations.generateSymmetricKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationAccessGroupImpl createAndRegisterGroup(String name, String idPart, AuthorizationAccessGroupKeyData keyData) {
        List<AuthorizationAccessGroup> immutableGroupList;
        AuthorizationAccessGroupImpl group = new AuthorizationAccessGroupImpl(name, idPart, String.valueOf(name) + ":" + idPart, this.defaultGroupDisplayName(name, idPart));
        if (!this.initializingFromPersistedData && !this.persistGroupData(group, keyData)) {
            return null;
        }
        SortedMap<AuthorizationAccessGroup, AuthorizationAccessGroupKeyData> sortedMap = this.accessibleGroupKeyData;
        synchronized (sortedMap) {
            this.accessibleGroupKeyData.put(group, keyData);
            immutableGroupList = this.createImmutableCopyOfGroupList();
        }
        this.notifyChangeListeners(immutableGroupList);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, unbind="removeAuthorizationAccessGroupListener")
    public void addAuthorizationAccessGroupListener(AuthorizationAccessGroupListener listener) {
        List<AuthorizationAccessGroupListener> list = this.groupChangeListeners;
        synchronized (list) {
            this.groupChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthorizationAccessGroupListener(AuthorizationAccessGroupListener listener) {
        List<AuthorizationAccessGroupListener> list = this.groupChangeListeners;
        synchronized (list) {
            if (!this.groupChangeListeners.remove(listener)) {
                LogFactory.getLog(this.getClass()).error((Object)("Removed a listener that was not previously registered: " + listener.getClass()));
            }
        }
    }

    private List<AuthorizationAccessGroup> createImmutableCopyOfGroupList() {
        return Collections.unmodifiableList(this.listAccessibleGroups(true));
    }

    private String defaultGroupDisplayName(String name, String idPart) {
        if (idPart != null) {
            return StringUtils.format((String)"%s [%s]", (Object[])new Object[]{name, idPart});
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangeListeners(List<AuthorizationAccessGroup> immutableGroupList) {
        if (this.initializingFromPersistedData) {
            return;
        }
        List<AuthorizationAccessGroupListener> list = this.groupChangeListeners;
        synchronized (list) {
            this.log.debug((Object)("Notifying " + this.groupChangeListeners.size() + " listener(s) of an authorization group change; new group list entry count: " + immutableGroupList.size()));
            for (AuthorizationAccessGroupListener listener : this.groupChangeListeners) {
                listener.onAvailableAuthorizationAccessGroupsChanged(immutableGroupList);
            }
        }
    }
}

