/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentImageContainerService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Image;

public class InstanceComponentsInfoContributor
extends NetworkViewContributorBase {
    private static final int INSTANCE_ELEMENTS_PRIORITY = 10;
    private final AuthorizationService authorizationService;
    private Image folderImage;
    private Image componentFallbackImage;

    public InstanceComponentsInfoContributor() {
        ImageManager imageManager = ImageManager.getInstance();
        this.folderImage = imageManager.getSharedImage((ImageSource)StandardImages.FOLDER_16);
        this.componentFallbackImage = imageManager.getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
        this.authorizationService = (AuthorizationService)ServiceRegistry.createAccessFor((Object)this).getService(AuthorizationService.class);
    }

    @Override
    public int getRootElementsPriority() {
        return 0;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        return null;
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 10;
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext parentNode) {
        ArrayList<ComponentFolderNode> result = new ArrayList<ComponentFolderNode>(2);
        if (this.currentModel.componentKnowledge != null) {
            Collection publishedInstallations = this.currentModel.componentKnowledge.getKnownSharedInstallationsOnNode((ResolvableNodeId)parentNode.getNode().getNodeId(), true);
            if (publishedInstallations != null && !publishedInstallations.isEmpty()) {
                result.add(new ComponentFolderNode(parentNode, true));
            }
            if (parentNode.isLocalNode()) {
                result.add(new ComponentFolderNode(parentNode, false));
            }
        }
        return result.toArray();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        if (parentNode instanceof ComponentFolderNode) {
            ComponentFolderNode typedNode = (ComponentFolderNode)parentNode;
            if (typedNode.getTypeIsPublic()) {
                return true;
            }
            Collection localInstallations = this.currentModel.componentKnowledge.getLocalAccessInstallations();
            return !localInstallations.isEmpty();
        }
        if (parentNode instanceof NetworkGraphNodeWithContext) {
            this.assertIsComponentNode((NetworkGraphNodeWithContext)parentNode);
            return false;
        }
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object parentNode) {
        ComponentFolderNode typedParentNode = (ComponentFolderNode)parentNode;
        NetworkGraphNodeWithContext instanceNode = typedParentNode.getInstanceNode();
        if (typedParentNode.getTypeIsPublic()) {
            Collection publishedInstallations = this.currentModel.componentKnowledge.getKnownSharedInstallationsOnNode((ResolvableNodeId)instanceNode.getNode().getNodeId(), true);
            return this.createNodesForComponentInstallations(instanceNode, publishedInstallations);
        }
        Collection componentEntries = this.currentModel.componentKnowledge.getLocalAccessInstallations();
        return this.createNodesForComponentInstallations(instanceNode, componentEntries);
    }

    @Override
    public Object getParent(Object node) {
        if (node instanceof ComponentFolderNode) {
            return ((ComponentFolderNode)node).getInstanceNode();
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            return ((NetworkGraphNodeWithContext)node).getParent();
        }
        return null;
    }

    @Override
    public String getText(Object node) {
        if (node instanceof ComponentFolderNode) {
            ComponentFolderNode typedNode = (ComponentFolderNode)node;
            if (typedNode.getTypeIsPublic()) {
                return "Published Components";
            }
            return "Local Components";
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            Collection permissionSet;
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            this.assertIsComponentNode(typedNode);
            StringBuilder returnValueBuilder = new StringBuilder();
            if (typedNode.getComponentInstallation() != null) {
                ComponentInterface componentInterface = typedNode.getComponentInstallation().getComponentInterface();
                returnValueBuilder.append(componentInterface.getDisplayName());
                if (componentInterface.getVersion() != null && componentInterface.getIdentifierAndVersion().startsWith("de.rcenvironment.integration.common.") || componentInterface.getIdentifierAndVersion().startsWith("de.rcenvironment.integration.cpacs.")) {
                    returnValueBuilder.append(StringUtils.format((String)" (%s)", (Object[])new Object[]{componentInterface.getVersion()}));
                }
            } else {
                returnValueBuilder.append(typedNode.getDisplayText());
            }
            if (!(permissionSet = typedNode.getDistributedComponentEntry().getDeclaredPermissionSet().getAccessGroups()).isEmpty()) {
                boolean componentIsPublic;
                returnValueBuilder.append(" <");
                boolean bl = componentIsPublic = permissionSet.size() == 1 && this.authorizationService.isPublicAccessGroup((AuthorizationAccessGroup)permissionSet.iterator().next());
                if (componentIsPublic) {
                    returnValueBuilder.append("public");
                } else {
                    returnValueBuilder.append("available via ");
                    returnValueBuilder.append(permissionSet.stream().map(AuthorizationAccessGroup::getName).collect(Collectors.joining(", ")));
                }
                returnValueBuilder.append(">");
            }
            return returnValueBuilder.toString();
        }
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        if (node instanceof ComponentFolderNode) {
            return this.folderImage;
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            this.assertIsComponentNode(typedNode);
            ComponentInstallation installation = typedNode.getComponentInstallation();
            if (installation != null) {
                return ((ComponentImageContainerService)ServiceRegistry.createAccessFor((Object)this).getService(ComponentImageContainerService.class)).getComponentImageContainer(installation.getComponentInterface()).getComponentIcon16();
            }
            return this.componentFallbackImage;
        }
        throw this.newUnexpectedCallException();
    }

    private Object[] createNodesForComponentInstallations(NetworkGraphNodeWithContext node, Collection<DistributedComponentEntry> installations) {
        ArrayList<NetworkGraphNodeWithContext> result = new ArrayList<NetworkGraphNodeWithContext>();
        for (DistributedComponentEntry entry : installations) {
            ComponentInstallation installation = entry.getComponentInstallation();
            NetworkGraphNodeWithContext newChild = new NetworkGraphNodeWithContext(node, NetworkGraphNodeWithContext.Context.COMPONENT_INSTALLATION, (NetworkViewContributor)this);
            newChild.setComponentInstallation(installation);
            newChild.setDisplayText(entry.getDisplayName());
            newChild.setDistributedComponentEntry(entry);
            result.add(newChild);
        }
        Object[] resultArray = result.toArray();
        Arrays.sort(resultArray);
        return resultArray;
    }

    private void assertIsComponentNode(NetworkGraphNodeWithContext typedNode) {
        if (typedNode.getContext() != NetworkGraphNodeWithContext.Context.COMPONENT_INSTALLATION) {
            throw new IllegalStateException("Unexpected context: " + (Object)((Object)typedNode.getContext()));
        }
    }

    @Override
    public void dispose() {
    }

    private class ComponentFolderNode
    implements ContributedNetworkViewNode {
        private final NetworkGraphNodeWithContext instanceNode;
        private final boolean typeIsPublic;

        ComponentFolderNode(NetworkGraphNodeWithContext instanceNode, boolean typeIsPublic) {
            this.instanceNode = instanceNode;
            this.typeIsPublic = typeIsPublic;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return InstanceComponentsInfoContributor.this;
        }

        public NetworkGraphNodeWithContext getInstanceNode() {
            return this.instanceNode;
        }

        public boolean getTypeIsPublic() {
            return this.typeIsPublic;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getContributor().hashCode();
            result = this.instanceNode == null ? (result *= 31) : 31 * result + this.instanceNode.hashCode() + Boolean.valueOf(this.typeIsPublic).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentFolderNode other = (ComponentFolderNode)obj;
            if (this.typeIsPublic != other.typeIsPublic) {
                return false;
            }
            if (!this.getContributor().equals(other.getContributor())) {
                return false;
            }
            return !(this.instanceNode == null ? other.instanceNode != null : !this.instanceNode.equals(other.instanceNode));
        }
    }
}

