/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import de.rcenvironment.toolkit.modules.concurrency.api.RunnablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.internal.AsyncOrderedCallbackManagerImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.AsyncOrderedExecutionQueueImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.BatchAggregatorImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.CallablesGroupImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.ConcurrencyUtilsServiceHolder;
import de.rcenvironment.toolkit.modules.concurrency.internal.RunnablesGroupImpl;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;

public final class ConcurrencyUtilsFactoryImpl
implements ConcurrencyUtilsFactory {
    private final AsyncTaskService asyncTaskService;
    private final ConcurrencyUtilsServiceHolder internalServiceHolder;
    private final CounterCategory counterCategory;

    public ConcurrencyUtilsFactoryImpl(AsyncTaskService asyncTaskService, StatisticsTrackerService statisticsTrackerService) {
        this.asyncTaskService = asyncTaskService;
        this.internalServiceHolder = new ConcurrencyUtilsServiceHolder(asyncTaskService, statisticsTrackerService, this);
        this.counterCategory = statisticsTrackerService.getCounterCategory("ConcurrencyUtilsFactory requests", StatisticsFilterLevel.DEBUG);
    }

    @Override
    public AsyncOrderedExecutionQueue createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy exceptionPolicy) {
        this.counterCategory.countStacktrace();
        return new AsyncOrderedExecutionQueueImpl(exceptionPolicy, this.internalServiceHolder);
    }

    @Override
    public <T> AsyncOrderedCallbackManager<T> createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy exceptionPolicy) {
        this.counterCategory.countStacktrace();
        return new AsyncOrderedCallbackManagerImpl(exceptionPolicy, this.internalServiceHolder);
    }

    @Override
    public <T> BatchAggregator<T> createBatchAggregator(int maxBatchSize, long maxLatency, BatchProcessor<T> processor) {
        this.counterCategory.countStacktrace();
        return new BatchAggregatorImpl<T>(maxBatchSize, maxLatency, processor, this.internalServiceHolder);
    }

    @Override
    public <T> CallablesGroup<T> createCallablesGroup(Class<T> clazz) {
        this.counterCategory.countStacktrace();
        return new CallablesGroupImpl(this.asyncTaskService);
    }

    @Override
    public RunnablesGroup createRunnablesGroup() {
        this.counterCategory.countStacktrace();
        return new RunnablesGroupImpl(this.asyncTaskService);
    }
}

