/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class MaximumPermGenSizeValidator
extends DefaultInstanceValidator {
    private static final String VALIDATION_DISPLAY_NAME = "Maximum permanent generation heap (MaxPermSize)";
    private static final int DEFAULT_MIN_PERM_SIZE = 256;
    private static final String DEFAULT_MIN_PERM_SIZE_UNIT = "m";

    public InstanceValidationResult validate() {
        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimemxBean.getInputArguments();
        String maxPermSizeDefined = null;
        for (String str : arguments) {
            if (!str.startsWith("-XX:MaxPermSize")) continue;
            maxPermSizeDefined = str.substring(str.lastIndexOf(61) + 1);
        }
        if (maxPermSizeDefined != null) {
            int maxPermSizeValue = Integer.parseInt(maxPermSizeDefined.substring(0, maxPermSizeDefined.length() - 1));
            String maxPermSizeUnit = String.valueOf(maxPermSizeDefined.charAt(maxPermSizeDefined.length() - 1));
            if (maxPermSizeUnit.toUpperCase().equals(DEFAULT_MIN_PERM_SIZE_UNIT.toUpperCase()) && maxPermSizeValue < 256) {
                return this.createInstanceValidationResult(256, DEFAULT_MIN_PERM_SIZE_UNIT);
            }
        }
        long maxPermgen = 0L;
        for (MemoryPoolMXBean mx : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!mx.getName().endsWith("Perm Gen")) continue;
            maxPermgen = mx.getUsage().getMax() / (long)Math.pow(2.0, 20.0);
        }
        if (maxPermgen != 0L && maxPermgen < 256L) {
            return this.createInstanceValidationResult(256, DEFAULT_MIN_PERM_SIZE_UNIT);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)VALIDATION_DISPLAY_NAME);
    }

    private InstanceValidationResult createInstanceValidationResult(int minPermSizeValue, String minPermSizeUnit) {
        String errorMessage = String.valueOf(Messages.permGenSizeTooLow) + minPermSizeValue + minPermSizeUnit + ".";
        return InstanceValidationResultFactory.createResultForFailureWhichAllowesToProceed((String)VALIDATION_DISPLAY_NAME, (String)errorMessage);
    }
}

