/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LauncherVersionValidator
extends DefaultInstanceValidator {
    private static final String VALIDATION_DISPLAY_NAME = "Launcher Version";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public InstanceValidationResult validate() {
        String runningLauncherVersionStr = System.getProperty("de.rcenvironment.launcher.version");
        if (runningLauncherVersionStr == null) {
            this.log.warn((Object)"RCE was started with an old launcher version.");
            return InstanceValidationResultFactory.createResultForPassed((String)VALIDATION_DISPLAY_NAME);
        }
        try {
            int runningLauncherVersion = Integer.parseInt(runningLauncherVersionStr);
            if (runningLauncherVersion != 810) {
                this.log.warn((Object)StringUtils.format((String)"RCE was started with launcher version %d but version %d was expected.", (Object[])new Object[]{runningLauncherVersion, 810}));
            }
            return InstanceValidationResultFactory.createResultForPassed((String)VALIDATION_DISPLAY_NAME);
        }
        catch (NumberFormatException numberFormatException) {
            return InstanceValidationResultFactory.createResultForFailureWhichAllowesToProceed((String)VALIDATION_DISPLAY_NAME, (String)"RCE was started with an unkown launcher. This might result in unkown behaviour.", (String)"RCE was started with an unkown launcher. This might result in unkown behaviour.");
        }
    }
}

