/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.model.impl.ToolIntegrationConstants;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.TemplateListContentProvider;
import de.rcenvironment.core.gui.wizards.toolintegration.TemplateListData;
import de.rcenvironment.core.gui.wizards.toolintegration.TemplateListItem;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolIntegrationDoubleClickListener;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.wizards.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ChooseConfigurationPage
extends ToolIntegrationWizardPage {
    private static final Log LOGGER = LogFactory.getLog(ChooseConfigurationPage.class);
    private static final String JSON_SUFFIX = ".json";
    private Text textChosenConfig;
    private List toolList;
    private ListViewer templateListViewer;
    private final ToolIntegrationWizard wizard;
    private final String pageType;
    private Button newIntegrationButton = null;
    private Button loadInactiveConfigurationButton;
    private Button loadTemplateButton;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private final Collection<ToolIntegrationContext> allIntegrationContexts;
    private final Map<String, Map<String, Object>> allConfigurations;
    private Map<String, String> displayedToolNames;

    protected ChooseConfigurationPage(String pageName, Collection<ToolIntegrationContext> allIntegrationContexts, ToolIntegrationWizard wizard, String type) {
        super(pageName);
        this.setTitle(pageName);
        if (type.equals("NEW_COMMON")) {
            this.setDescription(Messages.newIntegrationDescription);
        } else {
            this.setDescription(Messages.editIntegrationDescription);
        }
        this.pageType = type;
        this.wizard = wizard;
        this.allIntegrationContexts = allIntegrationContexts;
        this.allConfigurations = new TreeMap<String, Map<String, Object>>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        GridData containerData = new GridData(1808);
        container.setLayoutData((Object)containerData);
        if (this.pageType.equals("NEW_COMMON")) {
            this.createNewIntegrationPart(container);
            this.createTemplatePart(container);
            this.createInactivePart(container);
        } else {
            new Label(container, 0).setText(Messages.chooseConfigToEdit);
        }
        final Map<String, String> configs = this.readExistingConfigurations(this.pageType);
        ListViewer toolListViewer = new ListViewer(container, 2052);
        toolListViewer.addDoubleClickListener((IDoubleClickListener)new ToolIntegrationDoubleClickListener(this));
        this.toolList = toolListViewer.getList();
        GridData toolListData = new GridData(1808);
        this.toolList.setLayoutData((Object)toolListData);
        this.displayedToolNames = new TreeMap<String, String>();
        for (String toolName : configs.keySet()) {
            String displayedToolName = this.createDisplayedToolName(toolName);
            this.displayedToolNames.put(displayedToolName, toolName);
            this.toolList.add(displayedToolName);
        }
        if (this.toolList.getItemCount() == 0) {
            this.toolList.setEnabled(false);
        }
        if (this.loadInactiveConfigurationButton != null && this.toolList.getItemCount() == 0) {
            this.loadInactiveConfigurationButton.setEnabled(false);
        }
        this.toolList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.toolList.isEnabled()) {
                    int[] selectedItems = ChooseConfigurationPage.this.toolList.getSelectionIndices();
                    ChooseConfigurationPage.this.textChosenConfig.setText("");
                    if (selectedItems.length > 0) {
                        String toolName = (String)ChooseConfigurationPage.this.displayedToolNames.get(ChooseConfigurationPage.this.toolList.getItem(selectedItems[0]));
                        File configJson = new File((String)configs.get(toolName));
                        ChooseConfigurationPage.this.loadConfigurationFromFile(configJson);
                    }
                    ChooseConfigurationPage.this.setPageComplete(true);
                    if (ChooseConfigurationPage.this.pageType.equals("EDIT_COMMON")) {
                        ToolIntegrationWizard wiz = (ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard();
                        wiz.updateAllPages();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        if (this.pageType.equals("EDIT_COMMON")) {
            Button loadConfigButton = new Button(container, 8);
            loadConfigButton.setText(Messages.loadConfigurationButton);
            loadConfigButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    FileDialog dialog = new FileDialog(ChooseConfigurationPage.this.getShell());
                    dialog.setFilterExtensions(new String[]{"*.json"});
                    String file = dialog.open();
                    if (file != null) {
                        File configJson = new File(file);
                        ChooseConfigurationPage.this.loadConfigurationFromFile(configJson);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
        Composite chosenComposite = new Composite(container, 0);
        chosenComposite.setLayout((Layout)new GridLayout(2, false));
        chosenComposite.setLayoutData((Object)new GridData(768));
        new Label(chosenComposite, 0).setText(Messages.selectedConfig);
        this.textChosenConfig = new Text(chosenComposite, 2048);
        this.textChosenConfig.setEditable(false);
        this.textChosenConfig.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ChooseConfigurationPage.this.setPageComplete(ChooseConfigurationPage.this.textChosenConfig.getText() != null && !ChooseConfigurationPage.this.textChosenConfig.getText().equals(""));
            }
        });
        this.textChosenConfig.setLayoutData((Object)new GridData(768));
        this.textChosenConfig.setBackground(Display.getDefault().getSystemColor(1));
        if (this.newIntegrationButton != null) {
            this.newIntegrationButton.setSelection(true);
            this.toolList.setEnabled(false);
            this.textChosenConfig.setEnabled(false);
            this.toolList.setBackground(Display.getDefault().getSystemColor(19));
        }
        this.setControl((Control)container);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        if (this.pageType.equals("NEW_COMMON")) {
            helpSystem.setHelp(this.getControl(), "de.rcenvironment.core.gui.wizard.toolintegration.integration_chooseconfig");
        } else {
            helpSystem.setHelp(this.getControl(), "de.rcenvironment.core.gui.wizard.toolintegration.integration_editconfig");
        }
    }

    private void createInactivePart(Composite container) {
        this.loadInactiveConfigurationButton = new Button(container, 16);
        this.loadInactiveConfigurationButton.setText(Messages.chooseInactiveButton);
        this.loadInactiveConfigurationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.loadInactiveConfigurationButton.getSelection()) {
                    ChooseConfigurationPage.this.setPageComplete(false);
                    ChooseConfigurationPage.this.toolList.setEnabled(true);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(true);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(25));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void createTemplatePart(Composite container) {
        this.loadTemplateButton = new Button(container, 16);
        this.loadTemplateButton.setText(Messages.newConfigurationFromTemplateButton);
        this.loadTemplateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.loadTemplateButton.getSelection()) {
                    ChooseConfigurationPage.this.setPageComplete(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(true);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(true);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(25));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                    ChooseConfigurationPage.this.toolList.setEnabled(false);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        final Map<String, Map<String, Object>> templates = this.readTemplates();
        TemplateListContentProvider templateListContentProvider = new TemplateListContentProvider();
        TemplateListData templateListData = new TemplateListData();
        this.templateListViewer = new ListViewer(container, 2052);
        this.templateListViewer.setContentProvider((IContentProvider)templateListContentProvider);
        this.templateListViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((TemplateListItem)e1).toString().compareTo(((TemplateListItem)e2).toString());
            }
        });
        this.templateListViewer.getControl().setEnabled(false);
        this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
        GridData templateListGridData = new GridData(1808);
        this.templateListViewer.getControl().setLayoutData((Object)templateListGridData);
        for (String templateFileName : templates.keySet()) {
            String integrationType = (String)templates.get(templateFileName).get("integrationType");
            if (integrationType == null) {
                integrationType = "Common";
            }
            TemplateListItem item = new TemplateListItem(templateFileName, integrationType);
            String templateDisplayName = (String)templates.get(templateFileName).get("templateName");
            if (templateDisplayName != null) {
                item.setDisplayName(templateDisplayName);
            }
            templateListData.add(item);
        }
        this.templateListViewer.setInput((Object)templateListData);
        if (this.loadTemplateButton != null && templateListData.getItems().isEmpty()) {
            this.loadTemplateButton.setEnabled(false);
            this.templateListViewer.getControl().setEnabled(false);
        }
        this.templateListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                if (ChooseConfigurationPage.this.templateListViewer.getControl().isEnabled()) {
                    IStructuredSelection selection = (IStructuredSelection)ChooseConfigurationPage.this.templateListViewer.getSelection();
                    if (!selection.isEmpty()) {
                        TemplateListItem item = (TemplateListItem)selection.getFirstElement();
                        for (Map.Entry e : templates.entrySet()) {
                            if (item == null || !((String)e.getKey()).equals(item.getFilename())) continue;
                            ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                            ChooseConfigurationPage.this.wizard.setPreviousConfiguration((Map)e.getValue(), new File((String)e.getKey()));
                            if ((String)((Map)e.getValue()).get("integrationType") != null) {
                                ((ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard()).setIntegrationType((String)((Map)e.getValue()).get("integrationType"), true);
                                ChooseConfigurationPage.this.wizard.setAdditionalPages((String)((Map)e.getValue()).get("integrationType"));
                            } else {
                                ((ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard()).setIntegrationType("Common", true);
                            }
                            if (!ChooseConfigurationPage.this.wizard.getConfigurationMap().containsKey("templateName")) continue;
                            ChooseConfigurationPage.this.wizard.getConfigurationMap().remove("templateName");
                        }
                    }
                    ChooseConfigurationPage.this.setPageComplete(true);
                }
            }
        });
        this.templateListViewer.addDoubleClickListener((IDoubleClickListener)new ToolIntegrationDoubleClickListener(this));
    }

    private Map<String, Map<String, Object>> readTemplates() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (ToolIntegrationContext context : this.allIntegrationContexts) {
            File[] readOnlyList;
            File templateRootPath = new File(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + ToolIntegrationConstants.TEMPLATE_PATH);
            if (!templateRootPath.exists()) {
                templateRootPath.mkdirs();
            }
            this.readTemplateDir(result, templateRootPath);
            File[] fileArray = readOnlyList = context.getReadOnlyPathsList();
            int n = readOnlyList.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                this.readTemplateDir(result, new File(String.valueOf(dir.getAbsolutePath()) + File.separator + ToolIntegrationConstants.TEMPLATE_PATH));
                ++n2;
            }
        }
        return result;
    }

    private void readTemplateDir(Map<String, Map<String, Object>> result, File templateRootPath) {
        if (templateRootPath != null && templateRootPath.listFiles() != null) {
            File[] fileArray = templateRootPath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().endsWith(JSON_SUFFIX)) {
                    try {
                        Map configurationMap = (Map)this.mapper.readValue(f, new HashMap().getClass());
                        result.put(f.getAbsolutePath(), configurationMap);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Integration: Could not read templates: ", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    public void setPageComplete(boolean complete) {
        if (complete && this.pageType.equals("EDIT_COMMON")) {
            complete &= this.textChosenConfig.getText() != null && !this.textChosenConfig.getText().isEmpty();
        } else if (complete && this.pageType.equals("NEW_COMMON") && this.loadInactiveConfigurationButton.getSelection()) {
            complete &= this.textChosenConfig.getText() != null && !this.textChosenConfig.getText().isEmpty();
        } else if (complete && this.pageType.equals("NEW_COMMON") && this.loadTemplateButton.getSelection()) {
            complete &= this.templateListViewer.getSelection() != null && !this.templateListViewer.getSelection().isEmpty();
        }
        super.setPageComplete(complete);
    }

    private void createNewIntegrationPart(Composite container) {
        this.newIntegrationButton = new Button(container, 16);
        this.newIntegrationButton.setText(StringUtils.format((String)Messages.newConfigurationButton, (Object[])new Object[]{"Common"}));
        this.newIntegrationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.newIntegrationButton.getSelection()) {
                    ChooseConfigurationPage.this.textChosenConfig.setText("");
                    HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
                    newConfiguration.put("integrationType", "Common");
                    ChooseConfigurationPage.this.wizard.setPreviousConfiguration(newConfiguration, null);
                    ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                    ChooseConfigurationPage.this.toolList.setEnabled(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                    ChooseConfigurationPage.this.setPageComplete(true);
                    ChooseConfigurationPage.this.wizard.setIntegrationType("Common", false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        for (final ToolIntegrationContext context : this.allIntegrationContexts) {
            if (context.getContextId().equals(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID)) continue;
            final Button newExtensionIntegrationButton = new Button(container, 16);
            newExtensionIntegrationButton.setText(StringUtils.format((String)Messages.newConfigurationButton, (Object[])new Object[]{context.getContextType()}));
            newExtensionIntegrationButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (newExtensionIntegrationButton.getSelection()) {
                        ChooseConfigurationPage.this.textChosenConfig.setText("");
                        HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
                        newConfiguration.put("integrationType", context.getContextType());
                        ChooseConfigurationPage.this.wizard.setPreviousConfiguration(newConfiguration, null);
                        ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                        ChooseConfigurationPage.this.wizard.setAdditionalPages(context.getContextType());
                        ChooseConfigurationPage.this.toolList.setEnabled(false);
                        ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                        ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                        ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                        ChooseConfigurationPage.this.toolList.deselectAll();
                        ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                        ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                        ChooseConfigurationPage.this.setPageComplete(true);
                        ChooseConfigurationPage.this.wizard.setIntegrationType(context.getContextType(), false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
    }

    private void loadConfigurationFromFile(File configJson) {
        if (configJson.exists() && configJson.isFile()) {
            Map configurationMap = null;
            try {
                configurationMap = (Map)this.mapper.readValue(configJson, new HashMap().getClass());
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            if (configurationMap != null) {
                this.textChosenConfig.setText(configJson.getAbsolutePath());
            } else {
                this.textChosenConfig.setText("");
            }
            this.wizard.setPreviousConfiguration(configurationMap, configJson);
            this.wizard.removeAdditionalPages();
            if (configurationMap != null) {
                this.wizard.setAdditionalPages((String)configurationMap.get("integrationType"));
            }
        } else {
            this.wizard.setPreviousConfiguration(null, null);
            this.wizard.removeAdditionalPages();
        }
    }

    private Map<String, String> readExistingConfigurations(String type) {
        TreeMap<String, String> allConfigs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ToolIntegrationContext context : this.allIntegrationContexts) {
            String configFolder = context.getRootPathToToolIntegrationDirectory();
            File toolIntegrationFile = new File(configFolder, context.getNameOfToolIntegrationDirectory());
            if (!toolIntegrationFile.exists() || !toolIntegrationFile.isDirectory() || toolIntegrationFile.listFiles() == null || toolIntegrationFile.listFiles().length <= 0) continue;
            File[] fileArray = toolIntegrationFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f;
                File toolFolder = fileArray[n2];
                if (toolFolder != null && toolFolder.isDirectory() && !toolFolder.getName().equals("null") && toolFolder.listFiles() != null && toolFolder.listFiles().length > 0 && (f = this.tryFindConfigurationFile(context, toolFolder)) != null) {
                    try {
                        Map configurationMap = (Map)this.mapper.readValue(f, new HashMap().getClass());
                        if (type.equals("NEW_COMMON") && configurationMap.get("isActive") != null && !((Boolean)configurationMap.get("isActive")).booleanValue()) {
                            allConfigs.put((String)configurationMap.get("toolName"), f.getAbsolutePath());
                        } else if (!type.equals("NEW_COMMON") && configurationMap.get("isActive") != null && ((Boolean)configurationMap.get("isActive")).booleanValue()) {
                            allConfigs.put((String)configurationMap.get("toolName"), f.getAbsolutePath());
                        }
                        this.allConfigurations.put((String)configurationMap.get("toolName"), configurationMap);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Could not read configuration file: ", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return allConfigs;
    }

    private File tryFindConfigurationFile(ToolIntegrationContext context, File toolFolder) {
        File[] fileArray = toolFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals(context.getConfigurationFilename())) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public String getChoosenConfigPath() {
        return this.textChosenConfig.getText();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        if (this.pageType.equals("NEW_COMMON")) {
            helpSystem.displayHelp("de.rcenvironment.core.gui.wizard.toolintegration.integration_chooseconfig");
        } else {
            helpSystem.displayHelp("de.rcenvironment.core.gui.wizard.toolintegration.integration_editconfig");
        }
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
    }

    @Override
    public void updatePage() {
        if (this.pageType.equals("EDIT_COMMON") && this.isCurrentPage() && (this.textChosenConfig.getText() == null || this.textChosenConfig.getText().isEmpty())) {
            this.setPageComplete(false);
        }
    }

    public void showPage(IWizardPage iWizardPage) {
        this.getContainer().showPage(iWizardPage);
    }

    public String createDisplayedToolName(String toolName) {
        String groupName;
        String type = "Common";
        if (this.allConfigurations.get(toolName).get("integrationType") != null) {
            type = (String)this.allConfigurations.get(toolName).get("integrationType");
        }
        ArrayList launchSettings = (ArrayList)this.allConfigurations.get(toolName).get("launchSettings");
        String version = (String)((LinkedHashMap)launchSettings.get(0)).get("version");
        Object[] toolInformation = new Object[]{toolName, version, type};
        String displayedToolName = StringUtils.format((String)"%s (%s; Type: %s)", (Object[])toolInformation);
        boolean disabled = false;
        StringBuilder errorString = new StringBuilder();
        if (ComponentIdRules.validateComponentIdRules((String)toolName).isPresent()) {
            errorString.append(" [INVALID TOOL NAME]");
            disabled = true;
        }
        if (ComponentIdRules.validateComponentVersionRules((String)version).isPresent()) {
            errorString.append(" [INVALID VERSION]");
            disabled = true;
        }
        if (this.allConfigurations.get(toolName).get("groupName") != null && !(groupName = (String)this.allConfigurations.get(toolName).get("groupName")).isEmpty() && ComponentIdRules.validateComponentGroupNameRules((String)groupName).isPresent()) {
            errorString.append(" [INVALID GROUP NAME]");
            disabled = true;
        }
        if (disabled) {
            displayedToolName = StringUtils.format((String)"%s%s - DISABLED", (Object[])new Object[]{displayedToolName, errorString.toString()});
        }
        return displayedToolName;
    }
}

