/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.channel.MessageChannelTrafficListener;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestNetworkTrafficListener
implements MessageChannelTrafficListener {
    private long lastTrafficTimestamp = 0L;
    private long requestCount;
    private long lsaMessages = 0L;
    private long routedMessages = 0L;
    private long largestObservedHopCount = 0L;
    private long unsuccessfulResponses = 0L;
    private Semaphore trafficOccured = new Semaphore(0);

    @Override
    public void onRequestSentIntoChannel(NetworkRequest request) {
        this.onTraffic(true);
    }

    @Override
    public void onRequestReceivedFromChannel(NetworkRequest request, InstanceNodeSessionId sourceId) {
        this.onTraffic(false);
    }

    @Override
    public void onResponseSentIntoChannel(NetworkResponse response, NetworkRequest request, InstanceNodeSessionId sourceId) {
        this.onTraffic(false);
    }

    private synchronized void onTraffic(boolean isRequest) {
        this.lastTrafficTimestamp = System.currentTimeMillis();
        if (isRequest) {
            ++this.requestCount;
            this.trafficOccured.release();
        }
    }

    public synchronized long getRequestCount() {
        return this.requestCount;
    }

    public synchronized long getLastTrafficTimestamp() {
        return this.lastTrafficTimestamp;
    }

    public synchronized void clearCustomTrafficFlag() {
        this.trafficOccured.drainPermits();
    }

    public void waitForCustomTrafficFlag(int maxWait) throws TimeoutException, InterruptedException {
        if (!this.trafficOccured.tryAcquire(maxWait, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Maximum wait time for custom traffic flag (" + maxWait + " msec) exceeded");
        }
    }

    public void waitForNetworkSilence(int minSilenceTime, int maxWait) throws TimeoutException, InterruptedException {
        int pollInterval = minSilenceTime / 2;
        int totalWait = 0;
        while (true) {
            if (totalWait > maxWait) {
                throw new TimeoutException("Maximum wait time for network silence (" + maxWait + " msec) exceeded");
            }
            if (System.currentTimeMillis() - this.getLastTrafficTimestamp() >= (long)minSilenceTime) {
                return;
            }
            Thread.sleep(pollInterval);
            totalWait += pollInterval;
        }
    }

    public long getLsaMessages() {
        return this.lsaMessages;
    }

    public long getLargestObservedHopCount() {
        return this.largestObservedHopCount;
    }

    public long getUnsuccessfulResponses() {
        return this.unsuccessfulResponses;
    }

    public long getRoutedMessages() {
        return this.routedMessages;
    }

    public String getFormattedTrafficReport(int topologySize) {
        if (topologySize <= 0) {
            throw new IllegalArgumentException("Argument must be >=1");
        }
        return StringUtils.format((String)"Total requests sent:                %d\nAverage requests sent per node:     %d\nTotal LSA messages sent:            %d\nAverage LSA messages sent per node: %d\nTotal routed messages sent:         %d\nLargest observed hop count:         %d (%d)\nUnsuccessful responses received:    %d\n", (Object[])new Object[]{this.getRequestCount(), this.getRequestCount() / (long)topologySize, this.getLsaMessages(), this.getLsaMessages() / (long)topologySize, this.getRoutedMessages(), this.getLargestObservedHopCount(), topologySize, this.getUnsuccessfulResponses()});
    }
}

