/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupListener;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListener;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListenerAdapter;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.DistributedNodeComponentKnowledge;
import de.rcenvironment.core.component.internal.DistributedNodeComponentKnowledgeImpl;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.DistributedComponentEntryType;
import de.rcenvironment.core.component.management.internal.ComponentDataConverter;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class DistributedComponentKnowledgeServiceImpl
implements DistributedComponentKnowledgeService,
AdditionalServicesProvider {
    private static final String SINGLE_INSTALLATION_PROPERTY_PREFIX = "componentInstallation/";
    private NodePropertiesService nodePropertiesService;
    private final AsyncOrderedCallbackManager<DistributedComponentKnowledgeListener> componentKnowledgeCallbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private volatile DistributedComponentKnowledgeSnapshot currentSnapshot;
    private Map<String, DistributedNodeComponentKnowledge> mutableMapOfRemoteEntriesForNextSnapshot = new HashMap<String, DistributedNodeComponentKnowledge>();
    private Map<String, NodeProperty> knownComponentNodeProperties = new HashMap<String, NodeProperty>();
    private Map<String, String> lastPublishedProperties = new HashMap<String, String>();
    private final Object internalStateLock = new Object();
    private InstanceNodeSessionId localInstanceSessionId;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());
    private AuthorizationService authorizationService;

    public DistributedComponentKnowledgeServiceImpl() {
        this.addDistributedComponentKnowledgeListener(newState -> {
            if (this.verboseLogging) {
                this.log.debug((Object)("Component knowledge updated: " + newState));
            }
        });
    }

    protected DistributedComponentKnowledgeServiceImpl(InstanceNodeSessionId nodeSessionId) {
        this();
        this.localInstanceSessionId = nodeSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate() {
        Object object = this.internalStateLock;
        synchronized (object) {
            this.setNewSnapshot(new DistributedComponentKnowledgeSnapshot(this.localInstanceSessionId));
        }
    }

    @Reference(unbind="unbindObjectBindingsService")
    protected void bindObjectBindingsService(ObjectBindingsService objectBindingsService) {
        objectBindingsService.addBinding(AuthorizationAccessGroupListener.class, accessGroups -> {
            Object object = this.internalStateLock;
            synchronized (object) {
                this.updateOnReachableNodePropertiesChanged(new ArrayList(), new ArrayList<NodeProperty>(this.knownComponentNodeProperties.values()), new ArrayList(), false);
            }
        }, (Object)this);
    }

    protected void unbindObjectBindingsService(ObjectBindingsService objectBindingsService) {
        objectBindingsService.removeAllBindingsOfOwner((Object)this);
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> listenerDeclarations = new ArrayList<AdditionalServiceDeclaration>();
        listenerDeclarations.add(new AdditionalServiceDeclaration(NodePropertiesChangeListener.class, (Object)new NodePropertiesChangeListenerAdapter(){

            public void onReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties) {
                DistributedComponentKnowledgeServiceImpl.this.updateOnReachableNodePropertiesChanged(addedProperties, updatedProperties, removedProperties, true);
            }
        }));
        return listenerDeclarations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLocalComponentInstallations(Collection<DistributedComponentEntry> allLocalInstallations, boolean publicationEnabled) {
        HashMap<String, String> propertiesDelta = new HashMap<String, String>();
        Object object = this.internalStateLock;
        synchronized (object) {
            if (!publicationEnabled && !allLocalInstallations.isEmpty()) {
                this.log.debug((Object)"Not publishing local component information yet (usually as part of the startup process)");
                return;
            }
            DistributedComponentKnowledgeSnapshot newSnapshot = this.currentSnapshot.updateWithNewLocalInstallations(allLocalInstallations, publicationEnabled);
            this.setNewSnapshot(newSnapshot);
            TreeSet<String> uniqueIds = new TreeSet<String>();
            for (DistributedComponentEntry distributedComponentEntry : newSnapshot.getSharedAccessInstallations()) {
                ComponentInstallation installation = distributedComponentEntry.getComponentInstallation();
                if (distributedComponentEntry.getType() != DistributedComponentEntryType.SHARED) continue;
                String uniqueId = installation.getInstallationId();
                uniqueIds.add(SINGLE_INSTALLATION_PROPERTY_PREFIX + uniqueId);
                String serializedEntryData = distributedComponentEntry.getPublicationData();
                if (serializedEntryData == null) {
                    this.log.error((Object)("Skipping component publishing of " + uniqueId + " as it was not properly serialized"));
                    continue;
                }
                String propertyId = SINGLE_INSTALLATION_PROPERTY_PREFIX + uniqueId;
                if (serializedEntryData.equals(this.lastPublishedProperties.get(propertyId))) continue;
                this.log.debug((Object)("Publishing component descriptor " + uniqueId));
                propertiesDelta.put(propertyId, serializedEntryData);
            }
            for (Map.Entry entry : this.lastPublishedProperties.entrySet()) {
                if (uniqueIds.contains(entry.getKey()) || entry.getValue() == null) continue;
                this.log.debug((Object)("Unpublishing component id " + (String)entry.getKey()));
                propertiesDelta.put((String)entry.getKey(), null);
            }
        }
        if (!propertiesDelta.isEmpty()) {
            this.lastPublishedProperties.putAll(propertiesDelta);
            this.nodePropertiesService.addOrUpdateLocalNodeProperties(propertiesDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributedComponentKnowledge getCurrentSnapshot() {
        Object object = this.internalStateLock;
        synchronized (object) {
            return this.currentSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties, boolean isActualRemoteUpdate) {
        boolean modified = false;
        Object object = this.internalStateLock;
        synchronized (object) {
            for (NodeProperty nodeProperty : addedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Parsing new component installation property: " + nodeProperty));
                }
                if (!isActualRemoteUpdate) {
                    throw new IllegalStateException();
                }
                this.knownComponentNodeProperties.put(nodeProperty.getDistributedUniqueKey(), nodeProperty);
                boolean bl = modified = this.processAddedOrUpdatedProperty(nodeProperty, false) || modified;
            }
            for (NodeProperty nodeProperty : updatedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Parsing updated component installation property: " + nodeProperty));
                }
                if (isActualRemoteUpdate) {
                    this.knownComponentNodeProperties.put(nodeProperty.getDistributedUniqueKey(), nodeProperty);
                }
                boolean bl = modified = this.processAddedOrUpdatedProperty(nodeProperty, true) || modified;
            }
            for (NodeProperty nodeProperty : removedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Removing disconnected component installation property: " + nodeProperty));
                }
                if (!isActualRemoteUpdate) {
                    throw new IllegalStateException();
                }
                this.knownComponentNodeProperties.remove(nodeProperty.getDistributedUniqueKey());
                boolean bl = modified = this.processRemovedProperty(nodeProperty) || modified;
            }
            if (modified) {
                DistributedComponentKnowledgeSnapshot distributedComponentKnowledgeSnapshot = this.currentSnapshot.updateWithNewRemoteEntryMap(this.mutableMapOfRemoteEntriesForNextSnapshot);
                this.setNewSnapshot(distributedComponentKnowledgeSnapshot);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeDistributedComponentKnowledgeListener")
    protected void addDistributedComponentKnowledgeListener(DistributedComponentKnowledgeListener listener) {
        DistributedComponentKnowledgeSnapshot knowledgeAtRegistrationTime = this.currentSnapshot;
        this.componentKnowledgeCallbackManager.addListenerAndEnqueueCallback((Object)listener, knowledgeListener -> knowledgeListener.onDistributedComponentKnowledgeChanged(knowledgeAtRegistrationTime));
    }

    protected void removeDistributedComponentKnowledgeListener(DistributedComponentKnowledgeListener listener) {
        this.componentKnowledgeCallbackManager.removeListener((Object)listener);
    }

    @Reference
    protected void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    @Reference
    protected void bindNodeConfigurationService(NodeConfigurationService newInstance) {
        this.localInstanceSessionId = newInstance.getInstanceNodeSessionId();
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
    }

    private boolean processAddedOrUpdatedProperty(NodeProperty property, boolean isUpdate) {
        boolean componentInstallationValid;
        DistributedComponentEntry newEntry;
        InstanceNodeSessionId sourceNodeId = property.getInstanceNodeSessionId();
        if (sourceNodeId.equals(this.localInstanceSessionId)) {
            return false;
        }
        String propertyKey = property.getKey().substring(SINGLE_INSTALLATION_PROPERTY_PREFIX.length());
        String jsonData = property.getValue();
        try {
            newEntry = ComponentDataConverter.deserializeRemoteDistributedComponentEntry(jsonData, this.authorizationService);
        }
        catch (OperationFailureException operationFailureException) {
            this.log.warn((Object)("Ignoring invalid component installation entry published by " + sourceNodeId + ": " + jsonData));
            return false;
        }
        boolean newEntryIsAccessible = newEntry.isAccessible();
        if (newEntryIsAccessible && !(componentInstallationValid = this.validateDistributedComponentEntry(newEntry, sourceNodeId))) {
            return false;
        }
        String remoteNodeKey = sourceNodeId.getInstanceNodeIdString();
        DistributedNodeComponentKnowledge nodeState = this.mutableMapOfRemoteEntriesForNextSnapshot.getOrDefault(remoteNodeKey, DistributedNodeComponentKnowledgeImpl.createEmpty());
        DistributedComponentEntry previousEntry = nodeState.getComponent(propertyKey);
        if (newEntryIsAccessible) {
            boolean previousEntryExists;
            this.mutableMapOfRemoteEntriesForNextSnapshot.put(remoteNodeKey, nodeState.putAccessibleComponent(propertyKey, newEntry));
            boolean bl = previousEntryExists = previousEntry != null;
            if (isUpdate && !previousEntryExists) {
                this.log.debug((Object)("Added a new local entry for remote component id " + propertyKey + " after a remote node property update; typically, this is because local or remote " + "authorization settings have changed, and now allow access to this component"));
            } else if (!isUpdate && previousEntryExists) {
                this.log.warn((Object)("Unexpected state: received a new property, but there was a previously registered component already; key=" + propertyKey));
            }
        } else {
            boolean wasPreviouslyAccessible;
            this.mutableMapOfRemoteEntriesForNextSnapshot.put(remoteNodeKey, nodeState.putInaccessibleComponent(propertyKey, newEntry));
            boolean bl = wasPreviouslyAccessible = nodeState.componentExists(propertyKey) && nodeState.isComponentAccessible(propertyKey);
            if (wasPreviouslyAccessible) {
                this.log.debug((Object)("Removing remote component entry " + propertyKey + " from " + sourceNodeId + " as there is no matching local access group anymore; authorized remote access groups are: " + newEntry.getDeclaredPermissionSet()));
            } else {
                this.log.debug((Object)("Ignoring remote component entry " + propertyKey + " from " + sourceNodeId + " as there is no local authorized group matching its access groups " + newEntry.getDeclaredPermissionSet()));
            }
        }
        return true;
    }

    private boolean validateDistributedComponentEntry(DistributedComponentEntry newEntry, InstanceNodeSessionId sourceNodeId) {
        ComponentInstallation componentInstallation = newEntry.getComponentInstallation();
        Optional<String> componentInstallationError = this.validateComponentInstallation(componentInstallation, sourceNodeId);
        if (componentInstallationError.isPresent()) {
            this.log.error((Object)("Ignoring invalid component installation entry: " + componentInstallationError.get()));
            return false;
        }
        Optional<String> idValidationError = ComponentIdRules.validateComponentInterfaceIds(componentInstallation.getComponentInterface());
        if (idValidationError.isPresent()) {
            this.log.error((Object)StringUtils.format((String)"Ignoring invalid component installation %s published by node %s as it contains an invalid id: %s", (Object[])new Object[]{componentInstallation.getInstallationId(), sourceNodeId, idValidationError.get()}));
            return false;
        }
        String componentDescriptionId = componentInstallation.getComponentInterface().getIdentifierAndVersion();
        this.log.debug((Object)("Successfully parsed component installation published by " + sourceNodeId + ": " + componentDescriptionId));
        return true;
    }

    private Optional<String> validateComponentInstallation(ComponentInstallation componentInstallation, InstanceNodeSessionId sourceNodeId) {
        LogicalNodeId declaredNodeIdObject = componentInstallation.getNodeIdObject();
        if (!declaredNodeIdObject.isSameInstanceNodeAs((ResolvableNodeId)sourceNodeId)) {
            return Optional.of("published by node " + sourceNodeId + ", but allegedly installed on node " + componentInstallation.getNodeId());
        }
        if (componentInstallation.getComponentRevision() == null) {
            return Optional.of("'null' component revision");
        }
        if (componentInstallation.getComponentInterface() == null) {
            return Optional.of("'null' component interface");
        }
        if (componentInstallation.getComponentInterface().getIdentifierAndVersion() == null) {
            return Optional.of("'null' component interface id");
        }
        return Optional.empty();
    }

    private boolean processRemovedProperty(NodeProperty property) {
        InstanceNodeSessionId sourceNodeId = property.getInstanceNodeSessionId();
        String remoteNodeKey = sourceNodeId.getInstanceNodeIdString();
        DistributedNodeComponentKnowledge nodeState = this.mutableMapOfRemoteEntriesForNextSnapshot.get(remoteNodeKey);
        if (nodeState == null) {
            return false;
        }
        String propertyKey = property.getKey().substring(SINGLE_INSTALLATION_PROPERTY_PREFIX.length());
        if (!nodeState.componentExists(propertyKey)) {
            return false;
        }
        this.mutableMapOfRemoteEntriesForNextSnapshot.put(remoteNodeKey, nodeState.removeComponent(propertyKey));
        this.log.debug((Object)("Successfully removed a component installation previously published by " + sourceNodeId + " (key: " + propertyKey + ")"));
        return true;
    }

    private boolean isComponentInstallationProperty(NodeProperty property) {
        return property.getKey().startsWith(SINGLE_INSTALLATION_PROPERTY_PREFIX);
    }

    private void setNewSnapshot(DistributedComponentKnowledgeSnapshot newSnapshot) {
        this.currentSnapshot = newSnapshot;
        this.mutableMapOfRemoteEntriesForNextSnapshot = new HashMap<String, DistributedNodeComponentKnowledge>(newSnapshot.remoteEntriesByNodeId);
        this.componentKnowledgeCallbackManager.enqueueCallback(listener -> listener.onDistributedComponentKnowledgeChanged(newSnapshot));
    }

    private static final class DistributedComponentKnowledgeSnapshot
    implements DistributedComponentKnowledge {
        private final Collection<DistributedComponentEntry> allLocalEntries;
        private final Collection<DistributedComponentEntry> localAccessEntries;
        private final Collection<DistributedComponentEntry> sharedAccessEntries;
        private final Collection<DistributedComponentEntry> remoteEntries;
        private final Map<String, DistributedNodeComponentKnowledge> remoteEntriesByNodeId;
        private final InstanceNodeSessionId localInstanceSessionId;

        private DistributedComponentKnowledgeSnapshot(InstanceNodeSessionId localInstanceSessionIdParam, Collection<DistributedComponentEntry> allLocalEntriesParam, Collection<DistributedComponentEntry> localAccessEntriesParam, Collection<DistributedComponentEntry> sharedAccessEntriesParam, Collection<DistributedComponentEntry> remoteEntriesParam, Map<String, DistributedNodeComponentKnowledge> remoteEntriesByNodeIdParam) {
            this.localInstanceSessionId = localInstanceSessionIdParam;
            this.allLocalEntries = Collections.unmodifiableCollection(allLocalEntriesParam);
            this.localAccessEntries = Collections.unmodifiableCollection(localAccessEntriesParam);
            this.sharedAccessEntries = Collections.unmodifiableCollection(sharedAccessEntriesParam);
            this.remoteEntries = Collections.unmodifiableCollection(remoteEntriesParam);
            this.remoteEntriesByNodeId = Collections.unmodifiableMap(remoteEntriesByNodeIdParam);
        }

        private DistributedComponentKnowledgeSnapshot(InstanceNodeSessionId localInstanceSessionIdParam) {
            this(localInstanceSessionIdParam, new ArrayList<DistributedComponentEntry>(), new ArrayList<DistributedComponentEntry>(), new ArrayList<DistributedComponentEntry>(), new ArrayList<DistributedComponentEntry>(), new HashMap<String, DistributedNodeComponentKnowledge>());
        }

        public DistributedComponentKnowledgeSnapshot updateWithNewLocalInstallations(Collection<DistributedComponentEntry> allLocalInstallationsParam, boolean publicationEnabled) {
            ArrayList<DistributedComponentEntry> allLocalInstallations = new ArrayList<DistributedComponentEntry>(allLocalInstallationsParam);
            ArrayList<DistributedComponentEntry> tempLocalAccessEntries = new ArrayList<DistributedComponentEntry>();
            ArrayList<DistributedComponentEntry> tempLocalSharedAccessEntries = new ArrayList<DistributedComponentEntry>();
            for (DistributedComponentEntry e : allLocalInstallations) {
                switch (e.getType()) {
                    case LOCAL: 
                    case FORCED_LOCAL: {
                        tempLocalAccessEntries.add(e);
                        break;
                    }
                    case SHARED: {
                        if (publicationEnabled) {
                            tempLocalSharedAccessEntries.add(e);
                            break;
                        }
                        tempLocalAccessEntries.add(e);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            return new DistributedComponentKnowledgeSnapshot(this.localInstanceSessionId, allLocalInstallations, tempLocalAccessEntries, tempLocalSharedAccessEntries, this.remoteEntries, this.remoteEntriesByNodeId);
        }

        public DistributedComponentKnowledgeSnapshot updateWithNewRemoteEntryMap(Map<String, DistributedNodeComponentKnowledge> newMapOfRemoteEntries) {
            ArrayList<DistributedComponentEntry> tempListOfRemoteEntries = new ArrayList<DistributedComponentEntry>();
            for (DistributedNodeComponentKnowledge nodeMap : newMapOfRemoteEntries.values()) {
                tempListOfRemoteEntries.addAll(nodeMap.getAccessibleComponents());
            }
            return new DistributedComponentKnowledgeSnapshot(this.localInstanceSessionId, this.allLocalEntries, this.localAccessEntries, this.sharedAccessEntries, tempListOfRemoteEntries, newMapOfRemoteEntries);
        }

        @Override
        public Collection<DistributedComponentEntry> getKnownSharedInstallationsOnNode(ResolvableNodeId nodeId, boolean includeInaccessible) {
            if (nodeId.isSameInstanceNodeAs((ResolvableNodeId)this.localInstanceSessionId)) {
                return this.sharedAccessEntries;
            }
            DistributedNodeComponentKnowledge remoteEntriesOfNode = this.remoteEntriesByNodeId.get(nodeId.getInstanceNodeIdString());
            if (remoteEntriesOfNode == null) {
                return new ArrayList<DistributedComponentEntry>();
            }
            ArrayList<DistributedComponentEntry> returnValue = new ArrayList<DistributedComponentEntry>();
            returnValue.addAll(remoteEntriesOfNode.getAccessibleComponents());
            if (includeInaccessible) {
                returnValue.addAll(remoteEntriesOfNode.getInaccessibleComponents());
            }
            return returnValue;
        }

        @Override
        public Collection<DistributedComponentEntry> getKnownSharedInstallations() {
            ArrayList<DistributedComponentEntry> allInstallations = new ArrayList<DistributedComponentEntry>(this.remoteEntries.size() + this.sharedAccessEntries.size());
            allInstallations.addAll(this.remoteEntries);
            allInstallations.addAll(this.sharedAccessEntries);
            return allInstallations;
        }

        @Override
        public Collection<DistributedComponentEntry> getAllLocalInstallations() {
            return this.allLocalEntries;
        }

        @Override
        public Collection<DistributedComponentEntry> getLocalAccessInstallations() {
            return this.localAccessEntries;
        }

        @Override
        public Collection<DistributedComponentEntry> getSharedAccessInstallations() {
            return this.sharedAccessEntries;
        }

        @Override
        public Collection<DistributedComponentEntry> getAllInstallations() {
            ArrayList<DistributedComponentEntry> allInstallations = new ArrayList<DistributedComponentEntry>(this.remoteEntries.size() + this.allLocalEntries.size());
            allInstallations.addAll(this.remoteEntries);
            allInstallations.addAll(this.allLocalEntries);
            return allInstallations;
        }

        public String toString() {
            return "Local: " + this.allLocalEntries + ", Remote: " + this.remoteEntriesByNodeId;
        }
    }
}

