/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.internal.ScpCommandWrapper;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshCommandHandler;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;

public class CustomSshCommandFactory
implements Factory<Command>,
CommandFactory {
    private CommandExecutionService commandExecutionService;
    private SshAuthenticationManager authenticationManager;
    private ScpContextManager scpContextManager;
    private SshConfiguration sshConfiguration;

    public CustomSshCommandFactory(SshAuthenticationManager authenticationManager, ScpContextManager scpContextManager, CommandExecutionService commandExecutionService, SshConfiguration sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
        this.authenticationManager = authenticationManager;
        this.scpContextManager = scpContextManager;
        this.commandExecutionService = commandExecutionService;
    }

    public Command create() {
        return this.createCommand(null);
    }

    public Command createCommand(String command) {
        Command result = null;
        result = command != null && command.trim().startsWith("scp") ? new ScpCommandWrapper(command, this.scpContextManager) : new SshCommandHandler(command, this.authenticationManager, this.commandExecutionService, this.sshConfiguration);
        return result;
    }
}

