/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor.testutils;

import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IntegrationTestExecutorUtils {
    private final File workingDir;

    public IntegrationTestExecutorUtils(File workingDir) {
        this.workingDir = workingDir;
    }

    public ExecutionResult executeAndWait(String command) throws IOException, InterruptedException {
        LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(this.workingDir);
        executor.start(command);
        CapturingTextOutReceiver stdoutCapture = new CapturingTextOutReceiver();
        CapturingTextOutReceiver stderrCapture = new CapturingTextOutReceiver();
        TextStreamWatcher stdoutWatcher = TextStreamWatcherFactory.create((InputStream)executor.getStdout(), (TextOutputReceiver[])new TextOutputReceiver[]{stdoutCapture}).start();
        TextStreamWatcher stderrWatcher = TextStreamWatcherFactory.create((InputStream)executor.getStderr(), (TextOutputReceiver[])new TextOutputReceiver[]{stderrCapture}).start();
        int exitCode = executor.waitForTermination();
        stdoutWatcher.waitForTermination();
        stderrWatcher.waitForTermination();
        return new ExecutionResult(exitCode, stdoutCapture.getBufferedOutput(), stderrCapture.getBufferedOutput());
    }

    public static class ExecutionResult {
        private static final int INITIAL_STRING_CONTAINER_SIZE = 64;
        public final int exitCode;
        public final String stdout;
        public final List<String> stdoutLines;
        public final List<String> filteredStdoutLines;
        public final String stderr;
        public final List<String> stderrLines;
        public final List<String> filteredStderrLines;

        public ExecutionResult(int exitCode, String stdout, String stderr) throws IOException {
            this(exitCode, stdout, stderr, null);
        }

        public ExecutionResult(int exitCode, String stdout, String stderr, LineFilter lineFilter) throws IOException {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
            this.stdoutLines = this.parseIntoLines(stdout);
            this.stderrLines = this.parseIntoLines(stderr);
            if (lineFilter != null) {
                this.filteredStdoutLines = this.filterLines(this.stdoutLines, lineFilter);
                this.filteredStderrLines = this.filterLines(this.stderrLines, lineFilter);
            } else {
                this.filteredStdoutLines = this.stdoutLines;
                this.filteredStderrLines = this.stderrLines;
            }
        }

        private ExecutionResult(int exitCode, String stdout, String stderr, List<String> stdoutLines, List<String> stderrLines, LineFilter lineFilter) throws IOException {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
            this.stdoutLines = stdoutLines;
            this.stderrLines = stderrLines;
            if (lineFilter != null) {
                this.filteredStdoutLines = this.filterLines(stdoutLines, lineFilter);
                this.filteredStderrLines = this.filterLines(stderrLines, lineFilter);
            } else {
                this.filteredStdoutLines = null;
                this.filteredStderrLines = null;
            }
        }

        public ExecutionResult applyLineFilter(LineFilter lineFilter) {
            try {
                return new ExecutionResult(this.exitCode, this.stdout, this.stderr, this.stdoutLines, this.stderrLines, lineFilter);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception while re-filtering", e);
            }
        }

        private List<String> parseIntoLines(String rawOutput) throws IOException {
            String line;
            ArrayList<String> container = new ArrayList<String>(64);
            BufferedReader reader = new BufferedReader(new StringReader(rawOutput));
            while ((line = reader.readLine()) != null) {
                container.add(line);
            }
            return Collections.unmodifiableList(container);
        }

        private List<String> filterLines(List<String> input, LineFilter lineFilter) {
            ArrayList<String> container = new ArrayList<String>(64);
            for (String line : input) {
                if (!lineFilter.accept(line)) continue;
                container.add(line);
            }
            return Collections.unmodifiableList(container);
        }
    }

    public static interface LineFilter {
        public boolean accept(String var1);
    }
}

