/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.terminal.swing.TerminalPalette;
import java.awt.Font;
import java.awt.image.BufferedImage;

public class TerminalAppearance {
    public static final Font DEFAULT_NORMAL_FONT = TerminalAppearance.createDefaultNormalFont();
    public static final Font DEFAULT_BOLD_FONT = TerminalAppearance.createDefaultBoldFont();
    public static final TerminalAppearance DEFAULT_APPEARANCE = new TerminalAppearance(DEFAULT_NORMAL_FONT, DEFAULT_BOLD_FONT, TerminalPalette.DEFAULT, true);
    private final Font normalTextFont;
    private final Font boldTextFont;
    private final Font cjkFont;
    private final TerminalPalette colorPalette;
    private final boolean useBrightColorsOnBold;

    private static Font createDefaultNormalFont() {
        if (System.getProperty("os.name", "").toLowerCase().indexOf("win") >= 0) {
            return new Font("Courier New", 0, 14);
        }
        return new Font("Monospaced", 0, 14);
    }

    private static Font createDefaultBoldFont() {
        if (System.getProperty("os.name", "").toLowerCase().indexOf("win") >= 0) {
            return new Font("Courier New", 1, 14);
        }
        return new Font("Monospaced", 1, 14);
    }

    public TerminalAppearance(Font normalTextFont, Font boldTextFont, TerminalPalette colorPalette, boolean useBrightColorsOnBold) {
        this.normalTextFont = normalTextFont;
        this.boldTextFont = boldTextFont;
        this.colorPalette = colorPalette;
        this.useBrightColorsOnBold = useBrightColorsOnBold;
        this.cjkFont = this.deriveCJKFont('\u685c');
    }

    private Font deriveCJKFont(char character) {
        int startSize;
        BufferedImage bi = new BufferedImage(5, 5, 1);
        int targetWidth = bi.getGraphics().getFontMetrics(this.normalTextFont).charWidth('W');
        for (int size = startSize = this.normalTextFont.getSize(); size > 0; --size) {
            Font font = new Font("Monospaced", 0, size);
            int characterWidth = bi.getGraphics().getFontMetrics(font).charWidth(character);
            if (characterWidth > targetWidth) continue;
            return font;
        }
        return this.normalTextFont;
    }

    public Font getNormalTextFont() {
        return this.normalTextFont;
    }

    public Font getBoldTextFont() {
        return this.boldTextFont;
    }

    public Font getCJKFont() {
        return this.cjkFont;
    }

    public TerminalPalette getColorPalette() {
        return this.colorPalette;
    }

    public boolean useBrightColorsOnBold() {
        return this.useBrightColorsOnBold;
    }

    public TerminalAppearance withFont(Font textFont) {
        return this.withFont(textFont, textFont);
    }

    public TerminalAppearance withFont(Font normalTextFont, Font boldTextFont) {
        return new TerminalAppearance(normalTextFont, boldTextFont, this.colorPalette, this.useBrightColorsOnBold);
    }

    public TerminalAppearance withPalette(TerminalPalette palette) {
        return new TerminalAppearance(this.normalTextFont, this.boldTextFont, palette, this.useBrightColorsOnBold);
    }

    public TerminalAppearance withUseBrightColors(boolean useBrightColorsOnBold) {
        return new TerminalAppearance(this.normalTextFont, this.boldTextFont, this.colorPalette, useBrightColorsOnBold);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalAppearance other = (TerminalAppearance)obj;
        if (!(this.normalTextFont == other.normalTextFont || this.normalTextFont != null && this.normalTextFont.equals(other.normalTextFont))) {
            return false;
        }
        if (!(this.boldTextFont == other.boldTextFont || this.boldTextFont != null && this.boldTextFont.equals(other.boldTextFont))) {
            return false;
        }
        if (!(this.colorPalette == other.colorPalette || this.colorPalette != null && this.colorPalette.equals(other.colorPalette))) {
            return false;
        }
        return this.useBrightColorsOnBold == other.useBrightColorsOnBold;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.normalTextFont != null ? this.normalTextFont.hashCode() : 0);
        hash = 37 * hash + (this.boldTextFont != null ? this.boldTextFont.hashCode() : 0);
        hash = 37 * hash + (this.colorPalette != null ? this.colorPalette.hashCode() : 0);
        hash = 37 * hash + (this.useBrightColorsOnBold ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "TerminalAppearance{normalTextFont=" + this.normalTextFont + ", boldTextFont=" + this.boldTextFont + ", colorPalette=" + this.colorPalette + ", useBrightColorsOnBold=" + this.useBrightColorsOnBold + '}';
    }
}

