/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.xml.impl;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.XMLMapperConstants;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Document;

public class EndpointXMLServiceImpl
implements EndpointXMLService {
    private String recentXpath = "";
    private XMLSupportService xmlSupport;

    public void bindXMLSupportService(XMLSupportService service) {
        this.xmlSupport = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateXMLWithInputs(File xmlFile, Map<String, TypedDatum> dynamicInputs, ComponentContext componentContext) throws DataTypeException, ComponentException {
        if (dynamicInputs.isEmpty()) {
            return;
        }
        if (!xmlFile.exists()) {
            throw new ComponentException(String.valueOf(xmlFile.getAbsolutePath()) + " does not exist");
        }
        Object object = XMLMapperConstants.GLOBAL_MAPPING_LOCK;
        synchronized (object) {
            Document doc;
            try {
                doc = this.xmlSupport.readXMLFromFile(xmlFile);
            }
            catch (XMLException e) {
                throw new ComponentException("Failed to read " + xmlFile.getAbsolutePath(), (Throwable)e);
            }
            for (Map.Entry<String, TypedDatum> entry : dynamicInputs.entrySet()) {
                String xpath = componentContext.getInputMetaDataValue(entry.getKey(), "variable.xpath");
                TypedDatum value = entry.getValue();
                String valueAsString = this.getValueAsString(value);
                try {
                    this.xmlSupport.replaceNodeText(doc, xpath, valueAsString, Boolean.valueOf(true));
                    componentContext.getLog().componentInfo(StringUtils.format((String)"Set value of '%s' to the input value of '%s': %s", (Object[])new Object[]{xpath, entry.getKey(), value.toString()}));
                }
                catch (XMLException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to set value of '%s' to the value of input '%s': %s. ", (Object[])new Object[]{xpath, entry.getKey(), value.toString()}), (Throwable)e);
                }
            }
            try {
                this.xmlSupport.writeXMLtoFile(doc, xmlFile);
            }
            catch (XMLException e) {
                throw new ComponentException("Failed to write XML content to file: " + xmlFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private String getValueAsString(TypedDatum value) throws DataTypeException {
        switch (value.getDataType()) {
            case ShortText: {
                return String.valueOf(((ShortTextTD)value).getShortTextValue());
            }
            case Boolean: {
                return String.valueOf(((BooleanTD)value).getBooleanValue());
            }
            case Float: {
                return String.valueOf(((FloatTD)value).getFloatValue());
            }
            case Integer: {
                return String.valueOf(((IntegerTD)value).getIntValue());
            }
        }
        throw new DataTypeException("Can not convert value of type '" + value.getDataType().getDisplayName() + "' to textual representation for insertion into XML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOutputsFromXML(File xmlFile, ComponentContext componentContext) throws DataTypeException, ComponentException {
        if (!xmlFile.exists()) {
            throw new ComponentException(String.valueOf(xmlFile.getAbsolutePath()) + " does not exist");
        }
        Object object = XMLMapperConstants.GLOBAL_MAPPING_LOCK;
        synchronized (object) {
            Document doc = null;
            for (String outputName : componentContext.getOutputs()) {
                String valueAsString;
                String xpath;
                if (!componentContext.isDynamicOutput(outputName)) continue;
                if (doc == null) {
                    try {
                        doc = this.xmlSupport.readXMLFromFile(xmlFile);
                    }
                    catch (XMLException e) {
                        throw new ComponentException("Failed to read " + xmlFile.getAbsolutePath(), (Throwable)e);
                    }
                }
                this.recentXpath = xpath = componentContext.getOutputMetaDataValue(outputName, "variable.xpath");
                String message = StringUtils.format((String)"Failed to extract value for output '%s' that points to '%s'", (Object[])new Object[]{outputName, xpath});
                try {
                    valueAsString = this.xmlSupport.getElementText(doc, xpath);
                }
                catch (XMLException e) {
                    throw new ComponentException(message, (Throwable)e);
                }
                componentContext.getLog().componentInfo(StringUtils.format((String)"Extracted '%s' for XPath '%s' that will be sent to output '%s'", (Object[])new Object[]{valueAsString, xpath, outputName}));
                TypedDatum value = this.getValueAsTypedValue(outputName, valueAsString, componentContext);
                componentContext.writeOutput(outputName, value);
            }
        }
    }

    private TypedDatum getValueAsTypedValue(String outputName, String rawValue, ComponentContext componentContext) throws DataTypeException {
        ShortTextTD value;
        String errorMessage = "Can not convert value '%s' to '%s' that is the required data type of output '%s' this value should be sent to";
        TypedDatumFactory typedDatumFactory = ((TypedDatumService)componentContext.getService(TypedDatumService.class)).getFactory();
        try {
            switch (componentContext.getOutputDataType(outputName)) {
                case ShortText: {
                    value = typedDatumFactory.createShortText(rawValue);
                    break;
                }
                case Boolean: {
                    value = typedDatumFactory.createBoolean(Boolean.valueOf(rawValue).booleanValue());
                    break;
                }
                case Float: {
                    value = typedDatumFactory.createFloat(Double.valueOf(rawValue).doubleValue());
                    break;
                }
                case Integer: {
                    value = typedDatumFactory.createInteger(Long.valueOf(rawValue).longValue());
                    break;
                }
                default: {
                    throw new DataTypeException(StringUtils.format((String)errorMessage, (Object[])new Object[]{rawValue, componentContext.getOutputDataType(outputName).getDisplayName(), outputName}));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataTypeException(StringUtils.format((String)errorMessage, (Object[])new Object[]{rawValue, componentContext.getOutputDataType(outputName).getDisplayName(), outputName}));
        }
        return value;
    }

    @Override
    public String getRecentXpath() {
        return this.recentXpath;
    }
}

