/*
 * Decompiled with CFR 0.152.
 */
package nu.psnet.quickimage.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import nu.psnet.quickimage.core.ImageFileFilter;
import nu.psnet.quickimage.core.ImageHolder;
import nu.psnet.quickimage.core.QManager;
import org.eclipse.core.resources.IStorage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageOrganizer {
    public static final int VIEW_THUMB = 0;
    public static final int VIEW_FULLSIZE = 1;
    public String path;
    public String filename;
    private int index = 0;
    private ArrayList<ImageHolder> holders = new ArrayList();
    private Display display;
    private int activeView = 1;
    private QManager manager;

    public ImageOrganizer(QManager manager, Display display) {
        this.manager = manager;
        this.display = display;
    }

    public void setStorage(IStorage storage) {
        this.path = null;
        this.filename = null;
        this.holders.clear();
        ImageHolder holder = new ImageHolder(this.manager, this.display);
        holder.setStorage(storage);
        this.holders.add(holder);
    }

    public void setPath(String path, String filename) {
        this.path = path;
        this.filename = filename;
        this.initList();
    }

    private ImageHolder holder(int index) {
        return this.holders.get(index);
    }

    public void removeHolder(ImageHolder holder) {
        this.holders.remove(holder);
        while (this.index >= this.holders.size() && this.index > 0) {
            --this.index;
        }
        this.manager.getImageEditor().setPartName(this.getCurrent().getDisplayName());
    }

    public void removeHolder(int index) {
        this.holders.remove(index);
        while (index >= this.holders.size() && index > 0) {
            --index;
        }
    }

    public ImageHolder getNext() {
        if (this.holder(this.index).getFullsize() != null && !this.holder(this.index).getFullsize().isDisposed()) {
            this.holder(this.index).getFullsize().dispose();
        }
        this.index = (this.index + 1) % this.holders.size();
        return this.holder(this.index);
    }

    public int getCount() {
        return this.holders.size();
    }

    public boolean isSingle() {
        return this.getHolders().size() == 1;
    }

    public ArrayList<ImageHolder> getHolders() {
        return this.holders;
    }

    public ImageHolder getPrevious() {
        if (this.holder(this.index).getFullsize() != null && !this.holder(this.index).getFullsize().isDisposed()) {
            this.holder(this.index).getFullsize().dispose();
        }
        if (this.index > 0) {
            --this.index;
        }
        return this.holder(this.index);
    }

    public boolean hasNext() {
        return this.holders.size() - 1 != this.index;
    }

    public boolean hasPrevious() {
        return this.index != 0;
    }

    public ImageHolder getCurrent() {
        return this.holder(this.index);
    }

    public int getTotalWidth() {
        return 0;
    }

    private void initList() {
        File f = new File(this.path);
        File[] files = f.listFiles(new ImageFileFilter());
        if (files != null) {
            String[] sfiles = new String[files.length];
            int i = 0;
            while (i < files.length) {
                sfiles[i] = files[i].getAbsolutePath();
                ++i;
            }
            Arrays.sort(sfiles, String.CASE_INSENSITIVE_ORDER);
            i = 0;
            while (i < sfiles.length) {
                if (sfiles[i].endsWith(this.filename)) {
                    this.index = i;
                }
                ImageHolder h = new ImageHolder(this.manager, this.display);
                h.setFile(new File(sfiles[i]));
                this.holders.add(h);
                ++i;
            }
        }
    }

    public Point getThumbWidth() {
        if (this.holders == null) {
            return new Point(1, 1);
        }
        return this.holder(0).getThumbDimension();
    }

    public int getActiveView() {
        return this.activeView;
    }

    public void setActiveView(int activeView) {
        this.activeView = activeView;
    }

    public boolean selectHolder(int x, int y) {
        boolean tmp = false;
        boolean found = false;
        int i = 0;
        while (i < this.holders.size()) {
            tmp = this.holder(i).mouseClickedOver(x, y);
            if (tmp && !found) {
                if (this.holder(this.index).hasFullsize() && !this.holder(this.index).getFullsize().isDisposed()) {
                    this.holder(this.index).getFullsize().dispose();
                }
                this.index = i;
                found = true;
                this.holder(i).setSelected(true);
            } else {
                this.holder(i).setSelected(false);
            }
            ++i;
        }
        return found;
    }

    public void setCurrentToSelected() {
        int i = 0;
        while (i < this.holders.size()) {
            if (this.holder(i).isSelected()) {
                this.holder(this.index).getFullsize().dispose();
                this.holder(i).setSelected(false);
            }
            ++i;
        }
        this.getCurrent().setSelected(true);
    }

    public void setSelectedToCurrent() {
        int i = 0;
        while (i < this.holders.size()) {
            if (this.holder(i).isSelected()) {
                this.holder(this.index).getFullsize().dispose();
                this.index = i;
                break;
            }
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.holders.size()) {
            this.holder(i).dispose();
            ++i;
        }
    }
}

