/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.RemotableSystemMonitoringService;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataSnapshotListener;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncSystemMonitoringDataFetchTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(AsyncSystemMonitoringDataFetchTask.class);
    private RemotableSystemMonitoringService service;
    private SystemMonitoringDataSnapshotListener listener;

    public AsyncSystemMonitoringDataFetchTask(SystemMonitoringDataSnapshotListener callbackListener, RemotableSystemMonitoringService service) {
        this.listener = callbackListener;
        this.service = service;
    }

    @Override
    @TaskDescription(value="Fetching monitoring data...")
    public void run() {
        try {
            this.listener.onMonitoringDataChanged(this.service.getCompleteSnapshot());
        }
        catch (OperatingSystemException | RemoteOperationException e) {
            LOGGER.warn((Object)("Error fetching monitoring data: " + e.toString()));
        }
    }
}

